/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.sqm;

import java.util.function.Supplier;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.query.criteria.spi.ParameterExpression;
import org.hibernate.query.sqm.consume.spi.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class JpaParameterSqmWrapper
implements SqmParameter {
    private final ParameterExpression jpaParameterExpression;
    private final boolean allowMultiValuedBinding;
    private AllowableParameterType parameterType;
    private Supplier<? extends ExpressableType> impliedTypeAccess;

    public JpaParameterSqmWrapper(ParameterExpression jpaParameterExpression, boolean allowMultiValuedBinding) {
        this.jpaParameterExpression = jpaParameterExpression;
        this.allowMultiValuedBinding = allowMultiValuedBinding;
    }

    public ParameterExpression<?> getJpaParameterExpression() {
        return this.jpaParameterExpression;
    }

    @Override
    public String getName() {
        return this.jpaParameterExpression.getName();
    }

    @Override
    public Integer getPosition() {
        return null;
    }

    @Override
    public boolean allowMultiValuedBinding() {
        return this.allowMultiValuedBinding;
    }

    @Override
    public AllowableParameterType getAnticipatedType() {
        return this.getExpressableType();
    }

    @Override
    public AllowableParameterType getExpressableType() {
        ExpressableType type;
        if (this.impliedTypeAccess != null && (type = this.impliedTypeAccess.get()) != null) {
            if (type instanceof AllowableParameterType) {
                return (AllowableParameterType)type;
            }
            throw new IllegalArgumentException("Parameter type inference returned a type that cannot be used as a parameter - " + type);
        }
        return this.parameterType;
    }

    @Override
    public SqmParameter copy() {
        return new JpaParameterSqmWrapper(this.getJpaParameterExpression(), this.allowMultiValuedBinding());
    }

    @Override
    public Supplier<? extends ExpressableType> getInferableType() {
        return () -> this.parameterType;
    }

    @Override
    public void impliedType(Supplier<? extends ExpressableType> inference) {
        this.impliedTypeAccess = inference;
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getExpressableType().getJavaTypeDescriptor();
    }

    @Override
    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitJpaParameterWrapper(this);
    }
}

