/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.query.hql.DotIdentifierConsumer;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.produce.SqmCreationProcessingState;
import org.hibernate.query.sqm.produce.SqmPathRegistry;
import org.hibernate.query.sqm.produce.path.internal.SqmStaticEnumReference;
import org.hibernate.query.sqm.produce.path.internal.SqmStaticFieldReference;
import org.hibernate.query.sqm.produce.path.spi.SemanticPathPart;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.EnumJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.jboss.logging.Logger;

public class BasicDotIdentifierConsumer
implements DotIdentifierConsumer {
    private static final Logger log = Logger.getLogger(BasicDotIdentifierConsumer.class);
    private final Supplier<SqmCreationProcessingState> processingStateSupplier;
    private String pathSoFar;
    private SemanticPathPart currentPart;

    public BasicDotIdentifierConsumer(Supplier<SqmCreationProcessingState> processingStateSupplier) {
        this.processingStateSupplier = processingStateSupplier;
    }

    public BasicDotIdentifierConsumer(SemanticPathPart initialState, Supplier<SqmCreationProcessingState> processingStateSupplier) {
        this.currentPart = initialState;
        this.processingStateSupplier = processingStateSupplier;
    }

    @Override
    public SemanticPathPart getConsumedPart() {
        return this.currentPart;
    }

    protected SqmCreationProcessingState getCreationProcessingState() {
        return this.processingStateSupplier.get();
    }

    @Override
    public void consumeIdentifier(String identifier, boolean isBase, boolean isTerminal) {
        if (isBase) {
            this.reset();
        }
        this.pathSoFar = this.pathSoFar == null ? identifier : this.pathSoFar + '.' + identifier;
        log.tracef("BasicDotIdentifierHandler#consumeIdentifier( %s, %s, %s ) - %s", new Object[]{identifier, isBase, isTerminal, this.pathSoFar});
        this.currentPart = this.currentPart.resolvePathPart(identifier, this.pathSoFar, isTerminal, this.processingStateSupplier.get().getCreationState());
    }

    protected void reset() {
        this.pathSoFar = null;
        this.currentPart = this.createBasePart();
    }

    protected SemanticPathPart createBasePart() {
        return new BaseLocalSequencePart();
    }

    public class BaseLocalSequencePart
    implements SemanticPathPart {
        private boolean isBase = true;

        @Override
        public SemanticPathPart resolvePathPart(String identifier, String currentContextKey, boolean isTerminal, SqmCreationState creationState) {
            block13: {
                if (this.isBase) {
                    this.isBase = false;
                    SqmPathRegistry sqmPathRegistry = creationState.getProcessingStateStack().getCurrent().getPathRegistry();
                    SqmFrom pathRootByAlias = sqmPathRegistry.findFromByAlias(identifier);
                    if (pathRootByAlias != null) {
                        this.validateAsRoot(pathRootByAlias);
                        return pathRootByAlias;
                    }
                    SqmFrom pathRootByExposedNavigable = sqmPathRegistry.findFromExposing(identifier);
                    if (pathRootByExposedNavigable != null) {
                        this.validateAsRoot(pathRootByExposedNavigable);
                        Navigable referencedNavigable = pathRootByExposedNavigable.getReferencedNavigable().findNavigable(identifier);
                        if (isTerminal) {
                            return referencedNavigable.createSqmExpression(pathRootByExposedNavigable, creationState);
                        }
                        if (referencedNavigable instanceof Joinable) {
                            return ((Joinable)referencedNavigable).createJoin(pathRootByExposedNavigable, SqmJoinType.INNER, null, false, creationState);
                        }
                    }
                }
                if (!isTerminal) {
                    return this;
                }
                int splitPosition = BasicDotIdentifierConsumer.this.pathSoFar.lastIndexOf(46);
                if (splitPosition > 0) {
                    String prefix = BasicDotIdentifierConsumer.this.pathSoFar.substring(0, splitPosition);
                    String terminal = BasicDotIdentifierConsumer.this.pathSoFar.substring(splitPosition + 1);
                    try {
                        Object referencedEnum;
                        Class namedClass = creationState.getCreationContext().getServiceRegistry().getService(ClassLoaderService.class).classForName(prefix);
                        if (namedClass == null) break block13;
                        try {
                            Field referencedField = namedClass.getDeclaredField(terminal);
                            if (referencedField != null) {
                                JavaTypeDescriptor<?> fieldJtd = creationState.getCreationContext().getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(referencedField.getType());
                                return new SqmStaticFieldReference(referencedField, (BasicJavaDescriptor)fieldJtd);
                            }
                        }
                        catch (Exception referencedField) {
                            // empty catch block
                        }
                        if (namedClass.isEnum() && (referencedEnum = Enum.valueOf(namedClass, terminal)) != null) {
                            JavaTypeDescriptor enumJtd = creationState.getCreationContext().getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(namedClass);
                            return new SqmStaticEnumReference((Enum)referencedEnum, (EnumJavaDescriptor)enumJtd);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            throw new ParsingException("Could not interpret dot-ident : " + BasicDotIdentifierConsumer.this.pathSoFar);
        }

        protected void validateAsRoot(SqmFrom pathRoot) {
        }

        @Override
        public SqmPath resolveIndexedAccess(SqmExpression selector, String currentContextKey, boolean isTerminal, SqmCreationState processingState) {
            return BasicDotIdentifierConsumer.this.currentPart.resolveIndexedAccess(selector, currentContextKey, isTerminal, processingState);
        }
    }
}

