/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.hibernate.query.QueryLogger;
import org.hibernate.query.hql.internal.HqlParser;
import org.hibernate.query.hql.internal.HqlParserBaseListener;
import org.jboss.logging.Logger;

public class HqlParseTreePrinter
extends HqlParserBaseListener {
    private static final Logger HQL_LOGGER = QueryLogger.subLogger("hql.parseTree");
    private static final boolean LOG_DEBUG_ENABLED = HQL_LOGGER.isDebugEnabled();
    private final HqlParser parser;
    private final StringBuffer buffer = new StringBuffer();
    private int depth = 2;

    public static void logStatementParseTree(HqlParser parser) {
        if (!LOG_DEBUG_ENABLED) {
            return;
        }
        HqlParseTreePrinter walker = new HqlParseTreePrinter(parser);
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)walker, (ParseTree)parser.statement());
        HQL_LOGGER.debugf("HQL parse-tree:\n%s", (Object)walker.buffer.toString());
        parser.reset();
    }

    public static void logOrderByParseTree(HqlParser parser) {
        if (!LOG_DEBUG_ENABLED) {
            return;
        }
        HqlParseTreePrinter walker = new HqlParseTreePrinter(parser);
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)walker, (ParseTree)parser.orderByClause());
        HQL_LOGGER.debugf("Mapping order-by parse-tree:\n%s", (Object)walker.buffer.toString());
        parser.reset();
    }

    public HqlParseTreePrinter(HqlParser parser) {
        this.parser = parser;
    }

    @Override
    public void enterEveryRule(ParserRuleContext ctx) {
        String ruleName = this.parser.getRuleNames()[ctx.getRuleIndex()];
        if (!ruleName.endsWith("Keyword")) {
            this.applyLine(LineType.ENTER, ruleName, this.ruleTypeName(ctx.getClass()), ctx.getText());
        }
        super.enterEveryRule(ctx);
    }

    private String ruleTypeName(Class<? extends ParserRuleContext> ruleCtxClass) {
        String name = ruleCtxClass.getSimpleName();
        int position = name.lastIndexOf("Context");
        if (position > 1) {
            return name.substring(0, position);
        }
        return name;
    }

    private void applyLine(LineType lineType, String ruleName, String ruleTypeName, String ctxText) {
        this.applyLinePadding(lineType);
        this.buffer.append('[').append(ruleName);
        if (!ruleTypeName.equalsIgnoreCase(ruleName)) {
            this.buffer.append(" (").append(ruleTypeName).append(')');
        }
        this.buffer.append(']').append(" - `").append(ctxText).append('`').append('\n');
    }

    private void applyLinePadding(LineType lineType) {
        if (lineType == LineType.ENTER) {
            this.pad(this.depth++);
            this.buffer.append("-> ");
        } else {
            this.pad(--this.depth);
            this.buffer.append("<- ");
        }
    }

    private String pad(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.buffer.append("  ");
        }
        return this.buffer.toString();
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
        super.exitEveryRule(ctx);
        String ruleName = this.parser.getRuleNames()[ctx.getRuleIndex()];
        this.applyLine(LineType.EXIT, ruleName, this.ruleTypeName(ctx.getClass()), ctx.getText());
    }

    private static enum LineType {
        ENTER,
        EXIT;

    }
}

