/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.Locale;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.query.hql.DotIdentifierConsumer;
import org.hibernate.query.sqm.SemanticException;
import org.hibernate.query.sqm.produce.SqmCreationProcessingState;
import org.hibernate.query.sqm.produce.path.spi.SemanticPathPart;
import org.hibernate.query.sqm.produce.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;

public class QualifiedJoinPathIdentifierConsumer
implements DotIdentifierConsumer {
    private final SqmJoinType joinType;
    private final boolean fetch;
    private final String alias;
    private final SqmRoot sqmRoot;
    private final SqmCreationProcessingState processingState;
    private final SqmCreationContext sqmCreationContext;
    private String completePath = null;
    private SqmFrom current = null;

    public QualifiedJoinPathIdentifierConsumer(SqmJoinType joinType, boolean fetch, String alias, SqmRoot sqmRoot, SqmCreationProcessingState processingState) {
        this.joinType = joinType;
        this.fetch = fetch;
        this.alias = alias;
        this.sqmRoot = sqmRoot;
        this.processingState = processingState;
        this.sqmCreationContext = processingState.getCreationState().getCreationContext();
    }

    @Override
    public SemanticPathPart getConsumedPart() {
        return this.current;
    }

    @Override
    public void consumeIdentifier(String identifier, boolean isBase, boolean isTerminal) {
        this.completePath = this.completePath == null ? identifier : this.completePath + '.' + identifier;
        if (this.current == null) {
            SqmFrom pathRootByAlias = this.processingState.getPathRegistry().findFromByAlias(identifier);
            if (pathRootByAlias != null) {
                this.current = pathRootByAlias;
                return;
            }
            SqmFrom pathRootByExposedNavigable = this.processingState.getPathRegistry().findFromExposing(identifier);
            if (pathRootByExposedNavigable != null) {
                this.current = pathRootByExposedNavigable;
            } else if (isTerminal) {
                EntityTypeDescriptor entityDescriptor = this.sqmCreationContext.getDomainModel().findEntityDescriptor(this.completePath);
                if (entityDescriptor != null) {
                    this.current = new SqmEntityJoin(entityDescriptor, this.alias, this.joinType, this.sqmRoot);
                    return;
                }
            } else {
                return;
            }
        }
        if (this.current == null) {
            throw new SemanticException("Could not resolve qualified join path - " + identifier);
        }
        Navigable navigable = this.current.getReferencedNavigable().findNavigable(identifier);
        if (navigable == null) {
            throw new SemanticException(String.format(Locale.ROOT, "Could not resolve path - %s -> %s", this.current.getNavigablePath().getFullPath(), identifier));
        }
        if (!(navigable instanceof NavigableContainer)) {
            throw new SemanticException(String.format(Locale.ROOT, "Path cannot be de-referenced - %s -> %s", this.current.getNavigablePath().getFullPath(), identifier));
        }
        SqmFrom lhs = this.current;
        Navigable joinedNavigable = lhs.getReferencedNavigable().findNavigable(identifier);
        if (!(joinedNavigable instanceof Joinable)) {
            throw new SemanticException("Joined path is not joinable: " + this.completePath);
        }
        this.current = ((Joinable)joinedNavigable).createJoin(lhs, this.joinType, isTerminal ? this.alias : null, this.fetch, this.processingState.getCreationState());
        lhs.addJoin((SqmJoin)this.current);
    }
}

