/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.Locale;
import java.util.function.Supplier;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.sqm.SemanticException;
import org.hibernate.query.sqm.produce.SqmCreationProcessingState;
import org.hibernate.query.sqm.produce.path.spi.SemanticPathPart;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;

public class QualifiedJoinPredicateDotIdentifierConsumer
extends BasicDotIdentifierConsumer {
    private final SqmQualifiedJoin joinRhs;
    private final String predicateText;

    public QualifiedJoinPredicateDotIdentifierConsumer(Supplier<SqmCreationProcessingState> processingStateSupplier, SqmQualifiedJoin joinRhs, String predicateText) {
        super(processingStateSupplier);
        this.joinRhs = joinRhs;
        this.predicateText = predicateText;
    }

    @Override
    protected SemanticPathPart createBasePart() {
        return new BasicDotIdentifierConsumer.BaseLocalSequencePart(){

            @Override
            protected void validateAsRoot(SqmFrom pathRoot) {
                if (pathRoot.findRoot() != QualifiedJoinPredicateDotIdentifierConsumer.this.joinRhs.findRoot()) {
                    throw new SemanticException(String.format(Locale.ROOT, "SqmQualifiedJoin predicate referred to SqmRoot [`%s`] other than the join's root [`%s`] - `%s`", pathRoot.getNavigablePath().getFullPath(), QualifiedJoinPredicateDotIdentifierConsumer.this.joinRhs.getNavigablePath().getFullPath(), QualifiedJoinPredicateDotIdentifierConsumer.this.predicateText));
                }
                super.validateAsRoot(pathRoot);
            }
        };
    }
}

