/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.Token;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.SortOrder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.collection.spi.CollectionClassification;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.model.domain.spi.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.IdentifiableTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralValuedNavigable;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.QueryLogger;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.hql.DotIdentifierConsumer;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.hql.internal.HqlParser;
import org.hibernate.query.hql.internal.HqlParserBaseVisitor;
import org.hibernate.query.hql.internal.QualifiedJoinPathIdentifierConsumer;
import org.hibernate.query.hql.internal.QualifiedJoinPredicateDotIdentifierConsumer;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.query.sqm.LiteralNumberFormatException;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SemanticException;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.UnknownEntityException;
import org.hibernate.query.sqm.produce.SqmCreationProcessingState;
import org.hibernate.query.sqm.produce.SqmProductionException;
import org.hibernate.query.sqm.produce.SqmQuerySpecCreationProcessingState;
import org.hibernate.query.sqm.produce.SqmTreeCreationLogger;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.internal.SqmDmlCreationProcessingState;
import org.hibernate.query.sqm.produce.internal.SqmQuerySpecCreationProcessingStateStandardImpl;
import org.hibernate.query.sqm.produce.internal.UniqueIdGenerator;
import org.hibernate.query.sqm.produce.path.spi.SemanticPathPart;
import org.hibernate.query.sqm.produce.spi.ImplicitAliasGenerator;
import org.hibernate.query.sqm.produce.spi.ParameterDeclarationContext;
import org.hibernate.query.sqm.produce.spi.SqmCreationContext;
import org.hibernate.query.sqm.produce.spi.SqmCreationOptions;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.produce.spi.TrimSpecificationExpressionWrapper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMaxElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMaxIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmMinElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMinIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.InferableTypeSqmExpression;
import org.hibernate.query.sqm.tree.expression.LiteralHelper;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmConcat;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmSubQuery;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.expression.function.Distinctable;
import org.hibernate.query.sqm.tree.expression.function.SqmAbsFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmAggregateFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmAvgFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCastFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCoalesceFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmConcatFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCountFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCountStarFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmGenericFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmLengthFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmLowerFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmMaxFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmMinFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmNullifFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmStrFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmSubstringFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmSumFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmTrimFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmUpperFunction;
import org.hibernate.query.sqm.tree.from.DowncastLocation;
import org.hibernate.query.sqm.tree.from.MutableUsageDetails;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmNavigableJoin;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.internal.ParameterCollector;
import org.hibernate.query.sqm.tree.predicate.AndSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.BetweenSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.EmptinessSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.GroupedSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.InListSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.InSubQuerySqmPredicate;
import org.hibernate.query.sqm.tree.predicate.LikeSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.MemberOfSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.NegatableSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.NegatedSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.NullnessSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.OrSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.TrimSpecification;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.produce.metamodel.spi.EntityValuedExpressableType;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.spi.StandardSpiBasicTypes;
import org.jboss.logging.Logger;

public class SemanticQueryBuilder
extends HqlParserBaseVisitor
implements SqmCreationState {
    private static final Logger log = Logger.getLogger(SemanticQueryBuilder.class);
    private final SqmCreationOptions creationOptions;
    private final SqmCreationContext creationContext;
    private final ImplicitAliasGenerator implicitAliasGenerator;
    private final UniqueIdGenerator uidGenerator;
    private final Stack<DotIdentifierConsumer> identifierConsumerStack;
    private final Stack<TreatHandler> treatHandlerStack = new StandardStack<TreatHandlerNormal>(new TreatHandlerNormal());
    private final Stack<ParameterDeclarationContext> parameterDeclarationContextStack = new StandardStack<ParameterDeclarationContext>();
    private final Stack<SqmCreationProcessingState> processingStateStack = new StandardStack<SqmCreationProcessingState>();
    private ParameterCollector parameterCollector;
    private JavaTypeDescriptor<List> listJavaTypeDescriptor;
    private JavaTypeDescriptor<Map> mapJavaTypeDescriptor;

    public static SqmStatement buildSemanticModel(HqlParser.StatementContext statement, SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        return new SemanticQueryBuilder(creationOptions, creationContext).visitStatement(statement);
    }

    @Override
    public Stack<SqmCreationProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    protected SemanticQueryBuilder(SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        this.creationOptions = creationOptions;
        this.creationContext = creationContext;
        this.implicitAliasGenerator = new ImplicitAliasGenerator();
        this.uidGenerator = new UniqueIdGenerator();
        this.identifierConsumerStack = new StandardStack<BasicDotIdentifierConsumer>(new BasicDotIdentifierConsumer(this.processingStateStack::getCurrent));
    }

    @Override
    public SqmCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqmCreationOptions getCreationOptions() {
        return this.creationOptions;
    }

    @Override
    public ImplicitAliasGenerator getImplicitAliasGenerator() {
        return this.implicitAliasGenerator;
    }

    @Override
    public String generateUniqueIdentifier() {
        return this.uidGenerator.generateUniqueId();
    }

    @Override
    public SqmQuerySpecCreationProcessingState getCurrentQuerySpecProcessingState() {
        SqmCreationProcessingState current = this.processingStateStack.getCurrent();
        if (current instanceof SqmQuerySpecCreationProcessingState) {
            return (SqmQuerySpecCreationProcessingState)current;
        }
        throw new UnsupportedOperationException("Current processing state is not related to a SqmQuerySpec : " + current);
    }

    protected <T> void primeStack(Stack<T> stack, T initialValue) {
        stack.push(initialValue);
    }

    protected Stack<ParameterDeclarationContext> getParameterDeclarationContextStack() {
        return this.parameterDeclarationContextStack;
    }

    public Stack<DotIdentifierConsumer> getIdentifierConsumerStack() {
        return this.identifierConsumerStack;
    }

    @Override
    public SqmStatement visitStatement(HqlParser.StatementContext ctx) {
        this.parameterDeclarationContextStack.push(() -> false);
        try {
            if (ctx.selectStatement() != null) {
                SqmSelectStatement sqmSelectStatement = this.visitSelectStatement(ctx.selectStatement());
                return sqmSelectStatement;
            }
            if (ctx.insertStatement() != null) {
                SqmInsertSelectStatement sqmInsertSelectStatement = this.visitInsertStatement(ctx.insertStatement());
                return sqmInsertSelectStatement;
            }
            if (ctx.updateStatement() != null) {
                SqmUpdateStatement sqmUpdateStatement = this.visitUpdateStatement(ctx.updateStatement());
                return sqmUpdateStatement;
            }
            if (ctx.deleteStatement() != null) {
                SqmDeleteStatement sqmDeleteStatement = this.visitDeleteStatement(ctx.deleteStatement());
                return sqmDeleteStatement;
            }
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
        throw new ParsingException("Unexpected statement type [not INSERT, UPDATE, DELETE or SELECT] : " + ctx.getText());
    }

    @Override
    public SqmSelectStatement visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance() && ctx.querySpec().selectClause() == null) {
            throw new StrictJpaComplianceViolation("Encountered implicit select-clause, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.IMPLICIT_SELECT);
        }
        SqmSelectStatement selectStatement = new SqmSelectStatement();
        this.parameterCollector = selectStatement;
        selectStatement.setQuerySpec(this.visitQuerySpec(ctx.querySpec()));
        return selectStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmInsertSelectStatement visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        this.processingStateStack.push(new SqmDmlCreationProcessingState(this));
        try {
            Object targetType = this.visitEntityName(ctx.insertSpec().intoSpec().entityName());
            String alias = this.getImplicitAliasGenerator().generateUniqueImplicitAlias();
            log.debugf("Generated implicit alias [%s] for INSERT target [%s]", (Object)alias, (Object)targetType.getEntityName());
            SqmRoot root = new SqmRoot((EntityTypeDescriptor)targetType, null);
            this.processingStateStack.getCurrent().getPathRegistry().register(root);
            SqmInsertSelectStatement insertStatement = new SqmInsertSelectStatement(root);
            this.parameterCollector = insertStatement;
            insertStatement.setSelectQuerySpec(this.visitQuerySpec(ctx.querySpec()));
            for (HqlParser.DotIdentifierSequenceContext stateFieldCtx : ctx.insertSpec().targetFieldsSpec().dotIdentifierSequence()) {
                SqmPath stateField = (SqmPath)this.visitDotIdentifierSequence(stateFieldCtx);
                insertStatement.addInsertTargetStateField(stateField);
            }
            SqmInsertSelectStatement sqmInsertSelectStatement = insertStatement;
            return sqmInsertSelectStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmUpdateStatement visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        this.processingStateStack.push(new SqmDmlCreationProcessingState(this));
        try {
            SqmRoot root = new SqmRoot((EntityTypeDescriptor)this.visitEntityName(ctx.entityName()), this.visitIdentificationVariableDef(ctx.identificationVariableDef()));
            SqmUpdateStatement updateStatement = new SqmUpdateStatement(root);
            this.parameterCollector = updateStatement;
            updateStatement.getWhereClause().setPredicate((SqmPredicate)ctx.whereClause().predicate().accept(this));
            for (HqlParser.AssignmentContext assignmentContext : ctx.setClause().assignment()) {
                SqmPath stateField = this.consumeDomainPath(assignmentContext.dotIdentifierSequence());
                updateStatement.getSetClause().addAssignment(stateField, (SqmExpression)assignmentContext.expression().accept(this));
            }
            SqmUpdateStatement sqmUpdateStatement = updateStatement;
            return sqmUpdateStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmDeleteStatement visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        this.processingStateStack.push(new SqmDmlCreationProcessingState(this));
        try {
            SqmDeleteStatement deleteStatement;
            SqmRoot root = new SqmRoot((EntityTypeDescriptor)this.visitEntityName(ctx.entityName()), this.visitIdentificationVariableDef(ctx.identificationVariableDef()));
            this.parameterCollector = deleteStatement = new SqmDeleteStatement(root);
            if (ctx.whereClause() != null && ctx.whereClause().predicate() != null) {
                deleteStatement.getWhereClause().setPredicate((SqmPredicate)ctx.whereClause().predicate().accept(this));
            }
            SqmDeleteStatement sqmDeleteStatement = deleteStatement;
            return sqmDeleteStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmQuerySpec visitQuerySpec(HqlParser.QuerySpecContext ctx) {
        SqmQuerySpec sqmQuerySpec = new SqmQuerySpec();
        this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), this));
        try {
            SqmOrderByClause orderByClause;
            SqmSelectClause selectClause;
            this.treatHandlerStack.push(new TreatHandlerFromClause());
            try {
                sqmQuerySpec.setFromClause(this.visitFromClause(ctx.fromClause()));
            }
            finally {
                this.treatHandlerStack.pop();
            }
            if (ctx.selectClause() != null) {
                selectClause = this.visitSelectClause(ctx.selectClause());
            } else {
                log.debugf("Encountered implicit select clause : " + ctx.getText(), new Object[0]);
                selectClause = this.buildInferredSelectClause(sqmQuerySpec.getFromClause());
            }
            sqmQuerySpec.setSelectClause(selectClause);
            SqmWhereClause whereClause = new SqmWhereClause();
            if (ctx.whereClause() != null) {
                this.treatHandlerStack.push(new TreatHandlerNormal(DowncastLocation.WHERE));
                try {
                    whereClause.setPredicate((SqmPredicate)ctx.whereClause().accept(this));
                }
                finally {
                    this.treatHandlerStack.pop();
                }
            }
            sqmQuerySpec.setWhereClause(whereClause);
            if (ctx.orderByClause() != null) {
                if (this.creationOptions.useStrictJpaCompliance() && this.processingStateStack.depth() > 1) {
                    throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SUBQUERY_ORDER_BY);
                }
                orderByClause = this.visitOrderByClause(ctx.orderByClause());
            } else {
                orderByClause = new SqmOrderByClause();
            }
            sqmQuerySpec.setOrderByClause(orderByClause);
            if (ctx.limitClause() != null || ctx.offsetClause() != null) {
                if (this.getCreationOptions().useStrictJpaCompliance()) {
                    throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.LIMIT_OFFSET_CLAUSE);
                }
                if (this.processingStateStack.depth() > 1 && orderByClause == null) {
                    throw new SemanticException("limit and offset clause require an order-by clause when used in sub-query");
                }
                sqmQuerySpec.setOffsetExpression(this.visitOffsetClause(ctx.offsetClause()));
                sqmQuerySpec.setLimitExpression(this.visitLimitClause(ctx.limitClause()));
            }
            SqmQuerySpec sqmQuerySpec2 = sqmQuerySpec;
            return sqmQuerySpec2;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    protected SqmSelectClause buildInferredSelectClause(SqmFromClause fromClause) {
        SqmSelectClause selectClause = new SqmSelectClause(false);
        fromClause.visitRoots(sqmRoot -> selectClause.addSelection(new SqmSelection((SqmSelectableNode)sqmRoot, sqmRoot.getExplicitAlias())));
        return selectClause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSelectClause visitSelectClause(HqlParser.SelectClauseContext ctx) {
        this.treatHandlerStack.push(new TreatHandlerNormal(DowncastLocation.SELECT));
        try {
            SqmSelectClause selectClause = new SqmSelectClause(ctx.DISTINCT() != null);
            for (HqlParser.SelectionContext selectionContext : ctx.selectionList().selection()) {
                selectClause.addSelection(this.visitSelection(selectionContext));
            }
            SqmSelectClause sqmSelectClause = selectClause;
            return sqmSelectClause;
        }
        finally {
            this.treatHandlerStack.pop();
        }
    }

    @Override
    public SqmSelection visitSelection(HqlParser.SelectionContext ctx) {
        String resultIdentifier = this.visitResultIdentifier(ctx.resultIdentifier());
        SqmSelectableNode selectableNode = this.visitSelectableNode(ctx);
        SqmSelection selection = new SqmSelection(selectableNode, resultIdentifier);
        this.getCurrentQuerySpecProcessingState().registerSelection(selection);
        return selection;
    }

    private SqmSelectableNode visitSelectableNode(HqlParser.SelectionContext ctx) {
        if (ctx.selectExpression().dynamicInstantiation() != null) {
            return this.visitDynamicInstantiation(ctx.selectExpression().dynamicInstantiation());
        }
        if (ctx.selectExpression().jpaSelectObjectSyntax() != null) {
            return this.visitJpaSelectObjectSyntax(ctx.selectExpression().jpaSelectObjectSyntax());
        }
        if (ctx.selectExpression().mapEntrySelection() != null) {
            return this.visitMapEntrySelection(ctx.selectExpression().mapEntrySelection());
        }
        if (ctx.selectExpression().expression() != null) {
            return (SqmExpression)ctx.selectExpression().expression().accept(this);
        }
        throw new ParsingException("Unexpected selection rule type : " + ctx.getText());
    }

    @Override
    public String visitResultIdentifier(HqlParser.ResultIdentifierContext resultIdentifierContext) {
        if (resultIdentifierContext != null) {
            if (resultIdentifierContext.AS() != null) {
                Token aliasToken = resultIdentifierContext.identifier().getStart();
                String explicitAlias = aliasToken.getText();
                if (aliasToken.getType() != 149 && this.creationOptions.useStrictJpaCompliance()) {
                    throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), explicitAlias), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
                }
                return explicitAlias;
            }
            return resultIdentifierContext.getText();
        }
        return null;
    }

    @Override
    public SqmDynamicInstantiation visitDynamicInstantiation(HqlParser.DynamicInstantiationContext ctx) {
        SqmDynamicInstantiation dynamicInstantiation;
        if (ctx.dynamicInstantiationTarget().MAP() != null) {
            if (this.mapJavaTypeDescriptor == null) {
                this.mapJavaTypeDescriptor = this.creationContext.getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(Map.class);
            }
            dynamicInstantiation = SqmDynamicInstantiation.forMapInstantiation(this.mapJavaTypeDescriptor);
        } else if (ctx.dynamicInstantiationTarget().LIST() != null) {
            if (this.listJavaTypeDescriptor == null) {
                this.listJavaTypeDescriptor = this.creationContext.getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(List.class);
            }
            dynamicInstantiation = SqmDynamicInstantiation.forListInstantiation(this.listJavaTypeDescriptor);
        } else {
            String className = ctx.dynamicInstantiationTarget().dotIdentifierSequence().getText();
            try {
                Class targetJavaType = this.classForName(className);
                JavaTypeDescriptor jtd = this.creationContext.getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getOrMakeJavaDescriptor(targetJavaType);
                dynamicInstantiation = SqmDynamicInstantiation.forClassInstantiation(jtd);
            }
            catch (ClassLoadingException e) {
                throw new SemanticException("Unable to resolve class named for dynamic instantiation : " + className);
            }
        }
        for (HqlParser.DynamicInstantiationArgContext arg : ctx.dynamicInstantiationArgs().dynamicInstantiationArg()) {
            dynamicInstantiation.addArgument(this.visitDynamicInstantiationArg(arg));
        }
        return dynamicInstantiation;
    }

    private Class classForName(String className) {
        return this.creationContext.getServiceRegistry().getService(ClassLoaderService.class).classForName(className);
    }

    @Override
    public SqmDynamicInstantiationArgument visitDynamicInstantiationArg(HqlParser.DynamicInstantiationArgContext ctx) {
        return new SqmDynamicInstantiationArgument(this.visitDynamicInstantiationArgExpression(ctx.dynamicInstantiationArgExpression()), ctx.identifier() == null ? null : ctx.identifier().getText());
    }

    @Override
    public SqmSelectableNode visitDynamicInstantiationArgExpression(HqlParser.DynamicInstantiationArgExpressionContext ctx) {
        if (ctx.dynamicInstantiation() != null) {
            return this.visitDynamicInstantiation(ctx.dynamicInstantiation());
        }
        if (ctx.expression() != null) {
            return (SqmExpression)ctx.expression().accept(this);
        }
        throw new ParsingException("Unexpected dynamic-instantiation-argument rule type : " + ctx.getText());
    }

    @Override
    public SqmPath visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        String alias = ctx.identifier().getText();
        SqmFrom sqmFromByAlias = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias);
        if (sqmFromByAlias == null) {
            throw new SemanticException("Unable to resolve alias [" + alias + "] in selection [" + ctx.getText() + "]");
        }
        return sqmFromByAlias;
    }

    @Override
    public Object visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        return super.visitGroupByClause(ctx);
    }

    @Override
    public Object visitHavingClause(HqlParser.HavingClauseContext ctx) {
        return super.visitHavingClause(ctx);
    }

    @Override
    public SqmOrderByClause visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        SqmOrderByClause orderByClause = new SqmOrderByClause();
        for (HqlParser.SortSpecificationContext sortSpecificationContext : ctx.sortSpecification()) {
            orderByClause.addSortSpecification(this.visitSortSpecification(sortSpecificationContext));
        }
        return orderByClause;
    }

    @Override
    public SqmSortSpecification visitSortSpecification(HqlParser.SortSpecificationContext ctx) {
        SortOrder sortOrder;
        SqmExpression sortExpression = this.visitSortExpression(ctx.sortExpression());
        if (sortExpression == null) {
            throw new ParsingException("Could not resolve sort-expression : " + ctx.sortExpression().getText());
        }
        if (sortExpression instanceof SqmLiteral || sortExpression instanceof SqmParameter) {
            QueryLogger.QUERY_LOGGER.debugf("Questionable sorting by constant value : %s", sortExpression);
        }
        String collation = ctx.collationSpecification() != null && ctx.collationSpecification().collateName() != null ? ctx.collationSpecification().collateName().dotIdentifierSequence().getText() : null;
        if (ctx.orderingSpecification() != null) {
            String ordering = ctx.orderingSpecification().getText();
            try {
                sortOrder = this.interpretSortOrder(ordering);
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException("Unrecognized sort ordering: " + ordering, e);
            }
        } else {
            sortOrder = null;
        }
        return new SqmSortSpecification(sortExpression, collation, sortOrder);
    }

    @Override
    public SqmExpression visitSortExpression(HqlParser.SortExpressionContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            SqmSelectableNode selectableNode;
            int position = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
            SqmSelection selection = this.getCurrentQuerySpecProcessingState().findSelectionByPosition(position);
            if (selection != null && (selectableNode = selection.getSelectableNode()) instanceof SqmExpression) {
                return (SqmExpression)selectableNode;
            }
            return new SqmLiteral<Integer>(position, StandardSpiBasicTypes.INTEGER);
        }
        if (ctx.identifier() != null) {
            SqmSelectableNode selectableNode;
            SqmSelection selection = this.getCurrentQuerySpecProcessingState().findSelectionByAlias(ctx.identifier().getText());
            if (selection != null && (selectableNode = selection.getSelectableNode()) instanceof SqmExpression) {
                return (SqmExpression)selectableNode;
            }
            DotIdentifierConsumer dotIdentifierConsumer = this.identifierConsumerStack.getCurrent();
            dotIdentifierConsumer.consumeIdentifier(ctx.identifier().getText(), true, true);
            return (SqmExpression)((Object)dotIdentifierConsumer.getConsumedPart());
        }
        return (SqmExpression)ctx.expression().accept(this);
    }

    @Override
    public SqmExpression visitLimitClause(HqlParser.LimitClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        SqmExpression sqmExpression = (SqmExpression)ctx.parameterOrNumberLiteral().accept(this);
        this.applyImpliedType(sqmExpression, StandardSpiBasicTypes.INTEGER);
        return sqmExpression;
    }

    @Override
    public SqmExpression visitOffsetClause(HqlParser.OffsetClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        SqmExpression sqmExpression = (SqmExpression)ctx.parameterOrNumberLiteral().accept(this);
        this.applyImpliedType(sqmExpression, StandardSpiBasicTypes.INTEGER);
        return sqmExpression;
    }

    private void applyImpliedType(SqmExpression sqmExpression, StandardSpiBasicTypes.StandardBasicType impliedType) {
        if (sqmExpression instanceof InferableTypeSqmExpression) {
            ((InferableTypeSqmExpression)sqmExpression).impliedType(() -> impliedType);
        }
    }

    @Override
    public Object visitPathExpression(HqlParser.PathExpressionContext ctx) {
        return ctx.path().accept(this);
    }

    @Override
    public SqmExpression visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.INTEGER_LITERAL().getText());
        }
        if (ctx.parameter() != null) {
            return (SqmExpression)ctx.parameter().accept(this);
        }
        return null;
    }

    private SortOrder interpretSortOrder(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("ascending") || value.equalsIgnoreCase("asc")) {
            return SortOrder.ASCENDING;
        }
        if (value.equalsIgnoreCase("descending") || value.equalsIgnoreCase("desc")) {
            return SortOrder.DESCENDING;
        }
        throw new SemanticException("Unknown sort order : " + value);
    }

    @Override
    public EntityTypeDescriptor<?> visitEntityName(HqlParser.EntityNameContext parserEntityName) {
        String entityName = parserEntityName.dotIdentifierSequence().getText();
        EntityValuedExpressableType entityReference = this.resolveEntityReference(entityName);
        if (entityReference == null) {
            throw new UnknownEntityException("Could not resolve entity name [" + entityName + "] as DML target", entityName);
        }
        return entityReference.getEntityDescriptor();
    }

    private EntityValuedExpressableType resolveEntityReference(String entityName) {
        log.debugf("Attempting to resolve path [%s] as entity reference...", (Object)entityName);
        EntityTypeDescriptor reference = null;
        try {
            reference = this.creationContext.getDomainModel().resolveEntityReference(entityName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmFromClause visitFromClause(HqlParser.FromClauseContext parserFromClause) {
        this.treatHandlerStack.push(new TreatHandlerFromClause());
        try {
            SqmFromClause fromClause = new SqmFromClause();
            for (HqlParser.FromClauseSpaceContext parserSpace : parserFromClause.fromClauseSpace()) {
                SqmRoot sqmPathRoot = this.visitFromClauseSpace(parserSpace);
                fromClause.addRoot(sqmPathRoot);
            }
            SqmFromClause sqmFromClause = fromClause;
            return sqmFromClause;
        }
        finally {
            this.treatHandlerStack.pop();
        }
    }

    @Override
    public SqmRoot visitFromClauseSpace(HqlParser.FromClauseSpaceContext parserSpace) {
        SqmRoot sqmRoot = this.visitPathRoot(parserSpace.pathRoot());
        for (HqlParser.CrossJoinContext crossJoinContext : parserSpace.crossJoin()) {
            this.consumeCrossJoin(crossJoinContext, sqmRoot);
        }
        for (HqlParser.QualifiedJoinContext qualifiedJoinContext : parserSpace.qualifiedJoin()) {
            this.consumeQualifiedJoin(qualifiedJoinContext, sqmRoot);
        }
        for (HqlParser.JpaCollectionJoinContext jpaCollectionJoinContext : parserSpace.jpaCollectionJoin()) {
            this.consumeJpaCollectionJoin(jpaCollectionJoinContext);
        }
        return sqmRoot;
    }

    @Override
    public SqmRoot visitPathRoot(HqlParser.PathRootContext ctx) {
        String name = ctx.entityName().getText();
        log.debugf("Handling root path - %s", (Object)name);
        EntityTypeDescriptor entityDescriptor = this.getCreationContext().getDomainModel().resolveEntityReference(name);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("Encountered unmapped polymorphic reference [" + entityDescriptor.getEntityName() + "], but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.UNMAPPED_POLYMORPHISM);
            }
            if (this.processingStateStack.depth() > 1) {
                throw new SemanticException("Illegal implicit-polymorphic domain path in sub-query : " + entityDescriptor.getName());
            }
        }
        String alias = this.visitIdentificationVariableDef(ctx.identificationVariableDef());
        SqmRoot sqmRoot = new SqmRoot(entityDescriptor, alias);
        this.processingStateStack.getCurrent().getPathRegistry().register(sqmRoot);
        return sqmRoot;
    }

    @Override
    public String visitIdentificationVariableDef(HqlParser.IdentificationVariableDefContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.AS() != null && ctx.identifier() != null) {
            Token identificationVariableToken;
            if (this.getCreationOptions().useStrictJpaCompliance() && (identificationVariableToken = ctx.identifier().getStart()).getType() != 149) {
                throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), identificationVariableToken.getText()), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
            }
            return ctx.identifier().getText();
        }
        if (ctx.IDENTIFIER() != null) {
            return ctx.IDENTIFIER().getText();
        }
        return null;
    }

    @Override
    public final SqmCrossJoin visitCrossJoin(HqlParser.CrossJoinContext ctx) {
        throw new UnsupportedOperationException("Unexpected call to #visitCrossJoin, see #consumeCrossJoin");
    }

    private void consumeCrossJoin(HqlParser.CrossJoinContext parserJoin, SqmRoot sqmRoot) {
        String name = parserJoin.pathRoot().entityName().getText();
        SqmTreeCreationLogger.LOGGER.debugf("Handling root path - %s", (Object)name);
        EntityTypeDescriptor entityType = this.getCreationContext().getDomainModel().resolveEntityReference(name);
        if (entityType instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException("Unmapped polymorphic reference cannot be used as a CROSS JOIN target");
        }
        EntityTypeDescriptor entityDescriptor = entityType.getEntityDescriptor();
        SqmCrossJoin join = new SqmCrossJoin(entityDescriptor, this.visitIdentificationVariableDef(parserJoin.pathRoot().identificationVariableDef()), sqmRoot);
        this.processingStateStack.getCurrent().getPathRegistry().register(join);
        sqmRoot.addJoin(join);
    }

    @Override
    public final SqmQualifiedJoin visitQualifiedJoin(HqlParser.QualifiedJoinContext parserJoin) {
        throw new UnsupportedOperationException("Unexpected call to #visitQualifiedJoin, see #consumeQualifiedJoin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeQualifiedJoin(HqlParser.QualifiedJoinContext parserJoin, SqmRoot sqmRoot) {
        block13: {
            SqmJoinType joinType;
            HqlParser.JoinTypeQualifierContext joinTypeQualifier = parserJoin.joinTypeQualifier();
            if (joinTypeQualifier.OUTER() != null) {
                if (joinTypeQualifier.FULL() != null) {
                    throw new SemanticException("FULL OUTER joins are not yet supported : " + parserJoin.getText());
                }
                if (joinTypeQualifier.RIGHT() != null) {
                    throw new SemanticException("RIGHT OUTER joins are not yet supported : " + parserJoin.getText());
                }
                joinType = SqmJoinType.LEFT;
            } else {
                joinType = SqmJoinType.INNER;
            }
            String alias = this.visitIdentificationVariableDef(parserJoin.qualifiedJoinRhs().identificationVariableDef());
            QualifiedJoinPathIdentifierConsumer identifierConsumer = new QualifiedJoinPathIdentifierConsumer(joinType, parserJoin.FETCH() != null, alias, sqmRoot, this.processingStateStack.getCurrent());
            this.identifierConsumerStack.push(identifierConsumer);
            try {
                SqmQualifiedJoin join = (SqmQualifiedJoin)parserJoin.qualifiedJoinRhs().path().accept(this);
                join.setExplicitAlias(alias);
                if (join instanceof SqmEntityJoin) {
                    sqmRoot.addJoin(join);
                } else if (this.getCreationOptions().useStrictJpaCompliance() && join.getExplicitAlias() != null && ((SqmNavigableJoin)join).isFetched()) {
                    throw new StrictJpaComplianceViolation("Encountered aliased fetch join, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.ALIASED_FETCH_JOIN);
                }
                this.processingStateStack.getCurrent().getPathRegistry().register(join);
                if (parserJoin.qualifiedJoinPredicate() == null) break block13;
                this.identifierConsumerStack.push(new QualifiedJoinPredicateDotIdentifierConsumer(this.processingStateStack::getCurrent, join, parserJoin.qualifiedJoinPredicate().getText()));
                try {
                    join.setJoinPredicate((SqmPredicate)parserJoin.qualifiedJoinPredicate().predicate().accept(this));
                }
                finally {
                    this.identifierConsumerStack.pop();
                }
            }
            finally {
                this.identifierConsumerStack.pop();
            }
        }
    }

    @Override
    public SqmJoin visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        throw new UnsupportedOperationException();
    }

    public void consumeJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        this.identifierConsumerStack.push(new BasicDotIdentifierConsumer(this.processingStateStack::getCurrent));
        try {
            this.consumePluralAttributeReference(ctx.path());
        }
        finally {
            this.identifierConsumerStack.pop();
        }
    }

    @Override
    public SqmPredicate visitWhereClause(HqlParser.WhereClauseContext ctx) {
        return (SqmPredicate)ctx.predicate().accept(this);
    }

    @Override
    public GroupedSqmPredicate visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        return new GroupedSqmPredicate((SqmPredicate)ctx.predicate().accept(this));
    }

    @Override
    public SqmPredicate visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        return new AndSqmPredicate((SqmPredicate)ctx.predicate(0).accept(this), (SqmPredicate)ctx.predicate(1).accept(this));
    }

    @Override
    public SqmPredicate visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        return new OrSqmPredicate((SqmPredicate)ctx.predicate(0).accept(this), (SqmPredicate)ctx.predicate(1).accept(this));
    }

    @Override
    public SqmPredicate visitNegatedPredicate(HqlParser.NegatedPredicateContext ctx) {
        SqmPredicate predicate = (SqmPredicate)ctx.predicate().accept(this);
        if (predicate instanceof NegatableSqmPredicate) {
            ((NegatableSqmPredicate)predicate).negate();
            return predicate;
        }
        return new NegatedSqmPredicate(predicate);
    }

    @Override
    public NullnessSqmPredicate visitIsNullPredicate(HqlParser.IsNullPredicateContext ctx) {
        return new NullnessSqmPredicate((SqmExpression)ctx.expression().accept(this), ctx.NOT() != null);
    }

    @Override
    public EmptinessSqmPredicate visitIsEmptyPredicate(HqlParser.IsEmptyPredicateContext ctx) {
        return new EmptinessSqmPredicate((SqmPath)ctx.expression().accept(this), ctx.NOT() != null);
    }

    @Override
    public SqmComparisonPredicate visitEqualityPredicate(HqlParser.EqualityPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        if (lhs.getInferableType() != null && rhs instanceof InferableTypeSqmExpression) {
            ((InferableTypeSqmExpression)rhs).impliedType(lhs.getInferableType());
        }
        if (rhs.getInferableType() != null && lhs instanceof InferableTypeSqmExpression) {
            ((InferableTypeSqmExpression)lhs).impliedType(rhs.getInferableType());
        }
        return new SqmComparisonPredicate(lhs, ComparisonOperator.EQUAL, rhs);
    }

    @Override
    public Object visitInequalityPredicate(HqlParser.InequalityPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.NOT_EQUAL, rhs);
    }

    @Override
    public Object visitGreaterThanPredicate(HqlParser.GreaterThanPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.GREATER_THAN, rhs);
    }

    @Override
    public Object visitGreaterThanOrEqualPredicate(HqlParser.GreaterThanOrEqualPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.GREATER_THAN_OR_EQUAL, rhs);
    }

    @Override
    public Object visitLessThanPredicate(HqlParser.LessThanPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.LESS_THAN, rhs);
    }

    @Override
    public Object visitLessThanOrEqualPredicate(HqlParser.LessThanOrEqualPredicateContext ctx) {
        SqmExpression lhs = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression rhs = (SqmExpression)ctx.expression().get(1).accept(this);
        return new SqmComparisonPredicate(lhs, ComparisonOperator.LESS_THAN_OR_EQUAL, rhs);
    }

    @Override
    public Object visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression lowerBound = (SqmExpression)ctx.expression().get(1).accept(this);
        SqmExpression upperBound = (SqmExpression)ctx.expression().get(2).accept(this);
        if (expression.getInferableType() != null) {
            if (lowerBound instanceof InferableTypeSqmExpression) {
                ((InferableTypeSqmExpression)lowerBound).impliedType(expression.getInferableType());
            }
            if (upperBound instanceof InferableTypeSqmExpression) {
                ((InferableTypeSqmExpression)upperBound).impliedType(expression.getInferableType());
            }
        } else if (lowerBound.getInferableType() != null) {
            if (expression instanceof InferableTypeSqmExpression) {
                ((InferableTypeSqmExpression)expression).impliedType(lowerBound.getInferableType());
            }
            if (upperBound instanceof InferableTypeSqmExpression) {
                ((InferableTypeSqmExpression)upperBound).impliedType(lowerBound.getInferableType());
            }
        } else if (upperBound.getInferableType() != null) {
            if (expression instanceof InferableTypeSqmExpression) {
                ((InferableTypeSqmExpression)expression).impliedType(upperBound.getInferableType());
            }
            if (lowerBound instanceof InferableTypeSqmExpression) {
                ((InferableTypeSqmExpression)lowerBound).impliedType(upperBound.getInferableType());
            }
        }
        return new BetweenSqmPredicate(expression, lowerBound, upperBound, false);
    }

    @Override
    public SqmPredicate visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        if (ctx.likeEscape() != null) {
            return new LikeSqmPredicate((SqmExpression)ctx.expression().get(0).accept(this), (SqmExpression)ctx.expression().get(1).accept(this), (SqmExpression)ctx.likeEscape().expression().accept(this));
        }
        return new LikeSqmPredicate((SqmExpression)ctx.expression().get(0).accept(this), (SqmExpression)ctx.expression().get(1).accept(this));
    }

    @Override
    public SqmPredicate visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx) {
        SqmPath sqmPluralPath = this.consumeDomainPath(ctx.path());
        if (sqmPluralPath.getReferencedNavigable() instanceof PluralValuedNavigable) {
            return new MemberOfSqmPredicate(sqmPluralPath);
        }
        throw new SemanticException("Path argument to MEMBER OF must be a plural attribute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPredicate visitInPredicate(HqlParser.InPredicateContext ctx) {
        SqmExpression testExpression = (SqmExpression)ctx.expression().accept(this);
        if (ctx.inList() instanceof HqlParser.ExplicitTupleInListContext) {
            HqlParser.ExplicitTupleInListContext tupleExpressionListContext = (HqlParser.ExplicitTupleInListContext)ctx.inList();
            this.parameterDeclarationContextStack.push(() -> tupleExpressionListContext.expression().size() == 1);
            try {
                ArrayList<SqmExpression> listExpressions = new ArrayList<SqmExpression>(tupleExpressionListContext.expression().size());
                for (HqlParser.ExpressionContext expressionContext : tupleExpressionListContext.expression()) {
                    SqmExpression listItemExpression = (SqmExpression)expressionContext.accept(this);
                    if (testExpression.getInferableType() != null && listItemExpression instanceof InferableTypeSqmExpression) {
                        ((InferableTypeSqmExpression)listItemExpression).impliedType(testExpression.getInferableType());
                    }
                    listExpressions.add(listItemExpression);
                }
                InListSqmPredicate inListSqmPredicate = new InListSqmPredicate(testExpression, listExpressions);
                return inListSqmPredicate;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (HqlParser.SubQueryInListContext.class.isInstance((Object)ctx.inList())) {
            HqlParser.SubQueryInListContext subQueryContext = (HqlParser.SubQueryInListContext)ctx.inList();
            SqmExpression subQueryExpression = (SqmExpression)subQueryContext.expression().accept(this);
            if (!SqmSubQuery.class.isInstance(subQueryExpression)) {
                throw new ParsingException("Was expecting a SubQueryExpression, but found " + subQueryExpression.getClass().getSimpleName() + " : " + subQueryContext.expression().toString());
            }
            return new InSubQuerySqmPredicate(testExpression, (SqmSubQuery)subQueryExpression);
        }
        throw new ParsingException("Unexpected IN predicate type [" + ((Object)((Object)ctx)).getClass().getSimpleName() + "] : " + ctx.getText());
    }

    @Override
    public Object visitEntityTypeExpression(HqlParser.EntityTypeExpressionContext ctx) {
        if (ctx.entityTypeReference().parameter() != null) {
            return new SqmParameterizedEntityType((SqmParameter)ctx.entityTypeReference().parameter().accept(this));
        }
        if (ctx.entityTypeReference().path() != null) {
            SqmNavigableReference binding = (SqmNavigableReference)ctx.entityTypeReference().path().accept(this);
            return binding.as(EntityValuedNavigable.class).getEntityDescriptor().getHierarchy().getDiscriminatorDescriptor().createSqmExpression(null, this);
        }
        throw new ParsingException("Could not interpret grammar context as 'entity type' expression : " + ctx.getText());
    }

    @Override
    public SqmMapEntryReference visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        return new SqmMapEntryReference(this.consumePluralAttributeReference(ctx.path()), (BasicJavaDescriptor)this.creationContext.getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(Map.Entry.class));
    }

    @Override
    public SqmConcat visitConcatenationExpression(HqlParser.ConcatenationExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the concat operator");
        }
        return new SqmConcat((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this));
    }

    @Override
    public Object visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the + operator");
        }
        SqmExpression firstOperand = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression secondOperand = (SqmExpression)ctx.expression(1).accept(this);
        return new SqmBinaryArithmetic(firstOperand, BinaryArithmeticOperator.ADD, secondOperand, this.creationContext.getDomainModel().getTypeConfiguration().resolveArithmeticType((BasicValuedExpressableType)firstOperand.getExpressableType(), (BasicValuedExpressableType)secondOperand.getExpressableType(), BinaryArithmeticOperator.ADD));
    }

    @Override
    public Object visitSubtractionExpression(HqlParser.SubtractionExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the - operator");
        }
        SqmExpression firstOperand = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression secondOperand = (SqmExpression)ctx.expression(1).accept(this);
        return new SqmBinaryArithmetic(firstOperand, BinaryArithmeticOperator.SUBTRACT, secondOperand, this.creationContext.getDomainModel().getTypeConfiguration().resolveArithmeticType((BasicValuedExpressableType)firstOperand.getExpressableType(), (BasicValuedExpressableType)secondOperand.getExpressableType(), BinaryArithmeticOperator.SUBTRACT));
    }

    @Override
    public Object visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the * operator");
        }
        SqmExpression firstOperand = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression secondOperand = (SqmExpression)ctx.expression(1).accept(this);
        return new SqmBinaryArithmetic(firstOperand, BinaryArithmeticOperator.MULTIPLY, secondOperand, this.creationContext.getDomainModel().getTypeConfiguration().resolveArithmeticType((BasicValuedExpressableType)firstOperand.getExpressableType(), (BasicValuedExpressableType)secondOperand.getExpressableType(), BinaryArithmeticOperator.MULTIPLY));
    }

    @Override
    public Object visitDivisionExpression(HqlParser.DivisionExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the / operator");
        }
        SqmExpression firstOperand = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression secondOperand = (SqmExpression)ctx.expression(1).accept(this);
        return new SqmBinaryArithmetic(firstOperand, BinaryArithmeticOperator.DIVIDE, secondOperand, this.creationContext.getDomainModel().getTypeConfiguration().resolveArithmeticType((BasicValuedExpressableType)firstOperand.getExpressableType(), (BasicValuedExpressableType)secondOperand.getExpressableType(), BinaryArithmeticOperator.DIVIDE));
    }

    @Override
    public Object visitModuloExpression(HqlParser.ModuloExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the % operator");
        }
        SqmExpression firstOperand = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression secondOperand = (SqmExpression)ctx.expression(1).accept(this);
        return new SqmBinaryArithmetic(firstOperand, BinaryArithmeticOperator.MODULO, secondOperand, this.creationContext.getDomainModel().getTypeConfiguration().resolveArithmeticType((BasicValuedExpressableType)firstOperand.getExpressableType(), (BasicValuedExpressableType)secondOperand.getExpressableType(), BinaryArithmeticOperator.MODULO));
    }

    @Override
    public Object visitUnaryPlusExpression(HqlParser.UnaryPlusExpressionContext ctx) {
        return new SqmUnaryOperation(UnaryArithmeticOperator.UNARY_PLUS, (SqmExpression)ctx.expression().accept(this));
    }

    @Override
    public Object visitUnaryMinusExpression(HqlParser.UnaryMinusExpressionContext ctx) {
        return new SqmUnaryOperation(UnaryArithmeticOperator.UNARY_MINUS, (SqmExpression)ctx.expression().accept(this));
    }

    @Override
    public SqmCaseSimple visitSimpleCaseStatement(HqlParser.SimpleCaseStatementContext ctx) {
        SqmCaseSimple caseExpression = new SqmCaseSimple((SqmExpression)ctx.expression().accept(this));
        for (HqlParser.SimpleCaseWhenContext simpleCaseWhen : ctx.simpleCaseWhen()) {
            caseExpression.when((SqmExpression)simpleCaseWhen.expression(0).accept(this), (SqmExpression)simpleCaseWhen.expression(1).accept(this));
        }
        if (ctx.caseOtherwise() != null) {
            caseExpression.otherwise((SqmExpression)ctx.caseOtherwise().expression().accept(this));
        }
        return caseExpression;
    }

    @Override
    public SqmCaseSearched visitSearchedCaseStatement(HqlParser.SearchedCaseStatementContext ctx) {
        SqmCaseSearched caseExpression = new SqmCaseSearched();
        for (HqlParser.SearchedCaseWhenContext whenFragment : ctx.searchedCaseWhen()) {
            caseExpression.when((SqmPredicate)whenFragment.predicate().accept(this), (SqmExpression)whenFragment.expression().accept(this));
        }
        if (ctx.caseOtherwise() != null) {
            caseExpression.otherwise((SqmExpression)ctx.caseOtherwise().expression().accept(this));
        }
        return caseExpression;
    }

    @Override
    public SqmCoalesceFunction visitCoalesceExpression(HqlParser.CoalesceExpressionContext ctx) {
        SqmCoalesceFunction coalesceExpression = new SqmCoalesceFunction();
        for (HqlParser.ExpressionContext expressionContext : ctx.coalesce().expression()) {
            coalesceExpression.value((SqmExpression)expressionContext.accept(this));
        }
        return coalesceExpression;
    }

    @Override
    public SqmNullifFunction visitNullIfExpression(HqlParser.NullIfExpressionContext ctx) {
        return new SqmNullifFunction((SqmExpression)ctx.nullIf().expression(0).accept(this), (SqmExpression)ctx.nullIf().expression(1).accept(this));
    }

    @Override
    public SqmLiteral visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        if (ctx.literal().CHARACTER_LITERAL() != null) {
            return this.characterLiteral(ctx.literal().CHARACTER_LITERAL().getText());
        }
        if (ctx.literal().STRING_LITERAL() != null) {
            return this.stringLiteral(ctx.literal().STRING_LITERAL().getText());
        }
        if (ctx.literal().INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.literal().INTEGER_LITERAL().getText());
        }
        if (ctx.literal().LONG_LITERAL() != null) {
            return this.longLiteral(ctx.literal().LONG_LITERAL().getText());
        }
        if (ctx.literal().BIG_INTEGER_LITERAL() != null) {
            return this.bigIntegerLiteral(ctx.literal().BIG_INTEGER_LITERAL().getText());
        }
        if (ctx.literal().HEX_LITERAL() != null) {
            String text = ctx.literal().HEX_LITERAL().getText();
            if (text.endsWith("l") || text.endsWith("L")) {
                return this.longLiteral(text);
            }
            return this.integerLiteral(text);
        }
        if (ctx.literal().OCTAL_LITERAL() != null) {
            String text = ctx.literal().OCTAL_LITERAL().getText();
            if (text.endsWith("l") || text.endsWith("L")) {
                return this.longLiteral(text);
            }
            return this.integerLiteral(text);
        }
        if (ctx.literal().FLOAT_LITERAL() != null) {
            return this.floatLiteral(ctx.literal().FLOAT_LITERAL().getText());
        }
        if (ctx.literal().DOUBLE_LITERAL() != null) {
            return this.doubleLiteral(ctx.literal().DOUBLE_LITERAL().getText());
        }
        if (ctx.literal().BIG_DECIMAL_LITERAL() != null) {
            return this.bigDecimalLiteral(ctx.literal().BIG_DECIMAL_LITERAL().getText());
        }
        if (ctx.literal().FALSE() != null) {
            return this.booleanLiteral(false);
        }
        if (ctx.literal().TRUE() != null) {
            return this.booleanLiteral(true);
        }
        if (ctx.literal().NULL() != null) {
            return new SqmLiteralNull();
        }
        if (ctx.literal().timestampLiteral() != null) {
            return LiteralHelper.timestampLiteralFrom(ctx.literal().timestampLiteral().dateTimeLiteralText().getText(), this);
        }
        if (ctx.literal().dateLiteral() != null) {
            return LiteralHelper.dateLiteralFrom(ctx.literal().dateLiteral().dateTimeLiteralText().getText(), this);
        }
        if (ctx.literal().timeLiteral() != null) {
            return LiteralHelper.timeLiteralFrom(ctx.literal().timeLiteral().dateTimeLiteralText().getText(), this);
        }
        throw new ParsingException("Unexpected literal expression type [" + ctx.getText() + "]");
    }

    private SqmLiteral<Boolean> booleanLiteral(boolean value) {
        BasicValuedExpressableType<Boolean> expressionType = this.resolveExpressableTypeBasic(Boolean.class);
        return new SqmLiteral<Boolean>(value, expressionType);
    }

    private SqmLiteral<Character> characterLiteral(String text) {
        if (text.length() > 1) {
            throw new ParsingException("Value for CHARACTER_LITERAL token was more than 1 character");
        }
        return new SqmLiteral<Character>(Character.valueOf(text.charAt(0)), this.resolveExpressableTypeBasic(Character.class));
    }

    private SqmLiteral<String> stringLiteral(String text) {
        return new SqmLiteral<String>(text, this.creationContext.getDomainModel().getTypeConfiguration().resolveStandardBasicType(StandardBasicTypes.STRING));
    }

    protected SqmLiteral<Integer> integerLiteral(String text) {
        try {
            Integer value = Integer.valueOf(text);
            return new SqmLiteral<Integer>(value, this.resolveExpressableTypeBasic(Integer.class));
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Integer", e);
        }
    }

    protected SqmLiteral<Long> longLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("l") || text.endsWith("L")) {
                text = text.substring(0, text.length() - 1);
            }
            Long value = Long.valueOf(text);
            return new SqmLiteral<Long>(value, this.resolveExpressableTypeBasic(Long.class));
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to Long", e);
        }
    }

    protected SqmLiteral<BigInteger> bigIntegerLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("bi") || text.endsWith("BI")) {
                text = text.substring(0, text.length() - 2);
            }
            return new SqmLiteral<BigInteger>(new BigInteger(text), this.resolveExpressableTypeBasic(BigInteger.class));
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to BigInteger", e);
        }
    }

    protected SqmLiteral<Float> floatLiteral(String text) {
        try {
            return new SqmLiteral<Float>(Float.valueOf(text), this.resolveExpressableTypeBasic(Float.class));
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Float", e);
        }
    }

    protected SqmLiteral<Double> doubleLiteral(String text) {
        try {
            return new SqmLiteral<Double>(Double.valueOf(text), this.resolveExpressableTypeBasic(Double.class));
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Double", e);
        }
    }

    protected SqmLiteral<BigDecimal> bigDecimalLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("bd") || text.endsWith("BD")) {
                text = text.substring(0, text.length() - 2);
            }
            return new SqmLiteral<BigDecimal>(new BigDecimal(text), this.resolveExpressableTypeBasic(BigDecimal.class));
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to BigDecimal", e);
        }
    }

    private <J> BasicValuedExpressableType<J> resolveExpressableTypeBasic(Class<J> javaType) {
        return this.creationContext.getDomainModel().getTypeConfiguration().standardExpressableTypeForJavaType(javaType);
    }

    @Override
    public Object visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return ctx.parameter().accept(this);
    }

    @Override
    public SqmNamedParameter visitNamedParameter(HqlParser.NamedParameterContext ctx) {
        SqmNamedParameter param = new SqmNamedParameter(ctx.identifier().getText(), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed());
        this.parameterCollector.addParameter(param);
        return param;
    }

    @Override
    public SqmPositionalParameter visitPositionalParameter(HqlParser.PositionalParameterContext ctx) {
        if (ctx.INTEGER_LITERAL() == null) {
            throw new SemanticException("Encountered positional parameter which did not declare position (? instead of, e.g., ?1)");
        }
        SqmPositionalParameter param = new SqmPositionalParameter(Integer.valueOf(ctx.INTEGER_LITERAL().getText()), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed());
        this.parameterCollector.addParameter(param);
        return param;
    }

    @Override
    public SqmGenericFunction visitJpaNonStandardFunction(HqlParser.JpaNonStandardFunctionContext ctx) {
        String functionName = ctx.jpaNonStandardFunctionName().STRING_LITERAL().getText();
        Object functionArguments = this.visitNonStandardFunctionArguments(ctx.nonStandardFunctionArguments());
        return new SqmGenericFunction(functionName, null, (List<SqmExpression>)functionArguments);
    }

    @Override
    public SqmGenericFunction visitNonStandardFunction(HqlParser.NonStandardFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered non-compliant non-standard function call [" + (Object)((Object)ctx.nonStandardFunctionName()) + "], but strict JPQL compliance was requested; use JPA's FUNCTION(functionName[,...]) syntax name instead", StrictJpaComplianceViolation.Type.FUNCTION_CALL);
        }
        String functionName = ctx.nonStandardFunctionName().getText();
        Object functionArguments = this.visitNonStandardFunctionArguments(ctx.nonStandardFunctionArguments());
        return new SqmGenericFunction(functionName, null, (List<SqmExpression>)functionArguments);
    }

    @Override
    public List<SqmExpression> visitNonStandardFunctionArguments(HqlParser.NonStandardFunctionArgumentsContext ctx) {
        ArrayList<SqmExpression> arguments = new ArrayList<SqmExpression>();
        int x = ctx.expression().size();
        for (int i = 0; i < x; ++i) {
            if (i == x - 1) {
                arguments.add(this.visitFinalFunctionArgument(ctx.expression(i)));
                continue;
            }
            arguments.add((SqmExpression)ctx.expression(i).accept(this));
        }
        return arguments;
    }

    private SqmExpression visitFinalFunctionArgument(HqlParser.ExpressionContext expression) {
        this.parameterDeclarationContextStack.push(() -> this.creationOptions.useStrictJpaCompliance());
        try {
            SqmExpression sqmExpression = (SqmExpression)expression.accept(this);
            return sqmExpression;
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
    }

    @Override
    public SqmAggregateFunction visitAggregateFunction(HqlParser.AggregateFunctionContext ctx) {
        return (SqmAggregateFunction)super.visitAggregateFunction(ctx);
    }

    @Override
    public SqmExpression visitAbsFunction(HqlParser.AbsFunctionContext ctx) {
        return this.generateSingleArgFunction((sqmFunctionTemplate, sqmArgument) -> sqmFunctionTemplate.makeSqmFunctionExpression(Collections.singletonList(sqmArgument), (AllowableFunctionReturnType)sqmArgument.getExpressableType()), arguments -> new SqmAbsFunction((SqmExpression)arguments, null), "abs", ctx.expression());
    }

    @Override
    public SqmExpression visitAvgFunction(HqlParser.AvgFunctionContext ctx) {
        return this.generateAggregateFunction((sqmFunctionTemplate, sqmArgument) -> sqmFunctionTemplate.makeSqmFunctionExpression(Collections.singletonList(sqmArgument), (AllowableFunctionReturnType)sqmArgument.getExpressableType()), sqmArgument -> new SqmAvgFunction((SqmExpression)sqmArgument, (AllowableFunctionReturnType)sqmArgument.getExpressableType()), "avg", ctx.DISTINCT() != null, ctx.expression());
    }

    @Override
    public SqmExpression visitCastFunction(HqlParser.CastFunctionContext ctx) {
        SqmFunctionTemplate template = this.creationContext.getFunctionResolver().apply("cast");
        SqmExpression expressionToCast = (SqmExpression)ctx.expression().accept(this);
        SqmExpression castTargetExpression = this.interpretCastTarget(ctx.castTarget());
        if (!AllowableFunctionReturnType.class.isInstance(castTargetExpression)) {
            throw new SqmProductionException("Found cast target expression [%s] which is not allowed as a function return");
        }
        if (template == null) {
            return new SqmCastFunction(expressionToCast, (AllowableFunctionReturnType)((Object)castTargetExpression), castTargetExpression.getExpressableType().toString());
        }
        return template.makeSqmFunctionExpression(Arrays.asList(expressionToCast, castTargetExpression), (AllowableFunctionReturnType)castTargetExpression.getExpressableType());
    }

    private SqmExpression interpretCastTarget(HqlParser.CastTargetContext castTargetContext) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public SqmConcatFunction visitConcatFunction(HqlParser.ConcatFunctionContext ctx) {
        ArrayList<SqmExpression> arguments = new ArrayList<SqmExpression>();
        for (HqlParser.ExpressionContext argument : ctx.expression()) {
            arguments.add((SqmExpression)argument.accept(this));
        }
        return new SqmConcatFunction((BasicValuedExpressableType)((SqmExpression)arguments.get(0)).getExpressableType(), arguments);
    }

    @Override
    public SqmExpression visitCountFunction(HqlParser.CountFunctionContext ctx) {
        boolean isCountStar = ctx.ASTERISK() != null;
        BasicValuedExpressableType<Long> longType = this.resolveExpressableTypeBasic(Long.class);
        return this.generateAggregateFunction((sqmFunctionTemplate, sqmArgument) -> {
            List<SqmExpression> arguments = isCountStar ? Collections.singletonList(SqmCountStarFunction.STAR) : Collections.singletonList(sqmArgument);
            return sqmFunctionTemplate.makeSqmFunctionExpression(arguments, (AllowableFunctionReturnType)sqmArgument.getExpressableType());
        }, sqmArgument -> isCountStar ? new SqmCountStarFunction(longType) : new SqmCountFunction((SqmExpression)sqmArgument, longType), "count", ctx.DISTINCT() != null, ctx.expression());
    }

    @Override
    public Object visitLengthFunction(HqlParser.LengthFunctionContext ctx) {
        SqmExpression sqmExpression = (SqmExpression)ctx.expression().accept(this);
        return new SqmLengthFunction(sqmExpression, this.resolveExpressableTypeBasic(Long.class));
    }

    @Override
    public Object visitLocateFunction(HqlParser.LocateFunctionContext ctx) {
        return super.visitLocateFunction(ctx);
    }

    @Override
    public SqmExpression visitMaxFunction(HqlParser.MaxFunctionContext ctx) {
        return this.generateAggregateFunction((template, sqmArgument) -> template.makeSqmFunctionExpression(Collections.singletonList(sqmArgument), (BasicValuedExpressableType)sqmArgument.getExpressableType()), sqmArgument -> new SqmMaxFunction((SqmExpression)sqmArgument, (BasicValuedExpressableType)sqmArgument.getExpressableType()), "count", ctx.DISTINCT() != null, ctx.expression());
    }

    @Override
    public Object visitStrFunction(HqlParser.StrFunctionContext ctx) {
        SqmExpression sqmExpression = (SqmExpression)ctx.expression().accept(this);
        return new SqmStrFunction(sqmExpression, this.resolveExpressableTypeBasic(String.class));
    }

    private SqmExpression generateAggregateFunction(BiFunction<SqmFunctionTemplate, SqmExpression, SqmExpression> templatedGenerator, Function<SqmExpression, SqmExpression> nonTemplatedGenerator, String name, boolean isDistinct, HqlParser.ExpressionContext antlrArgumentExpression) {
        SqmFunctionTemplate template = this.creationContext.getFunctionResolver().apply(name);
        SqmExpression sqmArgument = (SqmExpression)antlrArgumentExpression.accept(this);
        SqmExpression result = template == null ? nonTemplatedGenerator.apply(sqmArgument) : templatedGenerator.apply(template, sqmArgument);
        if (isDistinct) {
            this.applyDistinct(result);
        }
        return result;
    }

    private void applyDistinct(SqmExpression result) {
        if (result instanceof Distinctable) {
            ((Distinctable)((Object)result)).makeDistinct();
        } else {
            log.debugf("COUNT SqmFunction result [%s] did not implement %s; cannot apply DISTINCT", (Object)result, (Object)Distinctable.class.getName());
        }
    }

    private SqmExpression generateSingleArgFunction(BiFunction<SqmFunctionTemplate, SqmExpression, SqmExpression> templatedGenerator, Function<SqmExpression, SqmExpression> nonTemplatedGenerator, String name, HqlParser.ExpressionContext antlrArgument) {
        SqmFunctionTemplate template = this.creationContext.getFunctionResolver().apply(name);
        SqmExpression sqmArgument = (SqmExpression)antlrArgument.accept(this);
        if (template == null) {
            return nonTemplatedGenerator.apply(sqmArgument);
        }
        return templatedGenerator.apply(template, sqmArgument);
    }

    @Override
    public SqmExpression visitMinFunction(HqlParser.MinFunctionContext ctx) {
        return this.generateAggregateFunction((sqmFunctionTemplate, sqmArgument) -> sqmFunctionTemplate.makeSqmFunctionExpression(Collections.singletonList(sqmArgument), (AllowableFunctionReturnType)sqmArgument.getExpressableType()), sqmArgument -> new SqmMinFunction((SqmExpression)sqmArgument, (AllowableFunctionReturnType)sqmArgument.getExpressableType()), "count", ctx.DISTINCT() != null, ctx.expression());
    }

    @Override
    public SqmExpression visitSubstringFunction(HqlParser.SubstringFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmExpression start = (SqmExpression)ctx.substringFunctionStartArgument().accept(this);
        SqmExpression length = ctx.substringFunctionLengthArgument() == null ? null : (SqmExpression)ctx.substringFunctionLengthArgument().accept(this);
        return new SqmSubstringFunction((BasicValuedExpressableType)source.getExpressableType(), source, start, length);
    }

    @Override
    public SqmExpression visitSumFunction(HqlParser.SumFunctionContext ctx) {
        return this.generateAggregateFunction((sqmFunctionTemplate, sqmArgument) -> sqmFunctionTemplate.makeSqmFunctionExpression(Collections.singletonList(sqmArgument), (AllowableFunctionReturnType)sqmArgument.getExpressableType()), sqmArgument -> new SqmSumFunction((SqmExpression)sqmArgument, (AllowableFunctionReturnType)sqmArgument.getExpressableType()), "sum", ctx.DISTINCT() != null, ctx.expression());
    }

    @Override
    public SqmExpression visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmFunctionTemplate trimFunctionTemplate = this.creationContext.getFunctionResolver().apply("trim");
        if (trimFunctionTemplate != null) {
            return trimFunctionTemplate.makeSqmFunctionExpression(Arrays.asList(TrimSpecificationExpressionWrapper.wrap(this.visitTrimSpecification(ctx.trimSpecification())), this.visitTrimCharacter(ctx.trimCharacter()), source), this.resolveExpressableTypeBasic(String.class));
        }
        return new SqmTrimFunction((BasicValuedExpressableType)source.getExpressableType(), this.visitTrimSpecification(ctx.trimSpecification()), (SqmExpression)this.visitTrimCharacter(ctx.trimCharacter()), source);
    }

    @Override
    public TrimSpecification visitTrimSpecification(HqlParser.TrimSpecificationContext ctx) {
        if (ctx.LEADING() != null) {
            return TrimSpecification.LEADING;
        }
        if (ctx.TRAILING() != null) {
            return TrimSpecification.TRAILING;
        }
        return TrimSpecification.BOTH;
    }

    @Override
    public SqmLiteral<Character> visitTrimCharacter(HqlParser.TrimCharacterContext ctx) {
        if (ctx.CHARACTER_LITERAL() != null) {
            String trimCharText = ctx.CHARACTER_LITERAL().getText();
            if (trimCharText.length() != 1) {
                throw new SemanticException("Expecting [trim character] for TRIM function to be  single character, found : " + trimCharText);
            }
            return new SqmLiteral<Character>(Character.valueOf(trimCharText.charAt(0)), this.resolveExpressableTypeBasic(Character.class));
        }
        if (ctx.STRING_LITERAL() != null) {
            String trimCharText = ctx.STRING_LITERAL().getText();
            if (trimCharText.length() != 1) {
                throw new SemanticException("Expecting [trim character] for TRIM function to be  single character, found : " + trimCharText);
            }
            return new SqmLiteral<Character>(Character.valueOf(trimCharText.charAt(0)), this.resolveExpressableTypeBasic(Character.class));
        }
        return new SqmLiteral<Character>(Character.valueOf(' '), this.resolveExpressableTypeBasic(Character.class));
    }

    @Override
    public SqmUpperFunction visitUpperFunction(HqlParser.UpperFunctionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        return new SqmUpperFunction((BasicValuedExpressableType)expression.getExpressableType(), expression);
    }

    @Override
    public SqmLowerFunction visitLowerFunction(HqlParser.LowerFunctionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        return new SqmLowerFunction((BasicValuedExpressableType)expression.getExpressableType(), expression);
    }

    @Override
    public SqmCollectionSize visitCollectionSizeFunction(HqlParser.CollectionSizeFunctionContext ctx) {
        return new SqmCollectionSize(this.consumeDomainPath(ctx.path()), this.resolveExpressableTypeBasic(Integer.class));
    }

    @Override
    public SqmPath visitCollectionIndexFunction(HqlParser.CollectionIndexFunctionContext ctx) {
        String alias = ctx.identifier().getText();
        SqmFrom sqmFrom = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias);
        if (sqmFrom == null) {
            throw new ParsingException("Could not resolve identification variable [" + alias + "] to SqmFrom");
        }
        PluralValuedNavigable pluralValuedNavigable = sqmFrom.as(PluralValuedNavigable.class, () -> new ParsingException("Could not resolve identification variable [" + alias + "] as plural-attribute"));
        if (pluralValuedNavigable.getCollectionDescriptor().getIndexDescriptor() == null) {
            throw new SemanticException("index() function can only be applied to identification variables which resolve to an indexed collection (map,list); specified identification variable [" + alias + "] resolved to " + sqmFrom);
        }
        return pluralValuedNavigable.getCollectionDescriptor().getIndexDescriptor().createSqmExpression(sqmFrom, this);
    }

    private boolean isIndexedPluralAttribute(SqmPath path) {
        return path.getReferencedNavigable() instanceof PluralValuedNavigable;
    }

    @Override
    public SqmMaxElementPath visitMaxElementFunction(HqlParser.MaxElementFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmMaxElementPath(this.consumePluralAttributeReference(ctx.path()));
    }

    @Override
    public SqmMinElementPath visitMinElementFunction(HqlParser.MinElementFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmMinElementPath(this.consumePluralAttributeReference(ctx.path()));
    }

    @Override
    public SqmMaxIndexPath visitMaxIndexFunction(HqlParser.MaxIndexFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (!this.isIndexedPluralAttribute(pluralPath)) {
            throw new SemanticException("maxindex() function can only be applied to path expressions which resolve to an indexed collection (list,map); specified path [" + ctx.path().getText() + "] resolved to " + pluralPath.getReferencedNavigable());
        }
        return new SqmMaxIndexPath(pluralPath);
    }

    @Override
    public SqmMinIndexPath visitMinIndexFunction(HqlParser.MinIndexFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (!this.isIndexedPluralAttribute(pluralPath)) {
            throw new SemanticException("minindex() function can only be applied to path expressions which resolve to an indexed collection (list,map); specified path [" + ctx.path().getText() + "] resolved to " + pluralPath.getReferencedNavigable());
        }
        return new SqmMinIndexPath(pluralPath);
    }

    @Override
    public SqmSubQuery visitSubQueryExpression(HqlParser.SubQueryExpressionContext ctx) {
        if (ctx.querySpec().selectClause() == null) {
            throw new SemanticException("Sub-query cannot use implicit select-clause : " + ctx.getText());
        }
        SqmQuerySpec querySpec = this.visitQuerySpec(ctx.querySpec());
        return new SqmSubQuery(querySpec, SemanticQueryBuilder.determineTypeDescriptor(querySpec.getSelectClause()));
    }

    private static ExpressableType determineTypeDescriptor(SqmSelectClause selectClause) {
        if (selectClause.getSelections().size() != 1) {
            return null;
        }
        SqmSelectableNode selectableNode = selectClause.getSelections().get(0).getSelectableNode();
        if (SqmDynamicInstantiation.class.isInstance(selectableNode)) {
            throw new HibernateException("Illegal use of dynamic-instantiation in sub-query");
        }
        return ((SqmExpression)selectableNode).getExpressableType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SemanticPathPart visitPath(HqlParser.PathContext ctx) {
        if (ctx.syntacticDomainPath() != null) {
            SemanticPathPart syntacticNavigablePathResult = this.visitSyntacticDomainPath(ctx.syntacticDomainPath());
            if (ctx.pathContinuation() != null) {
                this.identifierConsumerStack.push(new BasicDotIdentifierConsumer(syntacticNavigablePathResult, this.processingStateStack::getCurrent){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    SemanticPathPart semanticPathPart = (SemanticPathPart)ctx.pathContinuation().accept(this);
                    return semanticPathPart;
                }
                finally {
                    this.identifierConsumerStack.pop();
                }
            }
            return syntacticNavigablePathResult;
        }
        if (ctx.generalPathFragment() != null) {
            return (SemanticPathPart)ctx.generalPathFragment().accept(this);
        }
        throw new ParsingException("Unrecognized `path` rule branch");
    }

    @Override
    public SemanticPathPart visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        return this.visitDotIdentifierSequence(ctx.dotIdentifierSequence());
    }

    @Override
    public SemanticPathPart visitSyntacticDomainPath(HqlParser.SyntacticDomainPathContext ctx) {
        if (ctx.treatedNavigablePath() != null) {
            return this.visitTreatedNavigablePath(ctx.treatedNavigablePath());
        }
        if (ctx.collectionElementNavigablePath() != null) {
            return this.visitCollectionElementNavigablePath(ctx.collectionElementNavigablePath());
        }
        if (ctx.mapKeyNavigablePath() != null) {
            return this.visitMapKeyNavigablePath(ctx.mapKeyNavigablePath());
        }
        if (ctx.dotIdentifierSequence() != null && ctx.indexedPathAccessFragment() != null) {
            SqmNavigableJoin indexedJoinPath = (SqmNavigableJoin)ctx.dotIdentifierSequence().accept(this);
            return new SqmIndexedCollectionAccessPath(indexedJoinPath, (SqmExpression)ctx.indexedPathAccessFragment().accept(this));
        }
        throw new ParsingException("Unsure how to process `syntacticDomainPath` over : " + ctx.getText());
    }

    @Override
    public SemanticPathPart visitDotIdentifierSequence(HqlParser.DotIdentifierSequenceContext ctx) {
        int numberOfContinuations = ctx.dotIdentifierSequenceContinuation().size();
        boolean hasContinuations = numberOfContinuations != 0;
        DotIdentifierConsumer dotIdentifierConsumer = this.identifierConsumerStack.getCurrent();
        dotIdentifierConsumer.consumeIdentifier(ctx.identifier().getText(), true, !hasContinuations);
        if (hasContinuations) {
            int i = 1;
            for (HqlParser.DotIdentifierSequenceContinuationContext continuation : ctx.dotIdentifierSequenceContinuation()) {
                dotIdentifierConsumer.consumeIdentifier(continuation.identifier().getText(), false, i++ >= numberOfContinuations);
            }
        }
        return dotIdentifierConsumer.getConsumedPart();
    }

    @Override
    public Object visitDotIdentifierSequenceContinuation(HqlParser.DotIdentifierSequenceContinuationContext ctx) {
        return super.visitDotIdentifierSequenceContinuation(ctx);
    }

    @Override
    public SqmPath visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx) {
        SqmPath sqmPath = this.consumeNavigableContainerReference(ctx.path());
        String treatTargetName = ctx.dotIdentifierSequence().getText();
        EntityTypeDescriptor treatTarget = this.getCreationContext().getDomainModel().getEntityDescriptor(treatTargetName);
        return new SqmTreatedPath(sqmPath, treatTarget);
    }

    @Override
    public SqmPath visitCollectionElementNavigablePath(HqlParser.CollectionElementNavigablePathContext ctx) {
        SqmPath sqmPath = this.consumeNavigableContainerReference(ctx.path());
        PluralValuedNavigable pluralValuedNavigable = sqmPath.as(PluralValuedNavigable.class);
        if (this.getCreationOptions().useStrictJpaCompliance() && pluralValuedNavigable.getCollectionDescriptor().getCollectionClassification() != CollectionClassification.MAP) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.VALUE_FUNCTION_ON_NON_MAP);
        }
        SqmPath result = pluralValuedNavigable.getCollectionDescriptor().getElementDescriptor().createSqmExpression(sqmPath, this);
        if (ctx.pathContinuation() != null) {
            result = this.consumeDomainPath(ctx.path());
        }
        return result;
    }

    @Override
    public SqmPath visitMapKeyNavigablePath(HqlParser.MapKeyNavigablePathContext ctx) {
        SqmPath sqmPath = this.consumeDomainPath(ctx.path());
        SqmNavigableReference result = sqmPath.as(PersistentCollectionDescriptor.class).getIndexDescriptor().createSqmExpression(sqmPath, this);
        if (ctx.pathContinuation() != null) {
            return this.consumeDomainPath(ctx.path());
        }
        return result;
    }

    private SqmPath consumeDomainPath(HqlParser.PathContext parserPath) {
        parserPath.accept(this);
        DotIdentifierConsumer dotIdentifierConsumer = this.identifierConsumerStack.getCurrent();
        SemanticPathPart consumedPart = dotIdentifierConsumer.getConsumedPart();
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new SemanticException("Expecting domain-model path, but found : " + consumedPart);
    }

    private SqmPath consumeDomainPath(HqlParser.DotIdentifierSequenceContext sequence) {
        sequence.accept(this);
        DotIdentifierConsumer dotIdentifierConsumer = this.identifierConsumerStack.getCurrent();
        SemanticPathPart consumedPart = dotIdentifierConsumer.getConsumedPart();
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new SemanticException("Expecting domain-model path, but found : " + consumedPart);
    }

    private SqmPath consumeNavigableContainerReference(HqlParser.PathContext parserPath) {
        SqmPath sqmPath = this.consumeDomainPath(parserPath);
        Navigable<?> navigable = sqmPath.getReferencedNavigable();
        if (navigable instanceof NavigableContainer) {
            return sqmPath;
        }
        throw new SemanticException("Expecting NavigableContainer-valued path, but found : " + navigable);
    }

    private SqmPath consumePluralAttributeReference(HqlParser.PathContext parserPath) {
        SqmPath sqmPath = this.consumeDomainPath(parserPath);
        Navigable<?> navigable = sqmPath.getReferencedNavigable();
        try {
            sqmPath.getReferencedNavigable().as(PluralValuedNavigable.class);
            return sqmPath;
        }
        catch (Exception e) {
            throw new SemanticException("Expecting PluralAttribute-valued path, but found : " + navigable);
        }
    }

    private static class TreatHandlerFromClause
    implements TreatHandler {
        private TreatHandlerFromClause() {
        }

        @Override
        public void addDowncast(SqmFrom sqmFrom, IdentifiableTypeDescriptor downcastTarget) {
            ((MutableUsageDetails)sqmFrom.getUsageDetails()).addDownCast(true, downcastTarget, DowncastLocation.FROM);
        }
    }

    private static class TreatHandlerNormal
    implements TreatHandler {
        private final DowncastLocation downcastLocation;

        public TreatHandlerNormal() {
            this(DowncastLocation.OTHER);
        }

        public TreatHandlerNormal(DowncastLocation downcastLocation) {
            this.downcastLocation = downcastLocation;
        }

        @Override
        public void addDowncast(SqmFrom sqmFrom, IdentifiableTypeDescriptor downcastTarget) {
            ((MutableUsageDetails)sqmFrom.getUsageDetails()).addDownCast(false, downcastTarget, this.downcastLocation);
        }
    }

    private static interface TreatHandler {
        public void addDowncast(SqmFrom var1, IdentifiableTypeDescriptor var2);
    }
}

