/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.TemporalType;
import org.hibernate.Internal;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.metamodel.model.domain.spi.AllowableTemporalParameterType;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.StandardSpiBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

@Internal
public class BindingTypeHelper {
    private static final Logger log = Logger.getLogger(BindingTypeHelper.class);
    public static final BindingTypeHelper INSTANCE = new BindingTypeHelper();

    private BindingTypeHelper() {
    }

    public <T> AllowableParameterType<T> resolveTemporalPrecision(TemporalType precision, AllowableParameterType baseType, TypeConfiguration typeConfiguration) {
        if (!(baseType instanceof AllowableTemporalParameterType)) {
            throw new UnsupportedOperationException("Cannot treat non-temporal parameter type with temporal precision");
        }
        return ((AllowableTemporalParameterType)baseType).resolveTemporalPrecision(precision, typeConfiguration);
    }

    public BasicType resolveTimestampTemporalTypeVariant(Class javaType, AllowableParameterType baseType) {
        if (baseType != null && baseType instanceof BasicType) {
            return (BasicType)baseType;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.CALENDAR;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.TIMESTAMP;
        }
        if (Instant.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.INSTANT;
        }
        if (OffsetDateTime.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.OFFSET_DATE_TIME;
        }
        if (ZonedDateTime.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.ZONED_DATE_TIME;
        }
        if (OffsetTime.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.OFFSET_TIME;
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#TIMESTAMP");
    }

    public AllowableParameterType resolveDateTemporalTypeVariant(Class javaType, AllowableParameterType baseType) {
        if (baseType != null && baseType instanceof BasicType && baseType.getJavaTypeDescriptor().getJavaType().isAssignableFrom(javaType)) {
            return baseType;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.CALENDAR_DATE;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.TIMESTAMP;
        }
        if (Instant.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.OFFSET_DATE_TIME;
        }
        if (OffsetDateTime.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.OFFSET_DATE_TIME;
        }
        if (ZonedDateTime.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.ZONED_DATE_TIME;
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#DATE");
    }

    public BasicType resolveTimeTemporalTypeVariant(Class javaType, AllowableParameterType baseType) {
        if (Calendar.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.CALENDAR_TIME;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return StandardSpiBasicTypes.TIMESTAMP;
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#TIME");
    }
}

