/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.query.named.spi.NamedCallableQueryMemento;
import org.hibernate.query.named.spi.NamedHqlQueryMemento;
import org.hibernate.query.named.spi.NamedNativeQueryMemento;
import org.hibernate.query.spi.NamedQueryRepository;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.ResultSetMappingDescriptor;
import org.jboss.logging.Logger;

@Incubating
public class NamedQueryRepositoryImpl
implements NamedQueryRepository {
    private static final Logger log = Logger.getLogger(NamedQueryRepository.class);
    private final Map<String, NamedHqlQueryMemento> namedHqlQueryDescriptorMap;
    private final Map<String, NamedNativeQueryMemento> namedNativeQueryDescriptorMap;
    private final Map<String, NamedCallableQueryMemento> procedureCallMementoMap;
    private final Map<String, ResultSetMappingDescriptor> namedSqlResultSetMappingMap;

    public NamedQueryRepositoryImpl(Map<String, NamedHqlQueryMemento> namedHqlQueryDescriptorMap, Map<String, NamedNativeQueryMemento> namedNativeQueryDescriptorMap, Map<String, NamedCallableQueryMemento> namedProcedureCallMap, Map<String, ResultSetMappingDescriptor> namedSqlResultSetMappingMap) {
        this.namedHqlQueryDescriptorMap = namedHqlQueryDescriptorMap;
        this.namedNativeQueryDescriptorMap = namedNativeQueryDescriptorMap;
        this.namedSqlResultSetMappingMap = namedSqlResultSetMappingMap;
        this.procedureCallMementoMap = namedProcedureCallMap;
    }

    @Override
    public NamedHqlQueryMemento getHqlQueryMemento(String queryName) {
        return this.namedHqlQueryDescriptorMap.get(queryName);
    }

    @Override
    public void visitHqlQueryMementos(Consumer<NamedHqlQueryMemento> action) {
        this.namedHqlQueryDescriptorMap.values().forEach(action);
    }

    @Override
    public NamedNativeQueryMemento getNativeQueryMemento(String queryName) {
        return this.namedNativeQueryDescriptorMap.get(queryName);
    }

    @Override
    public void visitNativeQueryMementos(Consumer<NamedNativeQueryMemento> action) {
        this.namedNativeQueryDescriptorMap.values().forEach(action);
    }

    @Override
    public NamedCallableQueryMemento getCallableQueryMemento(String name) {
        return this.procedureCallMementoMap.get(name);
    }

    @Override
    public void visitCallableQueryMementos(Consumer<NamedCallableQueryMemento> action) {
        this.procedureCallMementoMap.values().forEach(action);
    }

    @Override
    public ResultSetMappingDescriptor getResultSetMappingDescriptor(String mappingName) {
        return this.namedSqlResultSetMappingMap.get(mappingName);
    }

    @Override
    public void visitResultSetMappingDescriptors(Consumer<ResultSetMappingDescriptor> action) {
        this.namedSqlResultSetMappingMap.values().forEach(action);
    }

    @Override
    public synchronized void registerHqlQueryMemento(String name, NamedHqlQueryMemento descriptor) {
        NamedHqlQueryMemento previous;
        if (!name.equals(descriptor.getName())) {
            descriptor = descriptor.makeCopy(name);
        }
        if ((previous = this.namedHqlQueryDescriptorMap.put(name, descriptor)) != null) {
            log.debugf("registering named query descriptor [%s] overriding previously registered descriptor [%s]", (Object)name, (Object)previous);
        }
    }

    @Override
    public void registerNativeQueryMemento(String name, NamedNativeQueryMemento descriptor) {
        NamedNativeQueryMemento previous;
        if (!name.equals(descriptor.getName())) {
            descriptor = descriptor.makeCopy(name);
        }
        if ((previous = this.namedNativeQueryDescriptorMap.put(name, descriptor)) != null) {
            log.debugf("registering named SQL query descriptor [%s] overriding previously registered descriptor [%s]", (Object)name, (Object)previous);
        }
    }

    @Override
    public synchronized void registerCallableQueryMemento(String name, NamedCallableQueryMemento memento) {
        NamedCallableQueryMemento previous = this.procedureCallMementoMap.put(name, memento);
        if (previous != null) {
            log.debugf("registering named procedure call definition [%s] overriding previously registered definition [%s]", (Object)name, (Object)previous);
        }
    }

    @Override
    public void registerNamedResultSetMappingDescriptor(String name, ResultSetMappingDescriptor memento) {
        ResultSetMappingDescriptor previous = this.namedSqlResultSetMappingMap.put(name, memento);
        if (previous != null) {
            log.debugf("registering named result-set-mapping definition [%s] overriding previously registered definition [%s]", (Object)name, (Object)previous);
        }
    }

    @Override
    public Map<String, HibernateException> checkNamedQueries(QueryEngine queryEngine) {
        HashMap<String, HibernateException> errors = new HashMap<String, HibernateException>();
        log.debugf("Checking %s named HQL queries", this.namedHqlQueryDescriptorMap.size());
        for (NamedHqlQueryMemento namedHqlQueryDescriptor : this.namedHqlQueryDescriptorMap.values()) {
            try {
                log.debugf("Checking named query: %s", (Object)namedHqlQueryDescriptor.getName());
                queryEngine.getSemanticQueryProducer().interpret(namedHqlQueryDescriptor.getQueryString());
            }
            catch (HibernateException e) {
                errors.put(namedHqlQueryDescriptor.getName(), e);
            }
        }
        log.debugf("Checking %s named SQL queries", this.namedNativeQueryDescriptorMap.size());
        for (NamedNativeQueryMemento namedNativeQueryDescriptor : this.namedNativeQueryDescriptorMap.values()) {
            try {
                log.debugf("Checking named SQL query: %s", (Object)namedNativeQueryDescriptor.getName());
                throw new NotYetImplementedFor6Exception();
            }
            catch (HibernateException e) {
                errors.put(namedNativeQueryDescriptor.getName(), e);
            }
        }
        return errors;
    }

    @Override
    public void close() {
        this.namedHqlQueryDescriptorMap.clear();
        this.namedNativeQueryDescriptorMap.clear();
        this.procedureCallMementoMap.clear();
        this.namedSqlResultSetMappingMap.clear();
    }
}

