/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.persistence.Parameter;
import org.hibernate.QueryException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterImplementor;

public class ParameterMetadataImpl
implements ParameterMetadataImplementor<QueryParameterImplementor<?>> {
    public static final ParameterMetadataImpl EMPTY = new ParameterMetadataImpl();
    private final Set<QueryParameterImplementor<?>> queryParameters;
    private final Set<String> names;
    private final Set<Integer> labels;

    private ParameterMetadataImpl() {
        this.queryParameters = Collections.emptySet();
        this.names = Collections.emptySet();
        this.labels = Collections.emptySet();
    }

    public ParameterMetadataImpl(Set<QueryParameterImplementor<?>> queryParameters) {
        this.queryParameters = queryParameters;
        HashSet<String> names = null;
        HashSet<Integer> labels = null;
        for (QueryParameterImplementor<?> queryParameter : queryParameters) {
            if (queryParameter.getPosition() != null) {
                if (labels == null) {
                    labels = new HashSet<Integer>();
                }
                labels.add(queryParameter.getPosition());
                continue;
            }
            if (queryParameter.getName() == null) continue;
            if (names == null) {
                names = new HashSet<String>();
            }
            names.add(queryParameter.getName());
        }
        this.labels = labels == null ? Collections.emptySet() : labels;
        this.names = names == null ? Collections.emptySet() : names;
        ParameterMetadataImpl.verifyOrdinalParamLabels(labels);
    }

    public ParameterMetadataImpl(Map<Integer, QueryParameterImplementor<?>> positionalQueryParameters, Map<String, QueryParameterImplementor<?>> namedQueryParameters) {
        if (CollectionHelper.isEmpty(positionalQueryParameters) && CollectionHelper.isEmpty(namedQueryParameters)) {
            this.queryParameters = Collections.emptySet();
            this.names = Collections.emptySet();
            this.labels = Collections.emptySet();
        } else {
            this.queryParameters = new IdentitySet();
            this.queryParameters.addAll(positionalQueryParameters.values());
            this.queryParameters.addAll(namedQueryParameters.values());
            this.names = namedQueryParameters.keySet();
            this.labels = positionalQueryParameters.keySet();
            ParameterMetadataImpl.verifyOrdinalParamLabels(this.labels);
        }
    }

    private static void verifyOrdinalParamLabels(Set<Integer> labels) {
        if (CollectionHelper.isEmpty(labels)) {
            return;
        }
        ArrayList<Integer> sortedLabels = new ArrayList<Integer>(labels);
        sortedLabels.sort(ComparableComparator.instance());
        int lastPosition = -1;
        for (Integer sortedPosition : sortedLabels) {
            if (lastPosition == -1) {
                if (sortedPosition != 1) {
                    throw new QueryException(String.format(Locale.ROOT, "Expected ordinal parameter labels to start with 1, but found - %s", sortedPosition));
                }
                lastPosition = sortedPosition;
                continue;
            }
            if (sortedPosition != lastPosition + 1) {
                throw new QueryException(String.format(Locale.ROOT, "Unexpected gap in ordinal parameter labels [%s -> %s] : [%s]", lastPosition, sortedPosition, StringHelper.join(",", sortedLabels.iterator())));
            }
            lastPosition = sortedPosition;
        }
    }

    @Override
    public int getParameterCount() {
        return this.queryParameters.size();
    }

    @Override
    public boolean containsReference(QueryParameterImplementor<?> parameter) {
        return this.queryParameters.contains(parameter);
    }

    @Override
    public void visitRegistrations(Consumer<QueryParameterImplementor<?>> action) {
        this.queryParameters.forEach(action);
    }

    @Override
    public void collectAllParameters(ParameterMetadataImplementor.ParameterCollector<QueryParameterImplementor<?>> collector) {
        this.queryParameters.forEach(collector::collect);
    }

    @Override
    public Set<QueryParameterImplementor<?>> getRegistrations() {
        return Collections.unmodifiableSet(this.queryParameters);
    }

    @Override
    public boolean hasAnyMatching(Predicate<QueryParameterImplementor<?>> filter) {
        for (QueryParameterImplementor<?> queryParameter : this.queryParameters) {
            if (!filter.test(queryParameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public QueryParameterImplementor<?> resolve(Parameter param) {
        if (param instanceof QueryParameterImplementor) {
            return (QueryParameterImplementor)param;
        }
        throw new IllegalArgumentException("Could not resolve javax.persistence.Parameter to org.hibernate.query.QueryParameter");
    }

    @Override
    public boolean hasNamedParameters() {
        return !this.names.isEmpty();
    }

    @Override
    public Set<String> getNamedParameterNames() {
        return this.names;
    }

    @Override
    public QueryParameterImplementor<?> getQueryParameter(String name) {
        for (QueryParameterImplementor<?> queryParameter : this.queryParameters) {
            if (!name.equals(queryParameter.getName())) continue;
            return queryParameter;
        }
        return null;
    }

    @Override
    public boolean hasPositionalParameters() {
        return !this.labels.isEmpty();
    }

    @Override
    public Set<Integer> getOrdinalParameterLabels() {
        return this.labels;
    }

    @Override
    public QueryParameterImplementor<?> getQueryParameter(int positionLabel) {
        for (QueryParameterImplementor<?> queryParameter : this.queryParameters) {
            if (queryParameter.getPosition() == null || queryParameter.getPosition() != positionLabel) continue;
            return queryParameter;
        }
        return null;
    }
}

