/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.consume.internal.SqmConsumeHelper;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.sqm.spi.SqmInterpretation;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.spi.TypeConfiguration;

public class QueryHelper {
    private QueryHelper() {
    }

    public static JdbcParameterBindings buildJdbcParameterBindings(SqmStatement sqmStatement, SqmInterpretation sqmInterpretation, ExecutionContext executionContext) {
        DomainParameterXref domainParameterXref = DomainParameterXref.from(sqmStatement);
        Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref = SqmConsumeHelper.generateJdbcParamsXref(domainParameterXref, sqmInterpretation);
        return QueryHelper.createJdbcParameterBindings(executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), domainParameterXref, jdbcParamsXref, executionContext.getSession());
    }

    public static JdbcParameterBindings buildJdbcParameterBindings(SqmStatement sqmStatement, Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref, ExecutionContext executionContext) {
        DomainParameterXref domainParameterXref = DomainParameterXref.from(sqmStatement);
        return QueryHelper.createJdbcParameterBindings(executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), domainParameterXref, jdbcParamsXref, executionContext.getSession());
    }

    public static JdbcParameterBindings buildJdbcParameterBindings(DomainParameterXref domainParameterXref, Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref, ExecutionContext executionContext) {
        return QueryHelper.createJdbcParameterBindings(executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), domainParameterXref, jdbcParamsXref, executionContext.getSession());
    }

    public static JdbcParameterBindings createJdbcParameterBindings(QueryParameterBindings<QueryParameterBinding<?>> domainParamBindings, DomainParameterXref domainParameterXref, Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamXref, SharedSessionContractImplementor session) {
        final JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter>> entry : domainParameterXref.getSqmParamByQueryParam().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter> sqmParameters = entry.getValue();
            QueryParameterBinding<?> domainParamBinding = domainParamBindings.getBinding(queryParam);
            AllowableParameterType parameterType = QueryHelper.determineParameterType(domainParamBinding, queryParam, session);
            Map<SqmParameter, List<JdbcParameter>> jdbcParamMap = jdbcParamXref.get(queryParam);
            for (SqmParameter sqmParameter : sqmParameters) {
                final List<JdbcParameter> jdbcParams = jdbcParamMap.get(sqmParameter);
                if (!domainParamBinding.isBound()) {
                    parameterType.visitJdbcTypes(new Consumer<SqlExpressableType>(){
                        int position = 0;

                        @Override
                        public void accept(SqlExpressableType jdbcType) {
                            final JdbcParameter jdbcParameter = (JdbcParameter)jdbcParams.get(this.position++);
                            jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBinding(){

                                @Override
                                public SqlExpressableType getBindType() {
                                    return jdbcParameter.getType();
                                }

                                @Override
                                public Object getBindValue() {
                                    return null;
                                }
                            });
                        }
                    }, Clause.IRRELEVANT, session.getFactory().getTypeConfiguration());
                    continue;
                }
                if (domainParamBinding.isMultiValued()) {
                    Collection<?> bindValues = domainParamBinding.getBindValues();
                    Iterator<?> valueItr = bindValues.iterator();
                    QueryHelper.createValueBindings(jdbcParameterBindings, parameterType, jdbcParams, valueItr.next(), session);
                    List<SqmParameter> expansions = domainParameterXref.getExpansions(sqmParameter);
                    assert (expansions.size() == bindValues.size() - 1);
                    int expansionPosition = 0;
                    while (valueItr.hasNext()) {
                        SqmParameter expansionSqmParam = expansions.get(expansionPosition++);
                        List<JdbcParameter> expansionJdbcParams = jdbcParamMap.get(expansionSqmParam);
                        QueryHelper.createValueBindings(jdbcParameterBindings, parameterType, expansionJdbcParams, valueItr.next(), session);
                    }
                    continue;
                }
                Object bindValue = domainParamBinding.getBindValue();
                QueryHelper.createValueBindings(jdbcParameterBindings, parameterType, jdbcParams, bindValue, session);
            }
        }
        return jdbcParameterBindings;
    }

    private static void createValueBindings(final JdbcParameterBindings jdbcParameterBindings, AllowableParameterType<?> parameterType, final List<JdbcParameter> jdbcParams, Object bindValue, SharedSessionContractImplementor session) {
        parameterType.dehydrate(parameterType.unresolve(bindValue, session), new Writeable.JdbcValueCollector(){
            private int position = 0;

            @Override
            public void collect(final Object jdbcValue, SqlExpressableType type, Column boundColumn) {
                final JdbcParameter jdbcParameter = (JdbcParameter)jdbcParams.get(this.position);
                jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBinding(){

                    @Override
                    public SqlExpressableType getBindType() {
                        return jdbcParameter.getType();
                    }

                    @Override
                    public Object getBindValue() {
                        return jdbcValue;
                    }
                });
                ++this.position;
            }
        }, Clause.IRRELEVANT, session);
    }

    private static AllowableParameterType determineParameterType(QueryParameterBinding<?> binding, QueryParameterImplementor<?> parameter, SharedSessionContractImplementor session) {
        if (binding.getBindType() != null) {
            return binding.getBindType();
        }
        if (parameter.getHibernateType() != null) {
            return parameter.getHibernateType();
        }
        TypeConfiguration typeConfiguration = session.getFactory().getTypeConfiguration();
        return typeConfiguration.standardExpressableTypeForJavaType(parameter.getParameterType());
    }
}

