/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryPlanCache;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.tree.SqmStatement;

public class QueryPlanCacheImpl
implements QueryPlanCache {
    private final SessionFactoryImplementor sessionFactory;
    public static final int DEFAULT_PARAMETER_METADATA_MAX_COUNT = 128;
    public static final int DEFAULT_QUERY_PLAN_MAX_COUNT = 2048;
    private final BoundedConcurrentHashMap queryPlanCache;
    private final BoundedConcurrentHashMap sqmStatementCache;

    public QueryPlanCacheImpl(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        Integer maxQueryPlanCount = ConfigurationHelper.getInteger("hibernate.query.plan_cache_max_size", sessionFactory.getProperties());
        if (maxQueryPlanCount == null) {
            maxQueryPlanCount = ConfigurationHelper.getInt("hibernate.query.plan_cache_max_size", sessionFactory.getProperties(), 2048);
        }
        this.queryPlanCache = new BoundedConcurrentHashMap(maxQueryPlanCount, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.sqmStatementCache = new BoundedConcurrentHashMap(maxQueryPlanCount, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    @Override
    public SelectQueryPlan getSelectQueryPlan(QueryPlanCache.Key key) {
        return (SelectQueryPlan)this.queryPlanCache.get(key);
    }

    @Override
    public void cacheSelectQueryPlan(QueryPlanCache.Key key, SelectQueryPlan plan) {
        this.queryPlanCache.putIfAbsent(key, plan);
    }

    @Override
    public NonSelectQueryPlan getNonSelectQueryPlan(QueryPlanCache.Key key) {
        return null;
    }

    @Override
    public void cacheNonSelectQueryPlan(QueryPlanCache.Key key, NonSelectQueryPlan plan) {
    }

    @Override
    public SqmStatement getSqmStatement(String queryString) {
        return (SqmStatement)this.sqmStatementCache.get(queryString);
    }

    @Override
    public void cacheSqmStatement(String key, SqmStatement sqmStatement) {
        this.sqmStatementCache.putIfAbsent(key, sqmStatement);
    }

    @Override
    public void close() {
        this.queryPlanCache.clear();
    }
}

