/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.named.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.query.named.spi.AbstractNamedQueryMemento;
import org.hibernate.query.named.spi.NamedCallableQueryMemento;
import org.hibernate.query.named.spi.ParameterMemento;
import org.hibernate.query.named.spi.RowReaderMemento;

public class NamedCallableQueryMementoImpl
extends AbstractNamedQueryMemento
implements NamedCallableQueryMemento {
    private final String callableName;
    private final ParameterStrategy parameterStrategy;
    private final Class[] resultClasses;
    private final String[] resultSetMappingNames;
    private final Set<String> querySpaces;

    public NamedCallableQueryMementoImpl(String name, String callableName, ParameterStrategy parameterStrategy, List<ParameterMemento> parameterMementos, Class[] resultClasses, String[] resultSetMappingNames, Set<String> querySpaces, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, LockOptions lockOptions, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        super(name, parameterMementos, cacheable, cacheRegion, cacheMode, flushMode, readOnly, lockOptions, timeout, fetchSize, comment, hints);
        this.callableName = callableName;
        this.parameterStrategy = parameterStrategy;
        this.resultClasses = resultClasses;
        this.resultSetMappingNames = resultSetMappingNames;
        this.querySpaces = querySpaces;
    }

    public NamedCallableQueryMementoImpl(String name, String procedureName, ParameterStrategy parameterStrategy, List<ParameterMemento> parameterMementos, RowReaderMemento rowReaderMemento, Set<String> querySpaces, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, LockOptions lockOptions, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        this(name, procedureName, parameterStrategy, parameterMementos, rowReaderMemento.getResultClasses(), rowReaderMemento.getResultMappingNames(), querySpaces, cacheable, cacheRegion, cacheMode, flushMode, readOnly, lockOptions, timeout, fetchSize, comment, hints);
    }

    @Override
    public String getCallableName() {
        return this.callableName;
    }

    public ParameterStrategy getParameterStrategy() {
        return this.parameterStrategy;
    }

    @Override
    public Set<String> getQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    public String getQueryString() {
        return this.callableName;
    }

    @Override
    public Class[] getResultClasses() {
        return this.resultClasses;
    }

    @Override
    public String[] getResultSetMappingNames() {
        return this.resultSetMappingNames;
    }

    @Override
    public NamedCallableQueryMemento makeCopy(String name) {
        return new NamedCallableQueryMementoImpl(name, this.getCallableName(), this.getParameterStrategy(), this.getParameterMementos(), this.resultClasses, this.resultSetMappingNames, this.getQuerySpaces(), this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHintsCopy());
    }

    @Override
    public <T> ProcedureCallImplementor<T> toQuery(SharedSessionContractImplementor session, Class<T> resultType) {
        return ProcedureCallImpl.fromMemento(this, session);
    }
}

