/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.named.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.named.spi.AbstractNamedQueryMemento;
import org.hibernate.query.named.spi.NamedHqlQueryMemento;
import org.hibernate.query.named.spi.ParameterMemento;
import org.hibernate.query.spi.HqlQueryImplementor;
import org.hibernate.query.sqm.internal.QuerySqmImpl;

public class NamedHqlQueryMementoImpl
extends AbstractNamedQueryMemento
implements NamedHqlQueryMemento {
    private final String hqlString;
    private final Integer firstResult;
    private final Integer maxResults;

    public NamedHqlQueryMementoImpl(String name, List<ParameterMemento> parameterMementos, String hqlString, Integer firstResult, Integer maxResults, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, LockOptions lockOptions, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        super(name, parameterMementos, cacheable, cacheRegion, cacheMode, flushMode, readOnly, lockOptions, timeout, fetchSize, comment, hints);
        this.hqlString = hqlString;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    @Override
    public String getHqlString() {
        return this.hqlString;
    }

    @Override
    public NamedHqlQueryMemento makeCopy(String name) {
        return new NamedHqlQueryMementoImpl(name, this.getParameterMementos(), this.getHqlString(), this.firstResult, this.maxResults, this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    @Override
    public <T> HqlQueryImplementor<T> toQuery(SharedSessionContractImplementor session, Class<T> resultType) {
        QuerySqmImpl query = new QuerySqmImpl(this.hqlString, session.getFactory().getQueryEngine().getSemanticQueryProducer().interpret(this.hqlString), resultType, session);
        if (this.firstResult != null) {
            query.setFirstResult(this.firstResult);
        }
        if (this.maxResults != null) {
            query.setMaxResults(this.maxResults);
        }
        this.applyBaseOptions(query, session);
        return query;
    }
}

