/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.named.spi;

import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.internal.Util;
import org.hibernate.query.named.spi.NamedQueryMemento;
import org.hibernate.query.named.spi.ParameterMemento;
import org.hibernate.query.spi.QueryImplementor;

public abstract class AbstractNamedQueryMemento
implements NamedQueryMemento {
    private final String name;
    private final List<ParameterMemento> parameterMementos;
    private final Boolean cacheable;
    private final String cacheRegion;
    private final CacheMode cacheMode;
    private final FlushMode flushMode;
    private final Boolean readOnly;
    private final LockOptions lockOptions;
    private final Integer timeout;
    private final Integer fetchSize;
    private final String comment;
    private final Map<String, Object> hints;

    public AbstractNamedQueryMemento(String name, List<ParameterMemento> parameterMementos, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, LockOptions lockOptions, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        this.name = name;
        this.parameterMementos = parameterMementos;
        this.cacheable = cacheable;
        this.cacheRegion = cacheRegion;
        this.cacheMode = cacheMode;
        this.flushMode = flushMode;
        this.readOnly = readOnly;
        this.lockOptions = lockOptions;
        this.timeout = timeout;
        this.fetchSize = fetchSize;
        this.comment = comment;
        this.hints = hints;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ParameterMemento> getParameterMementos() {
        return this.parameterMementos;
    }

    @Override
    public Boolean getCacheable() {
        return this.cacheable;
    }

    @Override
    public String getCacheRegion() {
        return this.cacheRegion;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Map<String, Object> getHints() {
        return this.hints;
    }

    protected Map<String, Object> getHintsCopy() {
        return Util.copy(this.hints);
    }

    protected void applyBaseOptions(QueryImplementor query, SharedSessionContractImplementor session) {
        this.getHints().forEach(query::setHint);
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable);
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.cacheMode != null) {
            query.setCacheMode(this.cacheMode);
        }
        if (this.flushMode != null) {
            query.setHibernateFlushMode(this.flushMode);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly);
        }
        if (this.lockOptions != null) {
            query.setLockOptions(this.lockOptions);
        }
        if (this.timeout != null) {
            query.setTimeout(this.timeout);
        }
        if (this.fetchSize != null) {
            query.setFetchSize(this.fetchSize);
        }
        if (this.comment != null) {
            query.setComment(this.comment);
        }
    }
}

