/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.QueryLogger;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.query.criteria.spi.CriteriaNodeBuilder;
import org.hibernate.query.internal.QueryPlanCacheImpl;
import org.hibernate.query.spi.NamedQueryRepository;
import org.hibernate.query.spi.QueryPlanCache;
import org.hibernate.query.sqm.produce.SemanticQueryProducer;
import org.hibernate.query.sqm.produce.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.internal.SemanticQueryProducerImpl;

@Incubating
public class QueryEngine {
    private final SessionFactoryImplementor sessionFactory;
    private final NamedQueryRepository namedQueryRepository;
    private final CriteriaNodeBuilder criteriaBuilder;
    private final SemanticQueryProducer semanticQueryProducer;
    private final QueryPlanCache queryPlanCache;
    private final SqmFunctionRegistry sqmFunctionRegistry;

    public QueryEngine(SessionFactoryImplementor sessionFactory, NamedQueryRepository namedQueryRepository, SqmFunctionRegistry sqmFunctionRegistry) {
        Map<String, HibernateException> errors;
        this.sessionFactory = sessionFactory;
        this.namedQueryRepository = namedQueryRepository;
        this.semanticQueryProducer = new SemanticQueryProducerImpl(sessionFactory);
        this.criteriaBuilder = new CriteriaNodeBuilder(sessionFactory);
        this.queryPlanCache = new QueryPlanCacheImpl(sessionFactory);
        this.sqmFunctionRegistry = sqmFunctionRegistry;
        if (sessionFactory.getSessionFactoryOptions().isNamedQueryStartupCheckingEnabled() && !(errors = namedQueryRepository.checkNamedQueries(this)).isEmpty()) {
            StringBuilder failingQueries = new StringBuilder("Errors in named queries: ");
            String sep = "";
            for (Map.Entry<String, HibernateException> entry : errors.entrySet()) {
                QueryLogger.QUERY_LOGGER.namedQueryError(entry.getKey(), entry.getValue());
                failingQueries.append(sep).append(entry.getKey());
                sep = ", ";
            }
            throw new HibernateException(failingQueries.toString());
        }
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public NamedQueryRepository getNamedQueryRepository() {
        return this.namedQueryRepository;
    }

    public HibernateCriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public SemanticQueryProducer getSemanticQueryProducer() {
        return this.semanticQueryProducer;
    }

    public QueryPlanCache getQueryPlanCache() {
        return this.queryPlanCache;
    }

    public SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.sqmFunctionRegistry;
    }

    public void close() {
        if (this.namedQueryRepository != null) {
            this.namedQueryRepository.close();
        }
        if (this.criteriaBuilder != null) {
            this.criteriaBuilder.close();
        }
        if (this.semanticQueryProducer != null) {
            this.semanticQueryProducer.close();
        }
        if (this.queryPlanCache != null) {
            this.queryPlanCache.close();
        }
        if (this.sqmFunctionRegistry != null) {
            this.sqmFunctionRegistry.close();
        }
    }
}

