/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.sql.results.spi.SqlSelectionReader;

public class ExtractorBasedReader
implements SqlSelectionReader {
    private final SqlExpressableType sqlExpressableType;

    public ExtractorBasedReader(SqlExpressableType sqlExpressableType) {
        this.sqlExpressableType = sqlExpressableType;
    }

    public Object read(ResultSet resultSet, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, SqlSelection sqlSelection) throws SQLException {
        return this.sqlExpressableType.getJdbcValueExtractor().extract(resultSet, sqlSelection.getJdbcResultSetIndex(), jdbcValuesSourceProcessingState.getExecutionContext());
    }

    public Object extractParameterValue(CallableStatement statement, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, int jdbcParameterIndex) throws SQLException {
        return this.sqlExpressableType.getJdbcValueExtractor().extract(statement, jdbcParameterIndex, jdbcValuesSourceProcessingState.getExecutionContext());
    }

    public Object extractParameterValue(CallableStatement statement, JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState, String jdbcParameterName) throws SQLException {
        return this.sqlExpressableType.getJdbcValueExtractor().extract(statement, jdbcParameterName, jdbcValuesSourceProcessingState.getExecutionContext());
    }
}

