/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.query.Limit;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.internal.AbstractQuery;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.named.internal.NamedNativeQueryMementoImpl;
import org.hibernate.query.named.spi.NamedNativeQueryMemento;
import org.hibernate.query.named.spi.ParameterMemento;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.NativeQueryImplementor;
import org.hibernate.query.spi.NativeQueryInterpreter;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sql.internal.LegacyResultSetMappingDescriptor;
import org.hibernate.query.sql.internal.NativeNonSelectQueryPlanImpl;
import org.hibernate.query.sql.internal.ParameterRecognizerImpl;
import org.hibernate.query.sql.spi.NativeSelectQueryDefinition;
import org.hibernate.query.sql.spi.NativeSelectQueryPlan;
import org.hibernate.query.sql.spi.NonSelectInterpretationsKey;
import org.hibernate.query.sql.spi.SelectInterpretationsKey;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.RowTransformer;
import org.hibernate.sql.results.spi.ResultSetMappingDescriptor;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public class NativeQueryImpl<R>
extends AbstractQuery<R>
implements NativeQueryImplementor<R>,
DomainParameterBindingContext,
ExecutionContext {
    private final String sqlString;
    private LegacyResultSetMappingDescriptor legacyResultSetMappingDescriptor;
    private org.hibernate.query.spi.ResultSetMappingDescriptor resultSetMappingDescriptor;
    private final ParameterMetadataImpl parameterMetadata;
    private final QueryParameterBindings parameterBindings;
    private final List<QueryParameterImplementor> queryParameterList;
    private final QueryOptionsImpl queryOptions = new QueryOptionsImpl();
    private Set<String> affectedTableNames;
    private Serializable collectionKey;

    public NativeQueryImpl(String sqlString, org.hibernate.query.spi.ResultSetMappingDescriptor resultSetMappingDescriptor, SharedSessionContractImplementor session) {
        this(sqlString, session);
        super.applyResultSetMapping(resultSetMappingDescriptor);
    }

    private void applyResultSetMapping(org.hibernate.query.spi.ResultSetMappingDescriptor resultSetMappingDescriptor) {
        this.resultSetMappingDescriptor = resultSetMappingDescriptor;
    }

    @Override
    public Query<R> applyGraph(RootGraph<?> graph, GraphSemantic semantic) {
        throw new HibernateException("A native SQL query cannot use EntityGraphs");
    }

    public NativeQueryImpl(String sqlString, SharedSessionContractImplementor session) {
        super(session);
        this.sqlString = sqlString;
        ParameterRecognizerImpl parameterRecognizer = new ParameterRecognizerImpl(session.getFactory());
        session.getFactory().getServiceRegistry().getService(NativeQueryInterpreter.class).recognizeParameters(sqlString, parameterRecognizer);
        parameterRecognizer.validate();
        this.parameterMetadata = new ParameterMetadataImpl(parameterRecognizer.getPositionalQueryParameters(), parameterRecognizer.getNamedQueryParameters());
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory());
        this.queryParameterList = parameterRecognizer.getParameterList();
    }

    public NativeQueryImpl(NamedNativeQueryMemento namedQueryDescriptor, Class<R> resultType, SharedSessionContractImplementor session) {
        this(namedQueryDescriptor.getQueryString(), session);
        namedQueryDescriptor.getQuerySpaces().forEach(string -> this.addSynchronizedQuerySpace((String)string));
        super.applyResultSetMapping(namedQueryDescriptor);
    }

    private void applyResultSetMapping(NamedNativeQueryMemento namedQueryDescriptor) {
        if (namedQueryDescriptor.getResultSetMappingName() == null) {
            return;
        }
        org.hibernate.query.spi.ResultSetMappingDescriptor resultSetMappingDescriptor = this.getSession().getFactory().getQueryEngine().getNamedQueryRepository().getResultSetMappingDescriptor(namedQueryDescriptor.getResultSetMappingName());
        if (resultSetMappingDescriptor == null) {
            throw new MappingException(String.format(Locale.ROOT, "Unable to find ResultSetMappingDescriptor [%s] specified for named native query [%s]", namedQueryDescriptor.getResultSetMappingName(), namedQueryDescriptor.getName()));
        }
        this.applyResultSetMapping(resultSetMappingDescriptor);
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public DomainParameterBindingContext getDomainParameterBindingContext() {
        return this;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.getSession().getFactory();
    }

    @Override
    public Callback getCallback() {
        return null;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public String getQueryString() {
        return this.sqlString;
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        HashSet parameters = new HashSet();
        this.parameterMetadata.collectAllParameters(parameters::add);
        return parameters;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias) {
        return this.addScalar(columnAlias, (BasicValuedExpressableType)null);
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias, Type type) {
        return this.addScalar(columnAlias, (BasicValuedExpressableType)((Object)type));
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias, BasicValuedExpressableType type) {
        if (this.resultSetMappingDescriptor != null) {
            throw new HibernateException("NativeQuery already has ResultSetMapping associated with it");
        }
        this.resolveLegacyResultSetMappingDescriptor().makeScalarRoot(columnAlias, type.getJavaTypeDescriptor());
        return this;
    }

    protected LegacyResultSetMappingDescriptor resolveLegacyResultSetMappingDescriptor() {
        if (this.legacyResultSetMappingDescriptor == null) {
            this.legacyResultSetMappingDescriptor = new LegacyResultSetMappingDescriptor(this.getSessionFactory().getTypeConfiguration());
        }
        return this.legacyResultSetMappingDescriptor;
    }

    @Override
    public NativeQuery.RootReturn addRoot(String tableAlias, String entityName) {
        return this.resolveLegacyResultSetMappingDescriptor().makeEntityRoot(entityName, tableAlias);
    }

    @Override
    public NativeQuery.RootReturn addRoot(String tableAlias, Class entityType) {
        return this.addRoot(tableAlias, entityType.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String entityName) {
        return this.addEntity(StringHelper.unqualify(entityName), entityName);
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, String entityName) {
        this.addRoot(tableAlias, entityName);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, String entityName, LockMode lockMode) {
        this.addRoot(tableAlias, entityName).setLockMode(lockMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addEntity(Class entityType) {
        return this.addEntity(entityType.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, Class entityClass) {
        return this.addEntity(tableAlias, entityClass.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, Class entityClass, LockMode lockMode) {
        return this.addEntity(tableAlias, entityClass.getName(), lockMode);
    }

    @Override
    public NativeQuery.FetchReturn addFetch(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        return this.resolveLegacyResultSetMappingDescriptor().makeFetch(ownerTableAlias, joinPropertyName, tableAlias);
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String path) {
        this.createFetchJoin(tableAlias, path);
        return this;
    }

    private NativeQuery.FetchReturn createFetchJoin(String tableAlias, String path) {
        int loc = path.indexOf(46);
        if (loc < 0) {
            throw new QueryException(String.format(Locale.ROOT, "Not a property path [%s]; should be in form [owner_alias].[fetched_attribute_name] - see Javadocs", path));
        }
        if (loc > 1) {
            throw new QueryException(String.format(Locale.ROOT, "Cannot join composite property path [%s]; should be in form [owner_alias].[fetched_attribute_name] - see Javadocs", path));
        }
        String ownerTableAlias = path.substring(0, loc);
        String joinedPropertyName = path.substring(loc + 1);
        return this.addFetch(tableAlias, ownerTableAlias, joinedPropertyName);
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        this.addFetch(tableAlias, ownerTableAlias, joinPropertyName);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String path, LockMode lockMode) {
        this.createFetchJoin(tableAlias, path).setLockMode(lockMode);
        return this;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isInstance(this)) {
            return (T)this;
        }
        if (cls.isInstance(this.parameterMetadata)) {
            return (T)this.parameterMetadata;
        }
        if (cls.isInstance(this.parameterBindings)) {
            return (T)this.parameterBindings;
        }
        if (cls.isInstance(this.queryOptions)) {
            return (T)this.queryOptions;
        }
        throw new PersistenceException("Unrecognized unwrap type [" + cls.getName() + "]");
    }

    @Override
    protected void prepareForExecution() {
        if (this.getSynchronizedQuerySpaces() != null && !this.getSynchronizedQuerySpaces().isEmpty()) {
            return;
        }
        if (this.shouldFlush()) {
            this.getSession().flush();
        }
    }

    @Override
    protected List<R> doList() {
        this.getSession().prepareForQueryExecution(false);
        return this.resolveSelectQueryPlan().performList(this);
    }

    private boolean shouldFlush() {
        if (this.getSession().isTransactionInProgress()) {
            FlushMode effectiveFlushMode = this.getHibernateFlushMode();
            if (effectiveFlushMode == null) {
                effectiveFlushMode = this.getSession().getHibernateFlushMode();
            }
            if (effectiveFlushMode == FlushMode.ALWAYS) {
                return true;
            }
            if (effectiveFlushMode == FlushMode.AUTO && this.getSession().getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                return true;
            }
        }
        return false;
    }

    private SelectQueryPlan<R> resolveSelectQueryPlan() {
        NativeSelectQueryPlan queryPlan = null;
        ResultSetMappingDescriptor resultSetMapping = this.resolveResultMapping();
        RowTransformer rowTransformer = this.resolveRowTransformer();
        SelectInterpretationsKey cacheKey = this.generateSelectInterpretationsKey(resultSetMapping);
        if (cacheKey != null) {
            queryPlan = this.getSession().getFactory().getQueryEngine().getQueryPlanCache().getSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            queryPlan = this.getNativeQueryInterpreter().createQueryPlan(this.generateSelectQueryDefinition(), this.getSessionFactory());
            if (cacheKey != null) {
                this.getSession().getFactory().getQueryEngine().getQueryPlanCache().cacheSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    private NativeQueryInterpreter getNativeQueryInterpreter() {
        return this.getSessionFactory().getServiceRegistry().getService(NativeQueryInterpreter.class);
    }

    private NativeSelectQueryDefinition generateSelectQueryDefinition() {
        return new NativeSelectQueryDefinition(){

            @Override
            public String getSqlString() {
                return NativeQueryImpl.this.getQueryString();
            }

            @Override
            public boolean isCallable() {
                return false;
            }

            @Override
            public List<QueryParameterImplementor> getQueryParameterList() {
                return NativeQueryImpl.this.queryParameterList;
            }

            @Override
            public ResultSetMappingDescriptor getResultSetMapping() {
                return NativeQueryImpl.this.resolveResultMapping();
            }

            public RowTransformer getRowTransformer() {
                return NativeQueryImpl.this.resolveRowTransformer();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return NativeQueryImpl.this.affectedTableNames;
            }
        };
    }

    private ResultSetMappingDescriptor resolveResultMapping() {
        throw new NotYetImplementedFor6Exception();
    }

    private RowTransformer resolveRowTransformer() {
        throw new NotYetImplementedFor6Exception();
    }

    private SelectInterpretationsKey generateSelectInterpretationsKey(ResultSetMappingDescriptor resultSetMapping) {
        if (!NativeQueryImpl.isCacheable(this)) {
            return null;
        }
        return new SelectInterpretationsKey(this.getQueryString(), resultSetMapping, this.getQueryOptions().getTupleTransformer(), this.getQueryOptions().getResultListTransformer());
    }

    private static boolean isCacheable(NativeQueryImpl query) {
        return !NativeQueryImpl.hasLimit(query.getQueryOptions().getLimit());
    }

    private static boolean hasLimit(Limit limit) {
        return limit.getFirstRow() != null || limit.getMaxRows() != null;
    }

    @Override
    protected ScrollableResultsImplementor doScroll(ScrollMode scrollMode) {
        this.getSession().prepareForQueryExecution(false);
        this.prepareForExecution();
        return this.resolveSelectQueryPlan().performScroll(scrollMode, this);
    }

    @Override
    protected int doExecuteUpdate() {
        this.getSession().prepareForQueryExecution(true);
        return this.resolveNonSelectQueryPlan().executeUpdate(this);
    }

    private NonSelectQueryPlan resolveNonSelectQueryPlan() {
        NonSelectQueryPlan queryPlan = null;
        NonSelectInterpretationsKey cacheKey = this.generateNonSelectInterpretationsKey();
        if (cacheKey != null) {
            queryPlan = this.getSession().getFactory().getQueryEngine().getQueryPlanCache().getNonSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            queryPlan = new NativeNonSelectQueryPlanImpl(this);
            if (cacheKey != null) {
                this.getSession().getFactory().getQueryEngine().getQueryPlanCache().cacheNonSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    protected NonSelectInterpretationsKey generateNonSelectInterpretationsKey() {
        return new NonSelectInterpretationsKey(this.getQueryString(), this.getSynchronizedQuerySpaces());
    }

    @Override
    public NativeQueryImplementor setCollectionKey(Serializable key) {
        this.collectionKey = key;
        return this;
    }

    public Set<String> getSynchronizedQuerySpaces() {
        return this.affectedTableNames;
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedQuerySpace(String querySpace) {
        this.addQuerySpaces(querySpace);
        return this;
    }

    protected void addQuerySpaces(Collection<String> spaces) {
        if (spaces != null) {
            if (this.affectedTableNames == null) {
                this.affectedTableNames = new HashSet<String>();
            }
            this.affectedTableNames.addAll(spaces);
        }
    }

    protected void addQuerySpaces(String ... spaces) {
        if (spaces != null) {
            if (this.affectedTableNames == null) {
                this.affectedTableNames = new HashSet<String>();
            }
            this.affectedTableNames.addAll(Arrays.asList(spaces));
        }
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedEntityName(String entityName) throws MappingException {
        this.addQuerySpaces(this.getSession().getFactory().getMetamodel().findEntityDescriptor(entityName).getAffectedTableNames());
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedEntityClass(Class entityClass) throws MappingException {
        this.addQuerySpaces(this.getSession().getFactory().getMetamodel().getEntityDescriptor(entityClass).getAffectedTableNames());
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFlushMode(FlushModeType flushModeType) {
        super.setFlushMode(flushModeType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setLockOptions(LockOptions lockOptions) {
        super.setLockOptions(lockOptions);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setLockMode(LockModeType lockModeType) {
        throw new IllegalStateException("Illegal attempt to set lock mode on a native SQL query");
    }

    @Override
    public NativeQueryImplementor<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addQueryHint(String hint) {
        super.addQueryHint(hint);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setTupleTransformer(TupleTransformer transformer) {
        super.setTupleTransformer(transformer);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setResultListTransformer(ResultListTransformer transformer) {
        super.setResultListTransformer(transformer);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setResultTransformer(ResultTransformer transformer) {
        super.setResultTransformer(transformer);
        return this;
    }

    @Override
    protected void applyEntityGraphQueryHint(String hintName, RootGraphImplementor entityGraph) {
        throw new HibernateException("A native SQL query cannot use EntityGraphs");
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        super.collectHints(hints);
    }

    @Override
    protected boolean applyNativeQueryLockMode(Object value) {
        return false;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(QueryParameter parameter, Object value) {
        super.setParameter((Parameter)parameter, value);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(QueryParameter parameter, Object value, AllowableParameterType type) {
        super.setParameter(parameter, value, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Object value, AllowableParameterType type) {
        super.setParameter(name, value, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Object value, AllowableParameterType type) {
        super.setParameter(position, value, type);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, TemporalType temporalType) {
        super.setParameter((QueryParameter)parameter, (Object)value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Object value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Object value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(QueryParameter parameter, Collection values) {
        super.setParameterList(parameter, values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Collection values, AllowableParameterType type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Object[] values, AllowableParameterType type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter param, Calendar value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter param, Date value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P val, Type type) {
        super.setParameter(parameter, val, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Object val, Type type) {
        super.setParameter(name, val, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Object val, Type type) {
        super.setParameter(position, val, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Collection values, Type type) {
        super.setParameter(name, (Object)values, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Object[] values, Type type) {
        super.setParameter(name, (Object)values, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Collection values, Class type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Collection values, Class type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Collection values, Type type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Object[] values, Type type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<Instant> param, Instant value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<LocalDateTime> param, LocalDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<ZonedDateTime> param, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<OffsetDateTime> param, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, LocalDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, LocalDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Collection values, AllowableParameterType type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Object[] values, AllowableParameterType type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    protected boolean canApplyAliasSpecificLockModes() {
        return false;
    }

    @Override
    protected void verifySettingLockMode() {
        throw new IllegalStateException("Illegal attempt to set lock mode on a native query");
    }

    @Override
    protected void verifySettingAliasSpecificLockModes() {
        throw new IllegalStateException("Illegal attempt to set lock mode on a native query");
    }

    @Override
    public NativeQueryImplementor<R> setMaxResults(int maxResult) {
        super.setMaxResults(maxResult);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFirstResult(int startPosition) {
        super.setFirstResult(startPosition);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public <T> List<T> getLoadIdentifiers() {
        return null;
    }

    @Override
    public NamedNativeQueryMemento toMemento(String name, SessionFactoryImplementor factory) {
        return new NamedNativeQueryMementoImpl(name, NativeQueryImpl.toParameterMementos(this.getParameterMetadata()), this.sqlString, null, (Set<String>)this.getSynchronizedQuerySpaces(), this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getHibernateFlushMode(), this.isReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    private static List<ParameterMemento> toParameterMementos(ParameterMetadataImplementor<QueryParameterImplementor<?>> parameterMetadata) {
        if (parameterMetadata.getParameterCount() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<ParameterMemento> copy = new ArrayList<ParameterMemento>();
        parameterMetadata.visitRegistrations(queryParameter -> copy.add(queryParameter.toMemento()));
        return copy;
    }
}

