/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.ScrollMode;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.sql.spi.NativeSelectQueryPlan;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.internal.JdbcSelectImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.RowTransformer;
import org.hibernate.sql.results.spi.ResultSetMappingDescriptor;

public class NativeSelectQueryPlanImpl<R>
implements NativeSelectQueryPlan<R> {
    private final String sql;
    private final Set<String> affectedTableNames;
    private final List<QueryParameterImplementor> parameterList;
    private final ResultSetMappingDescriptor resultSetMapping;
    private final RowTransformer<R> rowTransformer;

    public NativeSelectQueryPlanImpl(String sql, Set<String> affectedTableNames, List<QueryParameterImplementor> parameterList, ResultSetMappingDescriptor resultSetMapping, RowTransformer<R> rowTransformer) {
        this.sql = sql;
        this.affectedTableNames = affectedTableNames;
        this.parameterList = parameterList;
        this.resultSetMapping = resultSetMapping;
        this.rowTransformer = rowTransformer;
    }

    @Override
    public List<R> performList(ExecutionContext executionContext) {
        List<JdbcParameterBinder> jdbcParameterBinders = this.resolveJdbcParameterBinders(executionContext);
        JdbcSelectImpl jdbcSelect = new JdbcSelectImpl(this.sql, jdbcParameterBinders, this.resultSetMapping, this.affectedTableNames);
        JdbcSelectExecutorStandardImpl executor = JdbcSelectExecutorStandardImpl.INSTANCE;
        return executor.list(jdbcSelect, JdbcParameterBindings.NO_BINDINGS, executionContext, this.rowTransformer);
    }

    private List<JdbcParameterBinder> resolveJdbcParameterBinders(ExecutionContext executionContext) {
        ArrayList<JdbcParameterBinder> jdbcParameterBinders = CollectionHelper.arrayList(this.parameterList.size());
        for (QueryParameterImplementor parameter : this.parameterList) {
            Object parameterBinding = executionContext.getDomainParameterBindingContext().getQueryParameterBindings().getBinding(parameter);
            AllowableParameterType type = parameterBinding.getBindType();
            if (type == null) {
                type = parameter.getHibernateType();
            }
            type.dehydrate(type.unresolve(parameterBinding.getBindValue(), executionContext.getSession()), (jdbcValue, sqlExpressableType, boundColumn) -> jdbcParameterBinders.add((statement, startPosition, jdbcParameterBindings, executionContext1) -> {
                sqlExpressableType.getJdbcValueBinder().bind(statement, startPosition, jdbcValue, executionContext1);
                return 1;
            }), Clause.IRRELEVANT, executionContext.getSession());
        }
        return jdbcParameterBinders;
    }

    @Override
    public ScrollableResultsImplementor<R> performScroll(ScrollMode scrollMode, ExecutionContext executionContext) {
        List<JdbcParameterBinder> jdbcParameterBinders = this.resolveJdbcParameterBinders(executionContext);
        JdbcSelectImpl jdbcSelect = new JdbcSelectImpl(this.sql, jdbcParameterBinders, this.resultSetMapping, this.affectedTableNames);
        JdbcSelectExecutorStandardImpl executor = JdbcSelectExecutorStandardImpl.INSTANCE;
        return executor.scroll(jdbcSelect, scrollMode, JdbcParameterBindings.NO_BINDINGS, executionContext, this.rowTransformer);
    }
}

