/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.BitSet;
import org.hibernate.QueryException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.spi.ParameterRecognizer;
import org.jboss.logging.Logger;

public class ParameterParser {
    private static final Logger log = Logger.getLogger(ParameterParser.class);
    public static final String HQL_SEPARATORS = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\";
    public static final BitSet HQL_SEPARATORS_BITSET = new BitSet();

    public static void parse(String sqlString, ParameterRecognizer recognizer) throws QueryException {
        boolean hasMainOutputParameter = ParameterParser.determineQueryType(sqlString) == Type.CALL_FUNCTION;
        boolean foundMainOutputParam = false;
        int stringLength = sqlString.length();
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean inLineComment = false;
        boolean inDelimitedComment = false;
        for (int indx = 0; indx < stringLength; ++indx) {
            String param;
            int chopLocation;
            int right;
            boolean lastCharacter;
            char c = sqlString.charAt(indx);
            boolean bl = lastCharacter = indx == stringLength - 1;
            if (inSingleQuotes) {
                recognizer.other(c);
                if ('\'' != c) continue;
                inSingleQuotes = false;
                continue;
            }
            if (inDoubleQuotes) {
                recognizer.other(c);
                if ('\"' != c) continue;
                inDoubleQuotes = false;
                continue;
            }
            if (inDelimitedComment) {
                recognizer.other(c);
                if (lastCharacter || '*' != c || '/' != sqlString.charAt(indx + 1)) continue;
                inDelimitedComment = false;
                recognizer.other(sqlString.charAt(indx + 1));
                ++indx;
                continue;
            }
            if (inLineComment) {
                recognizer.other(c);
                if ('\n' == c) {
                    inLineComment = false;
                    continue;
                }
                if ('\r' != c) continue;
                inLineComment = false;
                if (lastCharacter || '\n' != sqlString.charAt(indx + 1)) continue;
                recognizer.other(sqlString.charAt(indx + 1));
                ++indx;
                continue;
            }
            if (!lastCharacter && '/' == c && '*' == sqlString.charAt(indx + 1)) {
                inDelimitedComment = true;
                recognizer.other(c);
                recognizer.other(sqlString.charAt(indx + 1));
                ++indx;
                continue;
            }
            if ('-' == c) {
                recognizer.other(c);
                if (lastCharacter || '-' != sqlString.charAt(indx + 1)) continue;
                inLineComment = true;
                recognizer.other(sqlString.charAt(indx + 1));
                ++indx;
                continue;
            }
            if ('\"' == c) {
                inDoubleQuotes = true;
                recognizer.other(c);
                continue;
            }
            if ('\'' == c) {
                inSingleQuotes = true;
                recognizer.other(c);
                continue;
            }
            if ('\\' == c) {
                recognizer.other(sqlString.charAt(++indx));
                continue;
            }
            if (c == ':' && indx < stringLength - 1 && sqlString.charAt(indx + 1) == ':') {
                recognizer.other(c);
                ++indx;
                continue;
            }
            if (c == ':') {
                right = StringHelper.firstIndexOfChar(sqlString, HQL_SEPARATORS_BITSET, indx + 1);
                chopLocation = right < 0 ? sqlString.length() : right;
                param = sqlString.substring(indx + 1, chopLocation);
                if (StringHelper.isEmpty(param)) {
                    throw new QueryException("Space is not allowed after parameter prefix ':' [" + sqlString + "]");
                }
                recognizer.namedParameter(param, indx);
                indx = chopLocation - 1;
                continue;
            }
            if (c == '?') {
                if (indx < stringLength - 1 && Character.isDigit(sqlString.charAt(indx + 1))) {
                    right = StringHelper.firstIndexOfChar(sqlString, HQL_SEPARATORS, indx + 1);
                    chopLocation = right < 0 ? sqlString.length() : right;
                    param = sqlString.substring(indx + 1, chopLocation);
                    try {
                        recognizer.jpaPositionalParameter(Integer.valueOf(param), indx);
                        indx = chopLocation - 1;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new QueryException("JPA-style positional param was not an integer value : " + param);
                    }
                }
                if (hasMainOutputParameter && !foundMainOutputParam) {
                    foundMainOutputParam = true;
                    recognizer.outParameter(indx);
                    continue;
                }
                recognizer.ordinalParameter(indx);
                continue;
            }
            recognizer.other(c);
        }
    }

    public static Type determineQueryType(String sql) {
        if (!(sql = sql.trim()).startsWith("{") || !sql.endsWith("}")) {
            return Type.NORMAL;
        }
        String trimmed = StringHelper.stripBookends(sql, 1).trim();
        int callStartPosition = trimmed.indexOf("call");
        if (callStartPosition <= 0) {
            log.debugf("SQL query is wrapped in braces, but contained no `call` keyword; returning Type.NORMAL but that seems unintended : %s", (Object)sql);
            return Type.NORMAL;
        }
        if (callStartPosition == 1) {
            return Type.CALL_PROCEDURE;
        }
        int firstParamPosition = trimmed.indexOf("?");
        if (firstParamPosition < callStartPosition) {
            return Type.CALL_FUNCTION;
        }
        return Type.CALL_PROCEDURE;
    }

    @Deprecated
    public static boolean startsWithEscapeCallTemplate(String sqlString) {
        return ParameterParser.determineQueryType(sqlString) == Type.CALL_FUNCTION;
    }

    private ParameterParser() {
    }

    static {
        for (int i = 0; i < HQL_SEPARATORS.length(); ++i) {
            HQL_SEPARATORS_BITSET.set(HQL_SEPARATORS.charAt(i));
        }
    }

    static enum Type {
        NORMAL,
        CALL_PROCEDURE,
        CALL_FUNCTION;

    }
}

