/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.StoredProcedureQuery;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.query.internal.QueryParameterNamedImpl;
import org.hibernate.query.internal.QueryParameterPositionalImpl;
import org.hibernate.query.spi.ParameterRecognizer;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;

public class ParameterRecognizerImpl
implements ParameterRecognizer {
    private final int ordinalParameterBase;
    private boolean hadMainOutputParameter;
    private Map<String, QueryParameterImplementor<?>> namedQueryParameters;
    private Map<Integer, QueryParameterImplementor<?>> positionalQueryParameters;
    private PositionalParameterStyle positionalParameterStyle;
    private int ordinalParameterImplicitPosition;
    private List<JdbcParameterBinder> parameterBinders;
    private List<QueryParameterImplementor> parameterList;

    public ParameterRecognizerImpl(SessionFactoryImplementor factory) {
        if (factory.getSessionFactoryOptions().isJpaBootstrap()) {
            this.ordinalParameterBase = 1;
        } else {
            Integer configuredBase = factory.getSessionFactoryOptions().getNonJpaNativeQueryOrdinalParameterBase();
            int n = this.ordinalParameterBase = configuredBase == null ? 1 : configuredBase;
        }
        assert (this.ordinalParameterBase == 0 || this.ordinalParameterBase == 1);
        this.ordinalParameterImplicitPosition = this.ordinalParameterBase;
    }

    public void validate() {
        if (this.hadMainOutputParameter) {
            throw new QueryException("Calling database procedures/functions is no longer supported through the NativeQuery API; use Hibernate's " + ProcedureCall.class.getName() + " API or JPA's " + StoredProcedureQuery.class.getName() + " API");
        }
        if (this.positionalQueryParameters != null) {
            int[] positionsArray = this.positionalQueryParameters.keySet().stream().mapToInt(Integer::intValue).toArray();
            Arrays.sort(positionsArray);
            int previous = 0;
            boolean first = true;
            int[] nArray = positionsArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer position = nArray[i];
                if (position != previous + 1) {
                    if (first) {
                        throw new QueryException("Positional parameters did not start with base [" + this.ordinalParameterBase + "] : " + position);
                    }
                    throw new QueryException("Gap in positional parameter positions; skipped " + (previous + 1));
                }
                first = false;
                previous = position;
            }
        }
    }

    public Map<String, QueryParameterImplementor<?>> getNamedQueryParameters() {
        return this.namedQueryParameters;
    }

    public Map<Integer, QueryParameterImplementor<?>> getPositionalQueryParameters() {
        return this.positionalQueryParameters;
    }

    public List<QueryParameterImplementor> getParameterList() {
        return this.parameterList;
    }

    @Override
    public void outParameter(int position) {
        if (this.hadMainOutputParameter) {
            throw new IllegalStateException("Recognized multiple `mainOutputParameter`s");
        }
        this.hadMainOutputParameter = true;
    }

    @Override
    public void ordinalParameter(int sourcePosition) {
        if (this.positionalParameterStyle == PositionalParameterStyle.JPA) {
            throw new IllegalStateException("Cannot mix JDBC-style (?) and JPA-style (?1) parameters in the same query");
        }
        this.positionalParameterStyle = PositionalParameterStyle.JDBC;
        int implicitPosition = this.ordinalParameterImplicitPosition++;
        QueryParameterImplementor<?> parameter = null;
        if (this.positionalQueryParameters == null) {
            this.positionalQueryParameters = new HashMap();
        } else {
            parameter = this.positionalQueryParameters.get(implicitPosition);
        }
        if (parameter == null) {
            parameter = QueryParameterPositionalImpl.fromNativeQuery(implicitPosition);
            this.positionalQueryParameters.put(implicitPosition, parameter);
        }
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<QueryParameterImplementor>();
        }
        this.parameterList.add(parameter);
    }

    @Override
    public void namedParameter(String name, int sourcePosition) {
        QueryParameterImplementor<?> parameter = null;
        if (this.namedQueryParameters == null) {
            this.namedQueryParameters = new HashMap();
        } else {
            parameter = this.namedQueryParameters.get(name);
        }
        if (parameter == null) {
            parameter = QueryParameterNamedImpl.fromNativeQuery(name);
            this.namedQueryParameters.put(name, parameter);
        }
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<QueryParameterImplementor>();
        }
        this.parameterList.add(parameter);
    }

    @Override
    public void jpaPositionalParameter(int position, int sourcePosition) {
        if (this.positionalParameterStyle == PositionalParameterStyle.JDBC) {
            throw new IllegalStateException("Cannot mix JDBC-style (?) and JPA-style (?1) parameters in the same query");
        }
        if (position < 1) {
            throw new QueryException("Incoming parameter position [" + position + "] is less than base [1]");
        }
        this.positionalParameterStyle = PositionalParameterStyle.JPA;
        QueryParameterImplementor<?> parameter = null;
        if (this.positionalQueryParameters == null) {
            this.positionalQueryParameters = new HashMap();
        } else {
            parameter = this.positionalQueryParameters.get(position);
        }
        if (parameter == null) {
            parameter = QueryParameterPositionalImpl.fromNativeQuery(position);
            this.positionalQueryParameters.put(position, parameter);
        }
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<QueryParameterImplementor>();
        }
        this.parameterList.add(parameter);
    }

    @Override
    public void other(char character) {
    }

    private static enum PositionalParameterStyle {
        JDBC,
        JPA;

    }
}

