/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.ArrayList;
import java.util.HashSet;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.sql.internal.ResolvedScalarDomainResult;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.results.internal.StandardResultSetMapping;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.ResultSetMapping;
import org.hibernate.sql.results.spi.ResultSetMappingDescriptor;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class ResultSetMappingDescriptorUndefined
implements ResultSetMappingDescriptor {
    private static final Logger log = Logger.getLogger(ResultSetMappingDescriptorUndefined.class);

    public static ResultSetMapping resolveStatic(ResultSetMappingDescriptor.JdbcValuesMetadata jdbcResultsMetadata, SessionFactoryImplementor sessionFactory) {
        int columnCount = jdbcResultsMetadata.getColumnCount();
        HashSet<SqlSelection> sqlSelections = new HashSet<SqlSelection>(columnCount);
        ArrayList<DomainResult> domainResults = CollectionHelper.arrayList(columnCount);
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        for (int columnPosition = 0; columnPosition < columnCount; ++columnPosition) {
            String columnName = jdbcResultsMetadata.resolveColumnName(columnPosition);
            log.tracef("Discovering JDBC result column metadata [%s (%s)]", (Object)columnName, (Object)columnPosition);
            SqlTypeDescriptor sqlTypeDescriptor = jdbcResultsMetadata.resolveSqlTypeDescriptor(columnPosition);
            BasicJavaDescriptor javaTypeDescriptor = sqlTypeDescriptor.getJdbcRecommendedJavaTypeMapping(typeConfiguration);
            log.debugf("Discovered JDBC result column metadata [%s (%s)] : %s, %s ", new Object[]{columnName, columnPosition, sqlTypeDescriptor, javaTypeDescriptor});
            SqlSelectionImpl sqlSelection = new SqlSelectionImpl(columnPosition, columnName, javaTypeDescriptor, sqlTypeDescriptor, typeConfiguration);
            sqlSelections.add(sqlSelection);
            domainResults.add(new ResolvedScalarDomainResult(sqlSelection, columnName, javaTypeDescriptor));
        }
        return new StandardResultSetMapping(sqlSelections, domainResults);
    }

    @Override
    public ResultSetMapping resolve(ResultSetMappingDescriptor.JdbcValuesMetadata jdbcResultsMetadata, SessionFactoryImplementor sessionFactory) {
        return ResultSetMappingDescriptorUndefined.resolveStatic(jdbcResultsMetadata, sessionFactory);
    }

    private static class SqlSelectionImpl
    implements SqlSelection {
        private final int valuesArrayPosition;
        private JdbcValueExtractor jdbcValueExtractor;

        public SqlSelectionImpl(int columnPosition, String columnName, BasicJavaDescriptor javaTypeDescriptor, SqlTypeDescriptor sqlTypeDescriptor, TypeConfiguration typeConfiguration) {
            log.tracef("Creating SqlSelection for auto-discovered column : %s (%s)", (Object)columnName, (Object)columnPosition);
            this.valuesArrayPosition = columnPosition - 1;
            this.jdbcValueExtractor = sqlTypeDescriptor.getSqlExpressableType(javaTypeDescriptor, typeConfiguration).getJdbcValueExtractor();
        }

        @Override
        public JdbcValueExtractor getJdbcValueExtractor() {
            return this.jdbcValueExtractor;
        }

        @Override
        public int getValuesArrayPosition() {
            return this.valuesArrayPosition;
        }

        @Override
        public void accept(SqlAstWalker interpreter) {
            throw new UnsupportedOperationException();
        }
    }
}

