/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.spi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sql.spi.AttributeMapping;
import org.hibernate.query.sql.spi.WrappableQueryResultBuilder;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.internal.domain.entity.AbstractEntityMappingNode;
import org.hibernate.sql.results.internal.domain.entity.EntityAssembler;
import org.hibernate.sql.results.internal.domain.entity.EntityRootInitializer;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.EntityResult;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class QueryResultBuilderRootEntity
implements NativeQuery.RootReturn,
WrappableQueryResultBuilder,
ColumnReferenceQualifier {
    private final String tableAlias;
    private final EntityTypeDescriptor entityDescriptor;
    private LockMode lockMode = LockMode.READ;
    private List<String> idColumnAliases;
    private String discriminatorColumnAlias;
    private Map<String, AttributeMapping> propertyMappings;

    public QueryResultBuilderRootEntity(String tableAlias, EntityTypeDescriptor entityDescriptor) {
        this.tableAlias = tableAlias;
        this.entityDescriptor = entityDescriptor;
    }

    @Override
    public JavaTypeDescriptor getResultType() {
        return this.entityDescriptor.getJavaTypeDescriptor();
    }

    @Override
    public NativeQuery.RootReturn setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    @Override
    public NativeQuery.RootReturn addIdColumnAliases(String ... aliases) {
        if (aliases != null) {
            if (aliases.length == 1) {
                this.idColumnAliases.add(aliases[0]);
            } else {
                this.idColumnAliases.addAll(Arrays.asList(aliases));
            }
        }
        return this;
    }

    @Override
    public NativeQuery.RootReturn setDiscriminatorAlias(String alias) {
        this.discriminatorColumnAlias = alias;
        return this;
    }

    @Override
    public NativeQuery.RootReturn addProperty(String propertyName, String columnAlias) {
        this.addProperty(propertyName).addColumnAlias(columnAlias);
        return this;
    }

    @Override
    public NativeQuery.ReturnProperty addProperty(final String propertyName) {
        if (this.propertyMappings == null) {
            this.propertyMappings = new HashMap<String, AttributeMapping>();
        }
        return new NativeQuery.ReturnProperty(){

            @Override
            public NativeQuery.ReturnProperty addColumnAlias(String columnAlias) {
                AttributeMapping registration = QueryResultBuilderRootEntity.this.propertyMappings.computeIfAbsent(propertyName, AttributeMapping::new);
                registration.addColumnAlias(columnAlias);
                return this;
            }
        };
    }

    @Override
    public EntityResult buildReturn(DomainResultCreationState creationState) {
        return new EntityResultImpl(this.entityDescriptor, this.tableAlias, this.lockMode, creationState);
    }

    @Override
    public TableReference locateTableReference(Table table) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public ColumnReference resolveColumnReference(Column column) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public ColumnReference resolveColumnReference(String columnName) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public Column resolveColumn(String columnName) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public Expression qualify(QualifiableSqlExpressable sqlSelectable) {
        throw new NotYetImplementedFor6Exception();
    }

    public static class EntityResultImpl
    extends AbstractEntityMappingNode
    implements EntityResult {
        private final EntityTypeDescriptor entityDescriptor;
        private final String queryResultVariable;

        public EntityResultImpl(EntityTypeDescriptor entityDescriptor, String queryResultVariable, LockMode lockMode, DomainResultCreationState creationState) {
            super(entityDescriptor, lockMode, new NavigablePath(entityDescriptor.getEntityName()), creationState);
            this.entityDescriptor = entityDescriptor;
            this.queryResultVariable = queryResultVariable;
            this.afterInitialize(creationState);
        }

        @Override
        public EntityValuedNavigable getEntityValuedNavigable() {
            return this.entityDescriptor;
        }

        @Override
        public String getResultVariable() {
            return this.queryResultVariable;
        }

        @Override
        public DomainResultAssembler createResultAssembler(Consumer<Initializer> initializerCollector, AssemblerCreationState creationState) {
            DiscriminatorDescriptor discriminatorDescriptor = this.entityDescriptor.getHierarchy().getDiscriminatorDescriptor();
            DomainResult discriminatorResult = null;
            EntityRootInitializer initializer = new EntityRootInitializer(this, this.getNavigablePath(), LockMode.READ, null, discriminatorResult, null, initializerCollector, creationState);
            return new EntityAssembler(this.getJavaTypeDescriptor(), initializer);
        }
    }
}

