/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.spi;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.spi.ResultSetMappingDescriptor;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class ResolvingSqlSelectionImpl
implements SqlSelection,
JdbcValueExtractor {
    private final String columnAlias;
    private SqlExpressableType sqlExpressableType;
    private Integer jdbcResultSetPosition;

    public ResolvingSqlSelectionImpl(String columnAlias, int jdbcResultSetPosition) {
        this.columnAlias = columnAlias;
        this.jdbcResultSetPosition = jdbcResultSetPosition;
    }

    public ResolvingSqlSelectionImpl(String columnAlias) {
        this(columnAlias, null);
    }

    public ResolvingSqlSelectionImpl(String columnAlias, SqlExpressableType sqlExpressableType) {
        this.columnAlias = columnAlias;
        this.sqlExpressableType = sqlExpressableType;
    }

    public ResolvingSqlSelectionImpl(int jdbcResultSetPosition, SqlExpressableType sqlExpressableType) {
        this.columnAlias = null;
        this.jdbcResultSetPosition = jdbcResultSetPosition;
        this.sqlExpressableType = sqlExpressableType;
    }

    @Override
    public void prepare(ResultSetMappingDescriptor.JdbcValuesMetadata jdbcResultsMetadata, SessionFactoryImplementor sessionFactory) {
        if (this.jdbcResultSetPosition == null) {
            this.jdbcResultSetPosition = jdbcResultsMetadata.resolveColumnPosition(this.columnAlias);
        }
        if (this.sqlExpressableType == null) {
            SqlTypeDescriptor sqlTypeDescriptor = jdbcResultsMetadata.resolveSqlTypeDescriptor(this.jdbcResultSetPosition);
            TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
            this.sqlExpressableType = sqlTypeDescriptor.getSqlExpressableType(sqlTypeDescriptor.getJdbcRecommendedJavaTypeMapping(typeConfiguration), typeConfiguration);
        }
    }

    @Override
    public JdbcValueExtractor getJdbcValueExtractor() {
        return this;
    }

    public Object extract(ResultSet resultSet, int position, ExecutionContext executionContext) throws SQLException {
        this.validateExtractor();
        return this.sqlExpressableType.getJdbcValueExtractor().extract(resultSet, position, executionContext);
    }

    private void validateExtractor() {
        if (this.sqlExpressableType == null) {
            throw new QueryException("Could not determine how to read JDBC value");
        }
    }

    public Object extract(CallableStatement statement, int jdbcParameterPosition, ExecutionContext executionContext) throws SQLException {
        this.validateExtractor();
        return this.sqlExpressableType.getJdbcValueExtractor().extract(statement, jdbcParameterPosition, executionContext);
    }

    public Object extract(CallableStatement statement, String jdbcParameterName, ExecutionContext executionContext) throws SQLException {
        this.validateExtractor();
        return this.sqlExpressableType.getJdbcValueExtractor().extract(statement, jdbcParameterName, executionContext);
    }

    @Override
    public int getJdbcResultSetIndex() {
        return this.jdbcResultSetPosition;
    }

    @Override
    public int getValuesArrayPosition() {
        return this.jdbcResultSetPosition - 1;
    }

    @Override
    public void accept(SqlAstWalker interpreter) {
        interpreter.visitSqlSelection(this);
    }
}

