/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.consume.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.ast.produce.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.sql.exec.spi.JdbcParameter;

public class SqmConsumeHelper {
    private SqmConsumeHelper() {
    }

    public static Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> generateJdbcParamsXref(DomainParameterXref domainParameterXref, JdbcParameterBySqmParameterAccess jdbcParameterBySqmParameterAccess) {
        if (domainParameterXref == null || !domainParameterXref.hasParameters()) {
            return Collections.emptyMap();
        }
        IdentityHashMap result = new IdentityHashMap();
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter>> entry : domainParameterXref.getSqmParamByQueryParam().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter> sqmParams = entry.getValue();
            Map sqmParamMap = result.computeIfAbsent(queryParam, qp -> new IdentityHashMap());
            for (SqmParameter sqmParam : sqmParams) {
                sqmParamMap.put(sqmParam, jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(sqmParam));
                result.put(queryParam, sqmParamMap);
                List<SqmParameter> expansions = domainParameterXref.getExpansions(sqmParam);
                if (expansions.isEmpty()) continue;
                for (SqmParameter expansion : expansions) {
                    sqmParamMap.put(expansion, jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(expansion));
                    result.put(queryParam, sqmParamMap);
                }
            }
        }
        return result;
    }
}

