/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.consume.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.annotations.Remove;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.criteria.sqm.JpaParameterSqmWrapper;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.consume.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmConcat;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmSubQuery;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.expression.function.SqmAbsFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmAvgFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmBitLengthFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCastFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCoalesceFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmConcatFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCountFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCountStarFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCurrentDateFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCurrentTimeFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCurrentTimestampFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmExtractFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmGenericFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmLengthFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmLocateFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmLowerFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmMaxFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmMinFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmModFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmNullifFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmStrFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmSubstringFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmSumFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmTrimFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmUpperFunction;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmNavigableJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.predicate.AndSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.BetweenSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.GroupedSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.InListSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.InSubQuerySqmPredicate;
import org.hibernate.query.sqm.tree.predicate.LikeSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.NegatedSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.NullnessSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.OrSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.internal.SqlAstQuerySpecProcessingStateImpl;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.sql.ast.produce.metamodel.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.produce.ordering.internal.SqmColumnReference;
import org.hibernate.sql.ast.produce.spi.FromClauseAccess;
import org.hibernate.sql.ast.produce.spi.FromClauseIndex;
import org.hibernate.sql.ast.produce.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.produce.spi.SqlAstFunctionProducer;
import org.hibernate.sql.ast.produce.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.produce.spi.SqlAstQuerySpecProcessingState;
import org.hibernate.sql.ast.produce.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.produce.spi.TableGroupJoinProducer;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.ast.produce.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.sql.ast.produce.sqm.spi.SqmExpressionInterpretation;
import org.hibernate.sql.ast.produce.sqm.spi.SqmToSqlAstConverter;
import org.hibernate.sql.ast.tree.expression.AbsFunction;
import org.hibernate.sql.ast.tree.expression.AvgFunction;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.BitLengthFunction;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastFunction;
import org.hibernate.sql.ast.tree.expression.CoalesceFunction;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.ConcatFunction;
import org.hibernate.sql.ast.tree.expression.CountFunction;
import org.hibernate.sql.ast.tree.expression.CountStarFunction;
import org.hibernate.sql.ast.tree.expression.CurrentDateFunction;
import org.hibernate.sql.ast.tree.expression.CurrentTimeFunction;
import org.hibernate.sql.ast.tree.expression.CurrentTimestampFunction;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractFunction;
import org.hibernate.sql.ast.tree.expression.LengthFunction;
import org.hibernate.sql.ast.tree.expression.LocateFunction;
import org.hibernate.sql.ast.tree.expression.LowerFunction;
import org.hibernate.sql.ast.tree.expression.MaxFunction;
import org.hibernate.sql.ast.tree.expression.MinFunction;
import org.hibernate.sql.ast.tree.expression.ModFunction;
import org.hibernate.sql.ast.tree.expression.NonStandardFunction;
import org.hibernate.sql.ast.tree.expression.NullifFunction;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SubQuery;
import org.hibernate.sql.ast.tree.expression.SubstrFunction;
import org.hibernate.sql.ast.tree.expression.SumFunction;
import org.hibernate.sql.ast.tree.expression.TrimFunction;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.expression.UpperFunction;
import org.hibernate.sql.ast.tree.expression.domain.BasicValuedNavigableReference;
import org.hibernate.sql.ast.tree.expression.domain.EmbeddableValuedNavigableReference;
import org.hibernate.sql.ast.tree.expression.domain.EntityValuedNavigableReference;
import org.hibernate.sql.ast.tree.expression.domain.NavigableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.sort.SortSpecification;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.internal.StandardJdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameters;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.jboss.logging.Logger;

public abstract class BaseSqmToSqlAstConverter
extends BaseSemanticQueryWalker
implements SqmToSqlAstConverter,
JdbcParameterBySqmParameterAccess {
    private static final Logger log = Logger.getLogger(BaseSqmToSqlAstConverter.class);
    private final SqlAstCreationContext creationContext;
    private final QueryOptions queryOptions;
    private final DomainParameterXref domainParameterXref;
    private final QueryParameterBindings domainParameterBindings;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final Callback callback;
    private final SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
    private final FromClauseIndex fromClauseIndex = new FromClauseIndex();
    private final Stack<SqlAstProcessingState> processingStateStack = new StandardStack<SqlAstProcessingState>();
    private final Stack<Clause> currentClauseStack = new StandardStack<Clause>();
    private final Stack<Shallowness> shallownessStack = new StandardStack<Shallowness>(Shallowness.NONE);
    @Remove
    private final Stack<TableGroup> tableGroupStack = new StandardStack<TableGroup>();
    @Remove
    private final Stack<NavigableReference> navigableReferenceStack = new StandardStack<NavigableReference>();
    private final Map<SqmParameter, List<JdbcParameter>> jdbcParamsBySqmParam = new IdentityHashMap<SqmParameter, List<JdbcParameter>>();
    private final JdbcParameters jdbcParameters = new JdbcParametersImpl();
    private final Stack<Supplier<ExpressableType>> inferableTypeAccessStack = new StandardStack<Supplier<ExpressableType>>(() -> null);

    public BaseSqmToSqlAstConverter(SqlAstCreationContext creationContext, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers loadQueryInfluencers, Callback callback) {
        super(creationContext.getDomainModel().getTypeConfiguration(), creationContext.getServiceRegistry());
        this.creationContext = creationContext;
        this.queryOptions = queryOptions;
        this.domainParameterXref = domainParameterXref;
        this.domainParameterBindings = domainParameterBindings;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.callback = callback;
    }

    protected Stack<SqlAstProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this.processingStateStack.getCurrent();
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.getCurrentProcessingState().getSqlExpressionResolver();
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        return this.fromClauseIndex;
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        return this.queryOptions.getLockOptions().getEffectiveLockMode(identificationVariable);
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        return Collections.emptyList();
    }

    protected QuerySpec currentQuerySpec() {
        return ((SqlAstQuerySpecProcessingState)this.processingStateStack.getCurrent()).getInflightQuerySpec();
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public FromClauseIndex getFromClauseIndex() {
        return this.fromClauseIndex;
    }

    public Stack<Clause> getCurrentClauseStack() {
        return this.currentClauseStack;
    }

    public Stack<TableGroup> getTableGroupStack() {
        return this.tableGroupStack;
    }

    public Stack<NavigableReference> getNavigableReferenceStack() {
        return this.navigableReferenceStack;
    }

    protected <T> void primeStack(Stack<T> stack, T initialValue) {
        BaseSqmToSqlAstConverter.verifyCanBePrimed(stack);
        stack.push(initialValue);
    }

    private static void verifyCanBePrimed(Stack stack) {
        if (!stack.isEmpty()) {
            throw new IllegalStateException("Cannot prime an already populated Stack");
        }
    }

    @Override
    public Object visitUpdateStatement(SqmUpdateStatement statement) {
        throw new AssertionFailure("UpdateStatement not supported");
    }

    @Override
    public Object visitDeleteStatement(SqmDeleteStatement statement) {
        throw new AssertionFailure("DeleteStatement not supported");
    }

    @Override
    public Object visitInsertSelectStatement(SqmInsertSelectStatement statement) {
        throw new AssertionFailure("InsertStatement not supported");
    }

    @Override
    public SelectStatement visitSelectStatement(SqmSelectStatement statement) {
        throw new AssertionFailure("SelectStatement not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuerySpec visitQuerySpec(SqmQuerySpec sqmQuerySpec) {
        QuerySpec sqlQuerySpec = new QuerySpec(this.processingStateStack.isEmpty());
        this.processingStateStack.push(new SqlAstQuerySpecProcessingStateImpl(sqlQuerySpec, this.processingStateStack.getCurrent(), this, this.currentClauseStack::getCurrent, () -> expression -> {}, () -> sqlQuerySpec.getSelectClause()::addSqlSelection));
        try {
            SqmWhereClause whereClause;
            this.visitFromClause(sqmQuerySpec.getFromClause());
            SqmSelectClause selectClause = sqmQuerySpec.getSelectClause();
            if (selectClause != null) {
                this.visitSelectClause(selectClause);
            }
            if ((whereClause = sqmQuerySpec.getWhereClause()) != null && whereClause.getPredicate() != null) {
                this.currentClauseStack.push(Clause.WHERE);
                try {
                    sqlQuerySpec.setWhereClauseRestrictions((Predicate)whereClause.getPredicate().accept(this));
                }
                finally {
                    this.currentClauseStack.pop();
                }
            }
            if (sqmQuerySpec.getOrderByClause() != null) {
                this.currentClauseStack.push(Clause.ORDER);
                try {
                    for (SqmSortSpecification sortSpecification : sqmQuerySpec.getOrderByClause().getSortSpecifications()) {
                        sqlQuerySpec.addSortSpecification(this.visitSortSpecification(sortSpecification));
                    }
                }
                finally {
                    this.currentClauseStack.pop();
                }
            }
            sqlQuerySpec.setLimitClauseExpression(this.visitLimitExpression(sqmQuerySpec.getLimitExpression()));
            sqlQuerySpec.setOffsetClauseExpression(this.visitOffsetExpression(sqmQuerySpec.getOffsetExpression()));
            QuerySpec querySpec = sqlQuerySpec;
            return querySpec;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    @Override
    public Void visitOrderByClause(SqmOrderByClause orderByClause) {
        super.visitOrderByClause(orderByClause);
        return null;
    }

    @Override
    public SortSpecification visitSortSpecification(SqmSortSpecification sortSpecification) {
        return new SortSpecification(this.toSqlExpression(sortSpecification.getSortExpression().accept(this)), sortSpecification.getCollation(), sortSpecification.getSortOrder());
    }

    @Override
    public Expression visitOffsetExpression(SqmExpression expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.OFFSET);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Expression visitLimitExpression(SqmExpression expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.LIMIT);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitFromClause(SqmFromClause sqmFromClause) {
        this.currentClauseStack.push(Clause.FROM);
        try {
            sqmFromClause.visitRoots(sqmRoot -> {
                NavigableReference rootReference = this.visitRootPath((SqmRoot)sqmRoot);
                assert (rootReference instanceof TableGroup);
                this.currentQuerySpec().getFromClause().addRoot((TableGroup)rootReference);
            });
        }
        finally {
            this.currentClauseStack.pop();
        }
        return null;
    }

    @Override
    public NavigableReference visitRootPath(SqmRoot sqmRoot) {
        log.tracef("Starting resolution of SqmRoot [%s] to TableGroup", (Object)sqmRoot);
        if (this.fromClauseIndex.isResolved(sqmRoot)) {
            TableGroup resolvedTableGroup = this.fromClauseIndex.findTableGroup(sqmRoot.getNavigablePath());
            log.tracef("SqmRoot [%s] resolved to existing TableGroup [%s]", (Object)sqmRoot, (Object)resolvedTableGroup);
            return resolvedTableGroup;
        }
        EntityTypeDescriptor entityDescriptor = sqmRoot.getReferencedNavigable().getEntityDescriptor();
        TableGroup group = entityDescriptor.createRootTableGroup(sqmRoot.getNavigablePath(), sqmRoot.getExplicitAlias(), JoinType.INNER, LockMode.NONE, this);
        this.fromClauseIndex.register(sqmRoot, group);
        log.tracef("Resolved SqmRoot [%s] to new TableGroup [%s]", (Object)sqmRoot, (Object)group);
        sqmRoot.visitJoins(sqmJoin -> {
            TableGroupJoin tableGroupJoin = (TableGroupJoin)sqmJoin.accept(this);
            if (tableGroupJoin != null) {
                group.addTableGroupJoin(tableGroupJoin);
            }
        });
        return group;
    }

    @Override
    public TableGroupJoin visitQualifiedAttributeJoinFromElement(SqmNavigableJoin sqmJoin) {
        NavigableContainer joinedNavigable = sqmJoin.as(NavigableContainer.class);
        TableGroupJoin tableJoinJoin = this.fromClauseIndex.findTableGroupJoin(sqmJoin.getNavigablePath());
        if (tableJoinJoin != null) {
            return tableJoinJoin;
        }
        TableGroup lhsTableGroup = this.fromClauseIndex.findTableGroup(sqmJoin.getLhs().getNavigablePath());
        if (joinedNavigable instanceof EmbeddedValuedNavigable) {
            TableGroupJoin lhsTableGroupJoin = this.fromClauseIndex.findTableGroupJoin(sqmJoin.getNavigablePath());
            if (lhsTableGroupJoin != null) {
                this.fromClauseIndex.register(sqmJoin, lhsTableGroupJoin);
                return lhsTableGroupJoin;
            }
            this.fromClauseIndex.registerTableGroup(sqmJoin.getNavigablePath(), lhsTableGroup);
            sqmJoin.visitJoins(sqmJoinJoin -> {
                TableGroupJoin tableGroupJoin = (TableGroupJoin)sqmJoinJoin.accept(this);
                if (tableGroupJoin != null) {
                    lhsTableGroup.addTableGroupJoin(tableGroupJoin);
                }
            });
            return null;
        }
        TableGroupJoinProducer joinProducer = joinedNavigable.as(TableGroupJoinProducer.class);
        TableGroupJoin tableGroupJoin = joinProducer.createTableGroupJoin(sqmJoin.getNavigablePath(), this.fromClauseIndex.getTableGroup(sqmJoin.getLhs().getNavigablePath()), sqmJoin.getExplicitAlias(), sqmJoin.getJoinType().getCorrespondingSqlJoinType(), LockMode.NONE, this);
        this.fromClauseIndex.register(sqmJoin, tableGroupJoin);
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        if (sqmJoin.getJoinPredicate() != null) {
            this.currentQuerySpec().addRestriction((Predicate)sqmJoin.getJoinPredicate().accept(this));
        }
        return tableGroupJoin;
    }

    @Override
    public TableGroup visitCrossJoinedFromElement(SqmCrossJoin sqmJoin) {
        EntityTypeDescriptor entityMetadata = sqmJoin.getReferencedNavigable().getEntityDescriptor();
        TableGroup group = entityMetadata.createRootTableGroup(sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), JoinType.INNER, LockMode.NONE, this);
        this.fromClauseIndex.register(sqmJoin, group);
        sqmJoin.visitJoins(sqmJoinJoin -> {
            TableGroupJoin tableGroupJoin = (TableGroupJoin)sqmJoinJoin.accept(this);
            if (tableGroupJoin != null) {
                group.addTableGroupJoin(tableGroupJoin);
            }
        });
        return new TableGroupJoin(JoinType.CROSS, group, null).getJoinedGroup();
    }

    @Override
    public Object visitQualifiedEntityJoinFromElement(SqmEntityJoin joinedFromElement) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public SelectClause visitSelectClause(SqmSelectClause selectClause) {
        this.currentClauseStack.push(Clause.SELECT);
        this.shallownessStack.push(Shallowness.SUBQUERY);
        try {
            super.visitSelectClause(selectClause);
            this.currentQuerySpec().getSelectClause().makeDistinct(selectClause.isDistinct());
            SelectClause selectClause2 = this.currentQuerySpec().getSelectClause();
            return selectClause2;
        }
        finally {
            this.shallownessStack.pop();
            this.currentClauseStack.pop();
        }
    }

    @Override
    public BasicValuedNavigableReference visitBasicValuedPath(SqmBasicValuedSimplePath path) {
        return new BasicValuedNavigableReference(path.getNavigablePath(), path.getReferencedNavigable(), this);
    }

    @Override
    public EmbeddableValuedNavigableReference visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath path) {
        return new EmbeddableValuedNavigableReference(path.getNavigablePath(), path.getReferencedNavigable(), this.determineLockMode(path.getExplicitAlias()), this);
    }

    @Override
    public Object visitEntityValuedPath(SqmEntityValuedSimplePath path) {
        return new EntityValuedNavigableReference(path.getNavigablePath(), path.getReferencedNavigable(), this.determineLockMode(path.getExplicitAlias()), this);
    }

    @Override
    public Object visitPluralValuedPath(SqmPluralValuedSimplePath path) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public Object visitLiteral(SqmLiteral literal) {
        ExpressableType<?> expressableType = this.determineExpressableType(literal);
        if (expressableType instanceof BasicValuedExpressableType) {
            return new QueryLiteral(literal.getLiteralValue(), ((BasicValuedExpressableType)expressableType).getSqlExpressableType(this.getTypeConfiguration()), this.getCurrentClauseStack().getCurrent());
        }
        return new QueryLiteral(literal.getLiteralValue(), literal.getExpressableType().getSqlExpressableType(this.getTypeConfiguration()), this.getCurrentClauseStack().getCurrent());
    }

    @Override
    public Map<SqmParameter, List<JdbcParameter>> getJdbcParamsBySqmParam() {
        return this.jdbcParamsBySqmParam;
    }

    @Override
    public Expression visitNamedParameterExpression(SqmNamedParameter expression) {
        return this.consumeSqmParameter(expression);
    }

    private Expression consumeSqmParameter(SqmParameter sqmParameter) {
        ExpressableType<?> expressableType = this.determineExpressableType(sqmParameter);
        ArrayList<JdbcParameter> jdbcParametersForSqm = new ArrayList<JdbcParameter>();
        this.resolveSqmParameter(sqmParameter, expressableType, jdbcParametersForSqm::add);
        this.jdbcParameters.addParameters(jdbcParametersForSqm);
        this.jdbcParamsBySqmParam.put(sqmParameter, jdbcParametersForSqm);
        if (jdbcParametersForSqm.size() > 1) {
            return new SqlTuple(jdbcParametersForSqm, expressableType);
        }
        return (Expression)jdbcParametersForSqm.get(0);
    }

    private ExpressableType<?> determineExpressableType(SqmExpression sqmExpression) {
        ExpressableType implicitType;
        if (sqmExpression.getExpressableType() != null) {
            return sqmExpression.getExpressableType();
        }
        ExpressableType inferableType = this.inferableTypeAccessStack.getCurrent().get();
        if (inferableType != null) {
            return inferableType;
        }
        Supplier<? extends ExpressableType> implicitTypeSupplier = sqmExpression.getInferableType();
        if (implicitTypeSupplier != null && (implicitType = implicitTypeSupplier.get()) != null) {
            return implicitType;
        }
        return null;
    }

    private void resolveSqmParameter(SqmParameter expression, ExpressableType<?> expressableType, Consumer<JdbcParameter> jdbcParameterConsumer) {
        if (expressableType == null) {
            StandardJdbcParameterImpl jdbcParameter = new StandardJdbcParameterImpl(this.jdbcParameters.getJdbcParameters().size(), null, this.currentClauseStack.getCurrent(), this.getCreationContext().getDomainModel().getTypeConfiguration());
            jdbcParameterConsumer.accept(jdbcParameter);
        } else {
            expressableType.visitJdbcTypes(type -> {
                StandardJdbcParameterImpl jdbcParameter = new StandardJdbcParameterImpl(this.jdbcParameters.getJdbcParameters().size(), (SqlExpressableType)type, this.currentClauseStack.getCurrent(), this.getCreationContext().getDomainModel().getTypeConfiguration());
                jdbcParameterConsumer.accept(jdbcParameter);
            }, this.currentClauseStack.getCurrent(), this.getCreationContext().getDomainModel().getTypeConfiguration());
        }
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter expression) {
        return this.consumeSqmParameter(expression);
    }

    @Override
    public Object visitJpaParameterWrapper(JpaParameterSqmWrapper expression) {
        return this.consumeSqmParameter(expression);
    }

    @Override
    public Object visitGenericFunction(SqmGenericFunction expression) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            NonStandardFunction nonStandardFunction = new NonStandardFunction(expression.getFunctionName(), ((BasicValuedExpressableType)expression.getExpressableType()).getSqlExpressableType(), this.visitArguments(expression.getArguments()));
            return nonStandardFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    private List<Expression> visitArguments(List<SqmExpression> sqmArguments) {
        if (sqmArguments == null || sqmArguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Expression> sqlAstArguments = new ArrayList<Expression>();
        for (SqmExpression sqmArgument : sqmArguments) {
            sqlAstArguments.add((Expression)sqmArgument.accept(this));
        }
        return sqlAstArguments;
    }

    @Override
    public Object visitSqlAstFunctionProducer(SqlAstFunctionProducer sqlAstFunctionProducer) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            Expression expression = sqlAstFunctionProducer.convertToSqlAst(this);
            return expression;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Object visitAbsFunction(SqmAbsFunction function) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            AbsFunction absFunction = new AbsFunction((Expression)function.getArgument().accept(this));
            return absFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public AvgFunction visitAvgFunction(SqmAvgFunction expression) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            AvgFunction avgFunction = new AvgFunction((Expression)expression.getArgument().accept(this), expression.isDistinct(), expression.getExpressableType().getSqlExpressableType());
            return avgFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Object visitBitLengthFunction(SqmBitLengthFunction function) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            BitLengthFunction bitLengthFunction = new BitLengthFunction((Expression)function.getArgument().accept(this), ((BasicValuedExpressableType)function.getExpressableType()).getSqlExpressableType());
            return bitLengthFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Object visitCastFunction(SqmCastFunction expression) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            CastFunction castFunction = new CastFunction((Expression)expression.getExpressionToCast().accept(this), ((BasicValuedExpressableType)expression.getExpressableType()).getSqlExpressableType(), expression.getExplicitSqlCastTarget());
            return castFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public CountFunction visitCountFunction(SqmCountFunction expression) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            CountFunction countFunction = new CountFunction(this.toSqlExpression(expression.getArgument().accept(this)), expression.isDistinct(), this.getCreationContext().getDomainModel().getTypeConfiguration().getBasicTypeRegistry().getBasicType(Long.class).getSqlExpressableType(this.getCreationContext().getDomainModel().getTypeConfiguration()));
            return countFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public ConcatFunction visitConcatFunction(SqmConcatFunction function) {
        return new ConcatFunction(this.collectionExpressions(function.getExpressions()), this.getCreationContext().getDomainModel().getTypeConfiguration().getBasicTypeRegistry().getBasicType(String.class).getSqlExpressableType(this.getCreationContext().getDomainModel().getTypeConfiguration()));
    }

    private List<Expression> collectionExpressions(List<SqmExpression> sqmExpressions) {
        if (sqmExpressions == null || sqmExpressions.isEmpty()) {
            return Collections.emptyList();
        }
        if (sqmExpressions.size() == 1) {
            return Collections.singletonList((Expression)sqmExpressions.get(0).accept(this));
        }
        ArrayList<Expression> results = new ArrayList<Expression>();
        sqmExpressions.forEach(sqmExpression -> {
            Object expression = sqmExpression.accept(this);
            if (expression instanceof BasicValuedNavigableReference) {
                BasicValuedNavigableReference navigableReference = (BasicValuedNavigableReference)expression;
                results.add(this.getSqlExpressionResolver().resolveSqlExpression(this.fromClauseIndex.getTableGroup(navigableReference.getNavigablePath().getParent()), navigableReference.getNavigable().getBoundColumn()));
            } else {
                results.add((Expression)expression);
            }
        });
        return results;
    }

    @Override
    public CurrentDateFunction visitCurrentDateFunction(SqmCurrentDateFunction function) {
        return new CurrentDateFunction(((BasicValuedExpressableType)function.getExpressableType()).getSqlExpressableType());
    }

    @Override
    public CurrentTimeFunction visitCurrentTimeFunction(SqmCurrentTimeFunction function) {
        return new CurrentTimeFunction(((BasicValuedExpressableType)function.getExpressableType()).getSqlExpressableType());
    }

    @Override
    public CurrentTimestampFunction visitCurrentTimestampFunction(SqmCurrentTimestampFunction function) {
        return new CurrentTimestampFunction(((BasicValuedExpressableType)function.getExpressableType()).getSqlExpressableType());
    }

    @Override
    public ExtractFunction visitExtractFunction(SqmExtractFunction function) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            ExtractFunction extractFunction = new ExtractFunction((Expression)function.getUnitToExtract().accept(this), (Expression)function.getExtractionSource().accept(this), ((BasicValuedExpressableType)function.getExpressableType()).getSqlExpressableType());
            return extractFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public CountStarFunction visitCountStarFunction(SqmCountStarFunction expression) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            CountStarFunction countStarFunction = new CountStarFunction(expression.isDistinct(), this.getCreationContext().getDomainModel().getTypeConfiguration().getBasicTypeRegistry().getBasicType(Long.class).getSqlExpressableType(this.getCreationContext().getDomainModel().getTypeConfiguration()));
            return countStarFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public LengthFunction visitLengthFunction(SqmLengthFunction function) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            LengthFunction lengthFunction = new LengthFunction(this.toSqlExpression(function.getArgument().accept(this)), this.getCreationContext().getDomainModel().getTypeConfiguration().getBasicTypeRegistry().getBasicType(Long.class).getSqlExpressableType(this.getCreationContext().getDomainModel().getTypeConfiguration()));
            return lengthFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public LocateFunction visitLocateFunction(SqmLocateFunction function) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            LocateFunction locateFunction = new LocateFunction((Expression)function.getPatternString().accept(this), (Expression)function.getStringToSearch().accept(this), function.getStartPosition() == null ? null : (Expression)function.getStartPosition().accept(this));
            return locateFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Object visitLowerFunction(SqmLowerFunction function) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            LowerFunction lowerFunction = new LowerFunction(this.toSqlExpression(function.getArgument().accept(this)), ((BasicValuedExpressableType)function.getExpressableType()).getSqlExpressableType());
            return lowerFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public MaxFunction visitMaxFunction(SqmMaxFunction expression) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            MaxFunction maxFunction = new MaxFunction(this.toSqlExpression(expression.getArgument().accept(this)), expression.isDistinct(), expression.getExpressableType().getSqlExpressableType());
            return maxFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public MinFunction visitMinFunction(SqmMinFunction expression) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            MinFunction minFunction = new MinFunction(this.toSqlExpression(expression.getArgument().accept(this)), expression.isDistinct(), expression.getExpressableType().getSqlExpressableType());
            return minFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitModFunction(SqmModFunction function) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        Expression dividend = (Expression)function.getDividend().accept(this);
        Expression divisor = (Expression)function.getDivisor().accept(this);
        try {
            ModFunction modFunction = new ModFunction(dividend, divisor, ((BasicValuedExpressableType)function.getExpressableType()).getSqlExpressableType());
            return modFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitSubstringFunction(SqmSubstringFunction expression) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            ArrayList<Expression> expressionList = new ArrayList<Expression>();
            expressionList.add(this.toSqlExpression(expression.getSource().accept(this)));
            expressionList.add(this.toSqlExpression(expression.getStartPosition().accept(this)));
            expressionList.add(this.toSqlExpression(expression.getLength().accept(this)));
            SubstrFunction substrFunction = new SubstrFunction(expression.getFunctionName(), expressionList, ((BasicValuedExpressableType)expression.getExpressableType()).getSqlExpressableType());
            return substrFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Object visitStrFunction(SqmStrFunction expression) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            CastFunction castFunction = new CastFunction(this.toSqlExpression(expression.getArgument().accept(this)), ((BasicValuedExpressableType)expression.getExpressableType()).getSqlExpressableType(), null);
            return castFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public SumFunction visitSumFunction(SqmSumFunction expression) {
        this.shallownessStack.push(Shallowness.FUNCTION);
        try {
            SumFunction sumFunction = new SumFunction(this.toSqlExpression(expression.getArgument().accept(this)), expression.isDistinct(), expression.getExpressableType().getSqlExpressableType());
            return sumFunction;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    @Override
    public Object visitUnaryOperationExpression(SqmUnaryOperation expression) {
        this.shallownessStack.push(Shallowness.NONE);
        try {
            UnaryOperation unaryOperation = new UnaryOperation(this.interpret(expression.getOperation()), (Expression)expression.getOperand().accept(this), expression.getExpressableType().getSqlExpressableType());
            return unaryOperation;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    private UnaryArithmeticOperator interpret(UnaryArithmeticOperator operator) {
        return operator;
    }

    @Override
    public Expression visitBinaryArithmeticExpression(SqmBinaryArithmetic expression) {
        this.shallownessStack.push(Shallowness.NONE);
        try {
            if (expression.getOperator() == BinaryArithmeticOperator.MODULO) {
                NonStandardFunction nonStandardFunction = new NonStandardFunction("mod", null, (Expression)expression.getLeftHandOperand().accept(this), (Expression)expression.getRightHandOperand().accept(this));
                return nonStandardFunction;
            }
            BinaryArithmeticExpression binaryArithmeticExpression = new BinaryArithmeticExpression((Expression)expression.getLeftHandOperand().accept(this), this.interpret(expression.getOperator()), (Expression)expression.getRightHandOperand().accept(this), expression.getExpressableType().getSqlExpressableType());
            return binaryArithmeticExpression;
        }
        finally {
            this.shallownessStack.pop();
        }
    }

    private BinaryArithmeticOperator interpret(BinaryArithmeticOperator operator) {
        switch (operator) {
            case ADD: {
                return BinaryArithmeticOperator.ADD;
            }
            case SUBTRACT: {
                return BinaryArithmeticOperator.SUBTRACT;
            }
            case MULTIPLY: {
                return BinaryArithmeticOperator.MULTIPLY;
            }
            case DIVIDE: {
                return BinaryArithmeticOperator.DIVIDE;
            }
            case QUOT: {
                return BinaryArithmeticOperator.QUOT;
            }
        }
        throw new IllegalStateException("Unexpected BinaryArithmeticOperator : " + (Object)((Object)operator));
    }

    @Override
    public CoalesceFunction visitCoalesceFunction(SqmCoalesceFunction expression) {
        CoalesceFunction result = new CoalesceFunction();
        for (SqmExpression value : expression.getArguments()) {
            result.value((Expression)value.accept(this));
        }
        return result;
    }

    @Override
    public Object visitSubQueryExpression(SqmSubQuery sqmSubQuery) {
        QuerySpec subQuerySpec = this.visitQuerySpec(sqmSubQuery.getQuerySpec());
        ExpressableType<?> expressableType = this.determineExpressableType(sqmSubQuery);
        return new SubQuery(subQuerySpec, expressableType instanceof BasicValuedExpressableType ? ((BasicValuedExpressableType)expressableType).getSqlExpressableType(this.getTypeConfiguration()) : null, expressableType);
    }

    @Override
    public CaseSimpleExpression visitSimpleCaseExpression(SqmCaseSimple expression) {
        CaseSimpleExpression result = new CaseSimpleExpression(expression.getExpressableType().getSqlExpressableType(), (Expression)expression.getFixture().accept(this));
        for (SqmCaseSimple.WhenFragment whenFragment : expression.getWhenFragments()) {
            result.when((Expression)whenFragment.getCheckValue().accept(this), (Expression)whenFragment.getResult().accept(this));
        }
        result.otherwise((Expression)expression.getOtherwise().accept(this));
        return result;
    }

    @Override
    public CaseSearchedExpression visitSearchedCaseExpression(SqmCaseSearched expression) {
        CaseSearchedExpression result = new CaseSearchedExpression(((BasicValuedExpressableType)expression.getExpressableType()).getSqlExpressableType());
        for (SqmCaseSearched.WhenFragment whenFragment : expression.getWhenFragments()) {
            result.when((Predicate)whenFragment.getPredicate().accept(this), (Expression)whenFragment.getResult().accept(this));
        }
        result.otherwise((Expression)expression.getOtherwise().accept(this));
        return result;
    }

    @Override
    public NullifFunction visitNullifFunction(SqmNullifFunction expression) {
        return new NullifFunction((Expression)expression.getFirstArgument().accept(this), (Expression)expression.getSecondArgument().accept(this), ((BasicValuedExpressableType)expression.getExpressableType()).getSqlExpressableType());
    }

    @Override
    public Object visitTrimFunction(SqmTrimFunction expression) {
        return new TrimFunction(expression.getSpecification(), (Expression)expression.getTrimCharacter().accept(this), (Expression)expression.getSource().accept(this), this.getCreationContext());
    }

    @Override
    public Object visitUpperFunction(SqmUpperFunction sqmFunction) {
        return new UpperFunction(this.toSqlExpression(sqmFunction.getArgument().accept(this)), ((BasicValuedExpressableType)sqmFunction.getExpressableType()).getSqlExpressableType());
    }

    @Override
    public ConcatFunction visitConcatExpression(SqmConcat expression) {
        return new ConcatFunction(Arrays.asList((Expression)expression.getLeftHandOperand().accept(this), (Expression)expression.getRightHandOperand().accept(this)), expression.getExpressableType().getSqlExpressableType());
    }

    @Override
    public ColumnReference visitExplicitColumnReference(SqmColumnReference sqmColumnReference) {
        TableGroup tableGroup = this.fromClauseIndex.findTableGroup(sqmColumnReference.getSqmFromBase().getNavigablePath());
        ColumnReference columnReference = tableGroup.locateColumnReferenceByName(sqmColumnReference.getColumnName());
        if (columnReference == null) {
            throw new HibernateException("Could not resolve ColumnReference");
        }
        return columnReference;
    }

    @Override
    public GroupedPredicate visitGroupedPredicate(GroupedSqmPredicate predicate) {
        return new GroupedPredicate((Predicate)predicate.getSubPredicate().accept(this));
    }

    @Override
    public Junction visitAndPredicate(AndSqmPredicate predicate) {
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        conjunction.add((Predicate)predicate.getLeftHandPredicate().accept(this));
        conjunction.add((Predicate)predicate.getRightHandPredicate().accept(this));
        return conjunction;
    }

    @Override
    public Junction visitOrPredicate(OrSqmPredicate predicate) {
        Junction disjunction = new Junction(Junction.Nature.DISJUNCTION);
        disjunction.add((Predicate)predicate.getLeftHandPredicate().accept(this));
        disjunction.add((Predicate)predicate.getRightHandPredicate().accept(this));
        return disjunction;
    }

    @Override
    public NegatedPredicate visitNegatedPredicate(NegatedSqmPredicate predicate) {
        return new NegatedPredicate((Predicate)predicate.getWrappedPredicate().accept(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComparisonPredicate visitComparisonPredicate(SqmComparisonPredicate predicate) {
        Expression rhs;
        Expression lhs;
        this.inferableTypeAccessStack.push(predicate.getRightHandExpression()::getExpressableType);
        try {
            lhs = this.toSqlExpression(predicate.getLeftHandExpression().accept(this));
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        this.inferableTypeAccessStack.push(predicate.getLeftHandExpression()::getExpressableType);
        try {
            rhs = this.toSqlExpression(predicate.getRightHandExpression().accept(this));
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        return new ComparisonPredicate(lhs, this.interpret(predicate.getOperator()), rhs);
    }

    private Expression toSqlExpression(Object value) {
        if (value instanceof SqmExpressionInterpretation) {
            return ((SqmExpressionInterpretation)value).toSqlExpression(this);
        }
        return (Expression)value;
    }

    private ComparisonOperator interpret(ComparisonOperator operator) {
        switch (operator) {
            case EQUAL: {
                return ComparisonOperator.EQUAL;
            }
            case NOT_EQUAL: {
                return ComparisonOperator.NOT_EQUAL;
            }
            case GREATER_THAN_OR_EQUAL: {
                return ComparisonOperator.GREATER_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return ComparisonOperator.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return ComparisonOperator.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return ComparisonOperator.LESS_THAN;
            }
        }
        throw new IllegalStateException("Unexpected RelationalPredicate Type : " + (Object)((Object)operator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BetweenPredicate visitBetweenPredicate(BetweenSqmPredicate predicate) {
        Expression upperBound;
        Expression lowerBound;
        Expression expression;
        this.inferableTypeAccessStack.push(() -> (ExpressableType)NullnessHelper.coalesce(() -> predicate.getLowerBound().getExpressableType(), () -> predicate.getUpperBound().getExpressableType()));
        try {
            expression = (Expression)predicate.getExpression().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        this.inferableTypeAccessStack.push(() -> (ExpressableType)NullnessHelper.coalesce(() -> predicate.getExpression().getExpressableType(), () -> predicate.getUpperBound().getExpressableType()));
        try {
            lowerBound = (Expression)predicate.getLowerBound().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        this.inferableTypeAccessStack.push(() -> (ExpressableType)NullnessHelper.coalesce(() -> predicate.getExpression().getExpressableType(), () -> predicate.getLowerBound().getExpressableType()));
        try {
            upperBound = (Expression)predicate.getUpperBound().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        return new BetweenPredicate(expression, lowerBound, upperBound, predicate.isNegated());
    }

    @Override
    public LikePredicate visitLikePredicate(LikeSqmPredicate predicate) {
        Expression escapeExpression = predicate.getEscapeCharacter() == null ? null : (Expression)predicate.getEscapeCharacter().accept(this);
        return new LikePredicate((Expression)predicate.getMatchExpression().accept(this), (Expression)predicate.getPattern().accept(this), escapeExpression, predicate.isNegated());
    }

    @Override
    public NullnessPredicate visitIsNullPredicate(NullnessSqmPredicate predicate) {
        return new NullnessPredicate(this.toSqlExpression(predicate.getExpression().accept(this)), predicate.isNegated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InListPredicate visitInListPredicate(InListSqmPredicate predicate) {
        SqmParameter sqmParameter;
        QueryParameterImplementor<?> domainParam;
        Object domainParamBinding;
        SqmExpression sqmExpression;
        if (predicate.getListExpressions().size() == 1 && (sqmExpression = predicate.getListExpressions().get(0)) instanceof SqmParameter && (domainParamBinding = this.domainParameterBindings.getBinding(domainParam = this.domainParameterXref.getQueryParameter(sqmParameter = (SqmParameter)sqmExpression))).isMultiValued()) {
            InListPredicate inListPredicate = new InListPredicate(this.toSqlExpression(predicate.getTestExpression().accept(this)));
            this.inferableTypeAccessStack.push(() -> {
                Supplier<? extends ExpressableType> inferableTypeSupplier = predicate.getTestExpression().getInferableType();
                if (inferableTypeSupplier != null) {
                    return inferableTypeSupplier.get();
                }
                return null;
            });
            try {
                boolean first = true;
                for (Object bindValue : domainParamBinding.getBindValues()) {
                    SqmParameter sqmParamToConsume;
                    if (first) {
                        sqmParamToConsume = sqmParameter;
                        first = false;
                    } else {
                        sqmParamToConsume = sqmParameter.copy();
                        this.domainParameterXref.addExpansion(domainParam, sqmParameter, sqmParamToConsume);
                    }
                    inListPredicate.addExpression(this.consumeSqmParameter(sqmParamToConsume));
                }
            }
            finally {
                this.inferableTypeAccessStack.pop();
            }
            return inListPredicate;
        }
        InListPredicate inPredicate = new InListPredicate(this.toSqlExpression(predicate.getTestExpression().accept(this)), predicate.isNegated());
        for (SqmExpression expression : predicate.getListExpressions()) {
            inPredicate.addExpression((Expression)expression.accept(this));
        }
        return inPredicate;
    }

    @Override
    public InSubQueryPredicate visitInSubQueryPredicate(InSubQuerySqmPredicate predicate) {
        return new InSubQueryPredicate((Expression)predicate.getTestExpression().accept(this), (QuerySpec)predicate.getSubQueryExpression().accept(this), predicate.isNegated());
    }

    protected static enum Shallowness {
        NONE,
        CTOR,
        FUNCTION,
        SUBQUERY;

    }
}

