/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.consume.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.consume.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.produce.SqmCreationProcessingState;
import org.hibernate.query.sqm.produce.SqmPathRegistry;
import org.hibernate.query.sqm.produce.SqmQuerySpecCreationProcessingState;
import org.hibernate.query.sqm.produce.spi.ImplicitAliasGenerator;
import org.hibernate.query.sqm.produce.spi.SqmCreationContext;
import org.hibernate.query.sqm.produce.spi.SqmCreationOptions;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmConcat;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmSubQuery;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.expression.function.Distinctable;
import org.hibernate.query.sqm.tree.expression.function.SqmAvgFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmConcatFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCountFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmCountStarFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmGenericFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmMaxFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmMinFunction;
import org.hibernate.query.sqm.tree.expression.function.SqmSumFunction;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmNavigableJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.AndSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.BetweenSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.EmptinessSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.GroupedSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.InListSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.InSubQuerySqmPredicate;
import org.hibernate.query.sqm.tree.predicate.LikeSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.MemberOfSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.NegatedSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.NullnessSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.OrSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmGroupByClause;
import org.hibernate.query.sqm.tree.select.SqmHavingClause;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;
import org.hibernate.sql.ast.produce.spi.SqlAstFunctionProducer;

public class QuerySplitter {
    public static SqmSelectStatement[] split(SqmSelectStatement statement, SessionFactoryImplementor sessionFactory) {
        SqmRoot unmappedPolymorphicReference = null;
        for (SqmRoot root : statement.getQuerySpec().getFromClause().getRoots()) {
            if (!(root.getReferencedNavigable() instanceof SqmPolymorphicRootDescriptor)) continue;
            unmappedPolymorphicReference = root;
        }
        if (unmappedPolymorphicReference == null) {
            return new SqmSelectStatement[]{statement};
        }
        SqmPolymorphicRootDescriptor unmappedPolymorphicDescriptor = (SqmPolymorphicRootDescriptor)unmappedPolymorphicReference.getReferencedNavigable();
        SqmSelectStatement[] expanded = new SqmSelectStatement[unmappedPolymorphicDescriptor.getImplementors().size()];
        int i = -1;
        for (EntityTypeDescriptor<?> mappedDescriptor : unmappedPolymorphicDescriptor.getImplementors()) {
            UnmappedPolymorphismReplacer replacer = new UnmappedPolymorphismReplacer(unmappedPolymorphicReference, mappedDescriptor, sessionFactory);
            expanded[++i] = replacer.visitSelectStatement(statement);
        }
        return expanded;
    }

    private static class UnmappedPolymorphismReplacer
    extends BaseSemanticQueryWalker
    implements SqmCreationState {
        private final SqmRoot unmappedPolymorphicFromElement;
        private final EntityTypeDescriptor mappedDescriptor;
        private Map<NavigablePath, SqmPath> sqmPathCopyMap = new HashMap<NavigablePath, SqmPath>();
        private Map<SqmFrom, SqmFrom> sqmFromCopyMap = new HashMap<SqmFrom, SqmFrom>();
        private SqmFromClause currentFromClauseCopy = null;

        private UnmappedPolymorphismReplacer(SqmRoot unmappedPolymorphicFromElement, EntityTypeDescriptor mappedDescriptor, SessionFactoryImplementor sessionFactory) {
            super(sessionFactory.getTypeConfiguration(), sessionFactory.getServiceRegistry());
            this.unmappedPolymorphicFromElement = unmappedPolymorphicFromElement;
            this.mappedDescriptor = mappedDescriptor;
        }

        @Override
        public SqmUpdateStatement visitUpdateStatement(SqmUpdateStatement statement) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmSetClause visitSetClause(SqmSetClause setClause) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmAssignment visitAssignment(SqmAssignment assignment) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmDeleteStatement visitDeleteStatement(SqmDeleteStatement statement) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmSelectStatement visitSelectStatement(SqmSelectStatement statement) {
            SqmSelectStatement copy = new SqmSelectStatement();
            copy.setQuerySpec(this.visitQuerySpec(statement.getQuerySpec()));
            return copy;
        }

        @Override
        public SqmQuerySpec visitQuerySpec(SqmQuerySpec querySpec) {
            SqmQuerySpec sqmQuerySpec = new SqmQuerySpec();
            sqmQuerySpec.setFromClause(this.visitFromClause(querySpec.getFromClause()));
            sqmQuerySpec.setSelectClause(this.visitSelectClause(querySpec.getSelectClause()));
            sqmQuerySpec.setWhereClause(this.visitWhereClause(querySpec.getWhereClause()));
            sqmQuerySpec.setGroupByClause(this.visitGroupByClause(querySpec.getGroupByClause()));
            sqmQuerySpec.setOrderByClause(this.visitOrderByClause(querySpec.getOrderByClause()));
            sqmQuerySpec.setLimitExpression((SqmExpression)querySpec.getLimitExpression().accept(this));
            sqmQuerySpec.setOffsetExpression((SqmExpression)querySpec.getOffsetExpression().accept(this));
            return querySpec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SqmFromClause visitFromClause(SqmFromClause fromClause) {
            SqmFromClause previousCurrent = this.currentFromClauseCopy;
            try {
                SqmFromClause copy;
                this.currentFromClauseCopy = copy = new SqmFromClause();
                super.visitFromClause(fromClause);
                SqmFromClause sqmFromClause = copy;
                return sqmFromClause;
            }
            finally {
                this.currentFromClauseCopy = previousCurrent;
            }
        }

        @Override
        public SqmGroupByClause visitGroupByClause(SqmGroupByClause clause) {
            SqmGroupByClause result = new SqmGroupByClause();
            clause.visitGroupings(grouping -> result.addGrouping((SqmExpression)grouping.getExpression().accept(this), grouping.getCollation()));
            return result;
        }

        @Override
        public SqmGroupByClause.SqmGrouping visitGrouping(SqmGroupByClause.SqmGrouping grouping) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SqmHavingClause visitHavingClause(SqmHavingClause clause) {
            return new SqmHavingClause((SqmPredicate)clause.getPredicate().accept(this));
        }

        @Override
        public SqmRoot visitRootPath(SqmRoot sqmRoot) {
            return (SqmRoot)this.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(sqmRoot.getNavigablePath(), navigablePath -> {
                SqmRoot copy = sqmRoot == this.unmappedPolymorphicFromElement ? new SqmRoot(this.mappedDescriptor, sqmRoot.getExplicitAlias()) : new SqmRoot(sqmRoot.getReferencedNavigable().getEntityDescriptor(), sqmRoot.getExplicitAlias());
                this.sqmFromCopyMap.put(sqmRoot, copy);
                this.sqmPathCopyMap.put(sqmRoot.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmCrossJoin visitCrossJoinedFromElement(SqmCrossJoin join) {
            return (SqmCrossJoin)this.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(join.getNavigablePath(), navigablePath -> {
                SqmCrossJoin copy = new SqmCrossJoin(join.getReferencedNavigable().getEntityDescriptor(), join.getExplicitAlias(), (SqmRoot)this.sqmFromCopyMap.get(join.findRoot()));
                this.sqmFromCopyMap.put(join, copy);
                this.sqmPathCopyMap.put(join.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmEntityJoin visitQualifiedEntityJoinFromElement(SqmEntityJoin join) {
            return (SqmEntityJoin)this.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(join.getNavigablePath(), navigablePath -> {
                SqmEntityJoin copy = new SqmEntityJoin(join.getReferencedNavigable().getEntityDescriptor(), join.getExplicitAlias(), join.getJoinType(), (SqmRoot)this.sqmFromCopyMap.get(join.findRoot()));
                this.sqmFromCopyMap.put(join, copy);
                this.sqmPathCopyMap.put(join.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmNavigableJoin visitQualifiedAttributeJoinFromElement(SqmNavigableJoin join) {
            return (SqmNavigableJoin)this.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(join.getNavigablePath(), navigablePath -> {
                SqmNavigableJoin copy = new SqmNavigableJoin(this.getProcessingStateStack().getCurrent().getPathRegistry().findFromByPath(join.getLhs().getNavigablePath()), (Joinable)join.getReferencedNavigable(), join.getExplicitAlias(), join.getJoinType(), join.isFetched(), this);
                this.sqmFromCopyMap.put(join, copy);
                this.sqmPathCopyMap.put(join.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmBasicValuedSimplePath visitBasicValuedPath(SqmBasicValuedSimplePath path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            return (SqmBasicValuedSimplePath)pathRegistry.resolvePath(path.getNavigablePath(), navigablePath -> {
                SqmBasicValuedSimplePath copy = new SqmBasicValuedSimplePath((NavigablePath)navigablePath, path.getReferencedNavigable(), (SqmPath)pathRegistry.findFromByPath(path.getLhs().getNavigablePath()));
                this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmEmbeddedValuedSimplePath visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            return (SqmEmbeddedValuedSimplePath)pathRegistry.resolvePath(path.getNavigablePath(), navigablePath -> {
                SqmEmbeddedValuedSimplePath copy = new SqmEmbeddedValuedSimplePath((NavigablePath)navigablePath, path.getReferencedNavigable(), (SqmPath)pathRegistry.findFromByPath(path.getLhs().getNavigablePath()));
                this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmEntityValuedSimplePath visitEntityValuedPath(SqmEntityValuedSimplePath path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            return (SqmEntityValuedSimplePath)pathRegistry.resolvePath(path.getNavigablePath(), navigablePath -> {
                SqmEntityValuedSimplePath copy = new SqmEntityValuedSimplePath((NavigablePath)navigablePath, path.getReferencedNavigable(), (SqmPath)pathRegistry.findFromByPath(path.getLhs().getNavigablePath()));
                this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmPluralValuedSimplePath visitPluralValuedPath(SqmPluralValuedSimplePath path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            return (SqmPluralValuedSimplePath)pathRegistry.resolvePath(path.getNavigablePath(), navigablePath -> {
                SqmPluralValuedSimplePath copy = new SqmPluralValuedSimplePath((NavigablePath)navigablePath, path.getReferencedNavigable(), (SqmPath)pathRegistry.findFromByPath(path.getLhs().getNavigablePath()));
                this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
                return copy;
            });
        }

        @Override
        public SqmSelectClause visitSelectClause(SqmSelectClause selectClause) {
            SqmSelectClause copy = new SqmSelectClause(selectClause.isDistinct());
            for (SqmSelection selection : selectClause.getSelections()) {
                copy.addSelection(new SqmSelection((SqmExpression)selection.getSelectableNode().accept(this), selection.getAlias()));
            }
            return copy;
        }

        @Override
        public SqmDynamicInstantiation visitDynamicInstantiation(SqmDynamicInstantiation original) {
            SqmDynamicInstantiation copy;
            SqmDynamicInstantiationTarget instantiationTarget = original.getInstantiationTarget();
            switch (instantiationTarget.getNature()) {
                case MAP: {
                    copy = SqmDynamicInstantiation.forMapInstantiation(instantiationTarget.getTargetTypeDescriptor());
                    break;
                }
                case LIST: {
                    copy = SqmDynamicInstantiation.forListInstantiation(instantiationTarget.getTargetTypeDescriptor());
                    break;
                }
                default: {
                    copy = SqmDynamicInstantiation.forClassInstantiation(instantiationTarget.getTargetTypeDescriptor());
                }
            }
            for (SqmDynamicInstantiationArgument originalArgument : original.getArguments()) {
                copy.addArgument(new SqmDynamicInstantiationArgument((SqmSelectableNode)originalArgument.getSelectableNode().accept(this), originalArgument.getAlias()));
            }
            return copy;
        }

        @Override
        public SqmWhereClause visitWhereClause(SqmWhereClause whereClause) {
            if (whereClause == null) {
                return null;
            }
            return new SqmWhereClause((SqmPredicate)whereClause.getPredicate().accept(this));
        }

        @Override
        public GroupedSqmPredicate visitGroupedPredicate(GroupedSqmPredicate predicate) {
            return new GroupedSqmPredicate((SqmPredicate)predicate.accept(this));
        }

        @Override
        public AndSqmPredicate visitAndPredicate(AndSqmPredicate predicate) {
            return new AndSqmPredicate((SqmPredicate)predicate.getLeftHandPredicate().accept(this), (SqmPredicate)predicate.getRightHandPredicate().accept(this));
        }

        @Override
        public OrSqmPredicate visitOrPredicate(OrSqmPredicate predicate) {
            return new OrSqmPredicate((SqmPredicate)predicate.getLeftHandPredicate().accept(this), (SqmPredicate)predicate.getRightHandPredicate().accept(this));
        }

        @Override
        public SqmComparisonPredicate visitComparisonPredicate(SqmComparisonPredicate predicate) {
            return new SqmComparisonPredicate((SqmExpression)predicate.getLeftHandExpression().accept(this), predicate.getOperator(), (SqmExpression)predicate.getRightHandExpression().accept(this));
        }

        @Override
        public EmptinessSqmPredicate visitIsEmptyPredicate(EmptinessSqmPredicate predicate) {
            return new EmptinessSqmPredicate((SqmPath)predicate.getPluralPath().accept(this), predicate.isNegated());
        }

        @Override
        public NullnessSqmPredicate visitIsNullPredicate(NullnessSqmPredicate predicate) {
            return new NullnessSqmPredicate((SqmExpression)predicate.getExpression().accept(this), predicate.isNegated());
        }

        @Override
        public BetweenSqmPredicate visitBetweenPredicate(BetweenSqmPredicate predicate) {
            return new BetweenSqmPredicate((SqmExpression)predicate.getExpression().accept(this), (SqmExpression)predicate.getLowerBound().accept(this), (SqmExpression)predicate.getUpperBound().accept(this), predicate.isNegated());
        }

        @Override
        public LikeSqmPredicate visitLikePredicate(LikeSqmPredicate predicate) {
            return new LikeSqmPredicate((SqmExpression)predicate.getMatchExpression().accept(this), (SqmExpression)predicate.getPattern().accept(this), (SqmExpression)predicate.getEscapeCharacter().accept(this));
        }

        @Override
        public MemberOfSqmPredicate visitMemberOfPredicate(MemberOfSqmPredicate predicate) {
            SqmPath pathCopy = this.sqmPathCopyMap.get(predicate.getPluralPath().getNavigablePath());
            return new MemberOfSqmPredicate(pathCopy);
        }

        @Override
        public NegatedSqmPredicate visitNegatedPredicate(NegatedSqmPredicate predicate) {
            return new NegatedSqmPredicate((SqmPredicate)predicate.getWrappedPredicate().accept(this));
        }

        @Override
        public InListSqmPredicate visitInListPredicate(InListSqmPredicate predicate) {
            InListSqmPredicate copy = new InListSqmPredicate((SqmExpression)predicate.getTestExpression().accept(this));
            for (SqmExpression expression : predicate.getListExpressions()) {
                copy.addExpression((SqmExpression)expression.accept(this));
            }
            return copy;
        }

        @Override
        public InSubQuerySqmPredicate visitInSubQueryPredicate(InSubQuerySqmPredicate predicate) {
            return new InSubQuerySqmPredicate((SqmExpression)predicate.getTestExpression().accept(this), this.visitSubQueryExpression(predicate.getSubQueryExpression()));
        }

        @Override
        public SqmOrderByClause visitOrderByClause(SqmOrderByClause orderByClause) {
            if (orderByClause == null) {
                return null;
            }
            SqmOrderByClause copy = new SqmOrderByClause();
            for (SqmSortSpecification sortSpecification : orderByClause.getSortSpecifications()) {
                copy.addSortSpecification(this.visitSortSpecification(sortSpecification));
            }
            return copy;
        }

        @Override
        public SqmSortSpecification visitSortSpecification(SqmSortSpecification sortSpecification) {
            return new SqmSortSpecification((SqmExpression)sortSpecification.getSortExpression().accept(this), sortSpecification.getCollation(), sortSpecification.getSortOrder());
        }

        @Override
        public SqmPositionalParameter visitPositionalParameterExpression(SqmPositionalParameter expression) {
            return new SqmPositionalParameter(expression.getPosition(), expression.allowMultiValuedBinding());
        }

        @Override
        public SqmNamedParameter visitNamedParameterExpression(SqmNamedParameter expression) {
            return new SqmNamedParameter(expression.getName(), expression.allowMultiValuedBinding());
        }

        @Override
        public SqmLiteralEntityType visitEntityTypeLiteralExpression(SqmLiteralEntityType expression) {
            return new SqmLiteralEntityType(expression.getExpressableType());
        }

        @Override
        public SqmUnaryOperation visitUnaryOperationExpression(SqmUnaryOperation expression) {
            return new SqmUnaryOperation(expression.getOperation(), (SqmExpression)expression.getOperand().accept(this));
        }

        @Override
        public SqmGenericFunction visitGenericFunction(SqmGenericFunction expression) {
            ArrayList<SqmExpression> argumentsCopy = new ArrayList<SqmExpression>();
            for (SqmExpression argument : expression.getArguments()) {
                argumentsCopy.add((SqmExpression)argument.accept(this));
            }
            return new SqmGenericFunction(expression.getFunctionName(), expression.getExpressableType(), argumentsCopy);
        }

        @Override
        public SqlAstFunctionProducer visitSqlAstFunctionProducer(SqlAstFunctionProducer functionProducer) {
            return functionProducer;
        }

        @Override
        public SqmAvgFunction visitAvgFunction(SqmAvgFunction expression) {
            return this.handleDistinct(new SqmAvgFunction((SqmExpression)expression.getArgument().accept(this), expression.getExpressableType()), expression.isDistinct());
        }

        private <T extends SqmFunction> T handleDistinct(T function, boolean shouldMakeDistinction) {
            if (function instanceof Distinctable && shouldMakeDistinction) {
                ((Distinctable)((Object)function)).makeDistinct();
            }
            return function;
        }

        @Override
        public SqmCountStarFunction visitCountStarFunction(SqmCountStarFunction expression) {
            return this.handleDistinct(new SqmCountStarFunction(expression.getExpressableType()), expression.isDistinct());
        }

        @Override
        public SqmCountFunction visitCountFunction(SqmCountFunction expression) {
            return this.handleDistinct(new SqmCountFunction((SqmExpression)expression.getArgument().accept(this), expression.getExpressableType()), expression.isDistinct());
        }

        @Override
        public SqmMaxFunction visitMaxFunction(SqmMaxFunction expression) {
            return this.handleDistinct(new SqmMaxFunction((SqmExpression)expression.getArgument().accept(this), expression.getExpressableType()), expression.isDistinct());
        }

        @Override
        public SqmMinFunction visitMinFunction(SqmMinFunction expression) {
            return this.handleDistinct(new SqmMinFunction((SqmExpression)expression.getArgument().accept(this), expression.getExpressableType()), expression.isDistinct());
        }

        @Override
        public SqmSumFunction visitSumFunction(SqmSumFunction expression) {
            return this.handleDistinct(new SqmSumFunction((SqmExpression)expression.getArgument().accept(this), expression.getExpressableType()), expression.isDistinct());
        }

        @Override
        public SqmLiteral visitLiteral(SqmLiteral literal) {
            return new SqmLiteral(literal.getLiteralValue(), literal.getExpressableType());
        }

        @Override
        public SqmConcat visitConcatExpression(SqmConcat expression) {
            return new SqmConcat((SqmExpression)expression.getLeftHandOperand().accept(this), (SqmExpression)expression.getRightHandOperand().accept(this));
        }

        @Override
        public SqmConcatFunction visitConcatFunction(SqmConcatFunction expression) {
            ArrayList<SqmExpression> arguments = new ArrayList<SqmExpression>();
            for (SqmExpression argument : expression.getExpressions()) {
                arguments.add((SqmExpression)argument.accept(this));
            }
            return new SqmConcatFunction((BasicValuedExpressableType)expression.getExpressableType(), arguments);
        }

        @Override
        public SqmBinaryArithmetic visitBinaryArithmeticExpression(SqmBinaryArithmetic expression) {
            return new SqmBinaryArithmetic((SqmExpression)expression.getLeftHandOperand().accept(this), expression.getOperator(), (SqmExpression)expression.getRightHandOperand().accept(this), expression.getExpressableType());
        }

        @Override
        public SqmSubQuery visitSubQueryExpression(SqmSubQuery expression) {
            return new SqmSubQuery(this.visitQuerySpec(expression.getQuerySpec()), ((SqmExpression)expression.getQuerySpec().getSelectClause().getSelections().get(0).getSelectableNode()).getExpressableType());
        }

        @Override
        public SqmQuerySpecCreationProcessingState getCurrentQuerySpecProcessingState() {
            throw new NotYetImplementedFor6Exception();
        }

        @Override
        public Stack<SqmCreationProcessingState> getProcessingStateStack() {
            throw new NotYetImplementedFor6Exception();
        }

        @Override
        public SqmCreationContext getCreationContext() {
            throw new NotYetImplementedFor6Exception();
        }

        @Override
        public SqmCreationOptions getCreationOptions() {
            return () -> false;
        }

        @Override
        public String generateUniqueIdentifier() {
            throw new NotYetImplementedFor6Exception();
        }

        @Override
        public ImplicitAliasGenerator getImplicitAliasGenerator() {
            throw new NotYetImplementedFor6Exception();
        }
    }
}

