/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Tuple;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.streams.StingArrayCollector;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.JpaTupleTransformer;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.consume.internal.SqmConsumeHelper;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.consume.spi.SqlAstSelectToJdbcSelectConverter;
import org.hibernate.sql.ast.produce.sqm.spi.SqmSelectInterpretation;
import org.hibernate.sql.ast.produce.sqm.spi.SqmSelectToSqlAstConverter;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.internal.RowTransformerJpaTupleImpl;
import org.hibernate.sql.exec.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.exec.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.exec.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.exec.internal.TupleElementImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.exec.spi.RowTransformer;

public class ConcreteSqmSelectQueryPlan<R>
implements SelectQueryPlan<R> {
    private final SqmSelectStatement sqm;
    private final DomainParameterXref domainParameterXref;
    private final RowTransformer<R> rowTransformer;
    private JdbcSelect jdbcSelect;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref;

    public ConcreteSqmSelectQueryPlan(SqmSelectStatement sqm, DomainParameterXref domainParameterXref, Class<R> resultType, QueryOptions queryOptions) {
        this.sqm = sqm;
        this.domainParameterXref = domainParameterXref;
        this.rowTransformer = this.determineRowTransformer(sqm, resultType, queryOptions);
    }

    private RowTransformer<R> determineRowTransformer(SqmSelectStatement sqm, Class<R> resultType, QueryOptions queryOptions) {
        if (resultType == null || resultType.isArray()) {
            if (queryOptions.getTupleTransformer() != null) {
                return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
            }
            return RowTransformerPassThruImpl.instance();
        }
        if (Tuple.class.isAssignableFrom(resultType)) {
            if (queryOptions.getTupleTransformer() == null) {
                ArrayList tupleElementList = new ArrayList();
                for (SqmSelection selection : sqm.getQuerySpec().getSelectClause().getSelections()) {
                    tupleElementList.add(new TupleElementImpl(selection.getSelectableNode().getJavaTypeDescriptor().getJavaType(), selection.getAlias()));
                }
                return new RowTransformerJpaTupleImpl(tupleElementList);
            }
            if (queryOptions.getTupleTransformer() instanceof JpaTupleTransformer) {
                return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
            }
            throw new IllegalArgumentException("Illegal combination of Tuple resultType and (non-JpaTupleBuilder) TupleTransformer : " + queryOptions.getTupleTransformer());
        }
        if (queryOptions.getTupleTransformer() != null) {
            return this.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
        }
        if (sqm.getQuerySpec().getSelectClause().getSelections().size() > 1) {
            throw new IllegalQueryOperationException("Query defined multiple selections, return cannot be typed (other that Object[] or Tuple)");
        }
        return RowTransformerSingularReturnImpl.instance();
    }

    private RowTransformer makeRowTransformerTupleTransformerAdapter(SqmSelectStatement sqm, QueryOptions queryOptions) {
        return new RowTransformerTupleTransformerAdapter(sqm.getQuerySpec().getSelectClause().getSelections().stream().map(SqmSelection::getAlias).collect(StingArrayCollector.INSTANCE), queryOptions.getTupleTransformer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<R> performList(ExecutionContext executionContext) {
        if (this.jdbcSelect == null) {
            SqmSelectToSqlAstConverter sqmConverter = this.getSqmSelectToSqlAstConverter(executionContext);
            SqmSelectInterpretation interpretation = sqmConverter.interpret(this.sqm);
            this.jdbcSelect = SqlAstSelectToJdbcSelectConverter.interpret(interpretation, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
            this.jdbcParamsXref = SqmConsumeHelper.generateJdbcParamsXref(this.domainParameterXref, interpretation);
        }
        JdbcParameterBindings jdbcParameterBindings = QueryHelper.createJdbcParameterBindings(executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, executionContext.getSession());
        try {
            List<R> list = JdbcSelectExecutorStandardImpl.INSTANCE.list(this.jdbcSelect, jdbcParameterBindings, executionContext, this.rowTransformer);
            return list;
        }
        finally {
            this.domainParameterXref.clearExpansions();
        }
    }

    private SqmSelectToSqlAstConverter getSqmSelectToSqlAstConverter(ExecutionContext executionContext) {
        return new SqmSelectToSqlAstConverter(executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), executionContext.getLoadQueryInfluencers(), afterLoadAction -> {}, executionContext.getSession().getFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResultsImplementor performScroll(ScrollMode scrollMode, ExecutionContext executionContext) {
        SqmSelectToSqlAstConverter sqmConverter = this.getSqmSelectToSqlAstConverter(executionContext);
        SqmSelectInterpretation interpretation = sqmConverter.interpret(this.sqm);
        JdbcSelect jdbcSelect = SqlAstSelectToJdbcSelectConverter.interpret(interpretation, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        Map<QueryParameterImplementor<?>, Map<SqmParameter, List<JdbcParameter>>> jdbcParamsXref = SqmConsumeHelper.generateJdbcParamsXref(this.domainParameterXref, sqmConverter);
        JdbcParameterBindings jdbcParameterBindings = QueryHelper.createJdbcParameterBindings(executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), this.domainParameterXref, jdbcParamsXref, executionContext.getSession());
        try {
            ScrollableResultsImplementor<R> scrollableResultsImplementor = JdbcSelectExecutorStandardImpl.INSTANCE.scroll(jdbcSelect, scrollMode, jdbcParameterBindings, executionContext, this.rowTransformer);
            return scrollableResultsImplementor;
        }
        finally {
            this.domainParameterXref.clearExpansions();
        }
    }
}

