/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.HibernateException;
import org.hibernate.query.QueryLogger;
import org.hibernate.query.criteria.sqm.JpaParameterSqmWrapper;
import org.hibernate.query.internal.QueryParameterNamedImpl;
import org.hibernate.query.internal.QueryParameterPositionalImpl;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;

public class DomainParameterXref {
    private final Map<QueryParameterImplementor<?>, List<SqmParameter>> sqmParamsByQueryParam;
    private final Map<SqmParameter, QueryParameterImplementor<?>> queryParamBySqmParam;
    private Map<SqmParameter, List<SqmParameter>> expansions;

    public static DomainParameterXref from(SqmStatement sqmStatement) {
        IdentityHashMap sqmParamsByQueryParam = new IdentityHashMap();
        IdentityHashMap queryParamBySqmParam = new IdentityHashMap();
        TreeMap<SqmParameter, QueryParameterImplementor> xrefMap = new TreeMap<SqmParameter, QueryParameterImplementor>((o1, o2) -> {
            if (o1 instanceof SqmNamedParameter) {
                SqmNamedParameter one = (SqmNamedParameter)o1;
                SqmNamedParameter another = (SqmNamedParameter)o2;
                return one.getName().compareTo(another.getName());
            }
            if (o1 instanceof SqmPositionalParameter) {
                SqmPositionalParameter one = (SqmPositionalParameter)o1;
                SqmPositionalParameter another = (SqmPositionalParameter)o2;
                return one.getPosition().compareTo(another.getPosition());
            }
            if (o1 instanceof JpaParameterSqmWrapper) {
                if (o1.getName() != null) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o1.getPosition().compareTo(o2.getPosition());
            }
            throw new HibernateException("Unexpected SqmParameter type for comparison : " + o1 + " & " + o2);
        });
        for (SqmParameter sqmParameter : sqmStatement.getSqmParameters()) {
            QueryParameterImplementor queryParameter = xrefMap.computeIfAbsent(sqmParameter, p -> {
                if (sqmParameter instanceof JpaParameterSqmWrapper) {
                    return ((JpaParameterSqmWrapper)sqmParameter).getJpaParameterExpression();
                }
                if (sqmParameter.getName() != null) {
                    return QueryParameterNamedImpl.fromSqm(sqmParameter);
                }
                if (sqmParameter.getPosition() != null) {
                    return QueryParameterPositionalImpl.fromSqm(sqmParameter);
                }
                throw new UnsupportedOperationException("Unexpected SqmParameter type : " + sqmParameter);
            });
            if (!sqmParameter.allowMultiValuedBinding() && queryParameter.allowsMultiValuedBinding()) {
                QueryLogger.QUERY_LOGGER.debugf("SqmParameter [%s] does not allow multi-valued binding, but mapped to existing QueryParameter [%s] that does - disallowing multi-valued binding", sqmParameter, queryParameter);
                queryParameter.disallowMultiValuedBinding();
            }
            sqmParamsByQueryParam.computeIfAbsent(queryParameter, qp -> new ArrayList()).add(sqmParameter);
            queryParamBySqmParam.put(sqmParameter, queryParameter);
        }
        return new DomainParameterXref(sqmParamsByQueryParam, queryParamBySqmParam);
    }

    public static DomainParameterXref empty() {
        return new DomainParameterXref(Collections.emptyMap(), Collections.emptyMap());
    }

    public DomainParameterXref(Map<QueryParameterImplementor<?>, List<SqmParameter>> sqmParamsByQueryParam, Map<SqmParameter, QueryParameterImplementor<?>> queryParamBySqmParam) {
        this.sqmParamsByQueryParam = sqmParamsByQueryParam;
        this.queryParamBySqmParam = queryParamBySqmParam;
    }

    public boolean hasParameters() {
        return this.sqmParamsByQueryParam != null && !this.sqmParamsByQueryParam.isEmpty();
    }

    public Set<QueryParameterImplementor<?>> getQueryParameters() {
        return this.sqmParamsByQueryParam.keySet();
    }

    public Map<QueryParameterImplementor<?>, List<SqmParameter>> getSqmParamByQueryParam() {
        return this.sqmParamsByQueryParam;
    }

    public List<SqmParameter> getSqmParameters(QueryParameterImplementor<?> queryParameter) {
        return this.sqmParamsByQueryParam.get(queryParameter);
    }

    public QueryParameterImplementor<?> getQueryParameter(SqmParameter sqmParameter) {
        return this.queryParamBySqmParam.get(sqmParameter);
    }

    public void addExpansion(QueryParameterImplementor<?> domainParam, SqmParameter originalSqmParameter, SqmParameter expansion) {
        QueryLogger.QUERY_LOGGER.debugf("Adding domain-param xref expansion : %s", originalSqmParameter);
        this.queryParamBySqmParam.put(expansion, domainParam);
        if (this.expansions == null) {
            this.expansions = new IdentityHashMap<SqmParameter, List<SqmParameter>>();
        }
        this.expansions.computeIfAbsent(originalSqmParameter, p -> new ArrayList()).add(expansion);
    }

    public List<SqmParameter> getExpansions(SqmParameter sqmParameter) {
        if (this.expansions == null) {
            return Collections.emptyList();
        }
        List<SqmParameter> sqmParameters = this.expansions.get(sqmParameter);
        return sqmParameters == null ? Collections.emptyList() : sqmParameters;
    }

    public void clearExpansions() {
        if (this.expansions == null) {
            return;
        }
        for (List<SqmParameter> expansionList : this.expansions.values()) {
            for (SqmParameter expansion : expansionList) {
                this.queryParamBySqmParam.remove(expansion);
            }
        }
        this.expansions.clear();
    }
}

