/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.ScrollMode;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.Query;
import org.hibernate.query.internal.AbstractQuery;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.named.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.named.spi.NamedHqlQueryMemento;
import org.hibernate.query.named.spi.ParameterMemento;
import org.hibernate.query.spi.EntityGraphQueryHint;
import org.hibernate.query.spi.HqlQueryImplementor;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.QueryPlanCache;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.consume.spi.QuerySplitter;
import org.hibernate.query.sqm.internal.AggregatedSelectQueryPlanImpl;
import org.hibernate.query.sqm.internal.ConcreteSqmSelectQueryPlan;
import org.hibernate.query.sqm.internal.DeleteQueryPlanImpl;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.internal.UpdateQueryPlanImpl;
import org.hibernate.query.sqm.mutation.spi.DeleteHandler;
import org.hibernate.query.sqm.mutation.spi.UpdateHandler;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.exec.spi.ExecutionContext;

public class QuerySqmImpl<R>
extends AbstractQuery<R>
implements HqlQueryImplementor<R>,
ExecutionContext,
DomainParameterBindingContext {
    private final String sourceQueryString;
    private final SqmStatement sqmStatement;
    private final Class resultType;
    private final DomainParameterXref domainParameterXref;
    private final ParameterMetadataImpl parameterMetadata;
    private final QueryParameterBindingsImpl parameterBindings;
    private final QueryOptionsImpl queryOptions = new QueryOptionsImpl();

    public QuerySqmImpl(String sourceQueryString, SqmStatement sqmStatement, Class resultType, SharedSessionContractImplementor producer) {
        super(producer);
        if (resultType != null && sqmStatement instanceof SqmDmlStatement) {
            throw new IllegalArgumentException("Non-select queries cannot be typed");
        }
        this.sourceQueryString = sourceQueryString;
        this.sqmStatement = sqmStatement;
        this.resultType = resultType;
        if (sqmStatement.getSqmParameters().isEmpty()) {
            this.domainParameterXref = DomainParameterXref.empty();
            this.parameterMetadata = ParameterMetadataImpl.EMPTY;
        } else {
            this.domainParameterXref = DomainParameterXref.from(sqmStatement);
            this.parameterMetadata = new ParameterMetadataImpl(this.domainParameterXref.getQueryParameters());
        }
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, producer.getFactory());
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.getSession().getFactory();
    }

    private boolean isSelect() {
        return this.sqmStatement instanceof SqmSelectStatement;
    }

    @Override
    public String getQueryString() {
        return this.sourceQueryString;
    }

    @Override
    public Query<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        this.queryOptions.applyGraph((RootGraphImplementor)graph, semantic);
        return this;
    }

    @Override
    protected void applyEntityGraphQueryHint(String hintName, RootGraphImplementor entityGraph) {
        GraphSemantic graphSemantic = GraphSemantic.fromJpaHintName(hintName);
        this.applyGraph((RootGraph)entityGraph, graphSemantic);
    }

    public SqmStatement getSqmStatement() {
        return this.sqmStatement;
    }

    public Class<R> getResultType() {
        return this.resultType;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public ParameterMetadataImplementor<QueryParameterImplementor<?>> getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        HashSet parameters = new HashSet();
        this.parameterMetadata.collectAllParameters(parameters::add);
        return parameters;
    }

    @Override
    protected boolean canApplyAliasSpecificLockModes() {
        return this.isSelect();
    }

    @Override
    protected void verifySettingLockMode() {
        if (!this.isSelect()) {
            throw new IllegalStateException("Illegal attempt to set lock mode on a non-SELECT query");
        }
    }

    @Override
    protected void verifySettingAliasSpecificLockModes() {
        this.verifySettingLockMode();
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isInstance(this)) {
            return (T)this;
        }
        if (cls.isInstance(this.parameterMetadata)) {
            return (T)this.parameterMetadata;
        }
        if (cls.isInstance(this.parameterBindings)) {
            return (T)this.parameterBindings;
        }
        if (cls.isInstance(this.sqmStatement)) {
            return (T)this.sqmStatement;
        }
        if (cls.isInstance(this.queryOptions)) {
            return (T)this.queryOptions;
        }
        if (cls.isInstance(this.queryOptions.getAppliedGraph())) {
            return (T)this.queryOptions.getAppliedGraph();
        }
        if (EntityGraphQueryHint.class.isAssignableFrom(cls)) {
            return (T)new EntityGraphQueryHint(this.queryOptions.getAppliedGraph());
        }
        throw new PersistenceException("Unrecognized unwrap type [" + cls.getName() + "]");
    }

    @Override
    protected boolean applyNativeQueryLockMode(Object value) {
        throw new IllegalStateException("Illegal attempt to set lock mode on non-native query via hint; use Query#setLockMode instead");
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        super.collectHints(hints);
        if (this.queryOptions.getAppliedGraph() != null) {
            hints.put(this.queryOptions.getAppliedGraph().getSemantic().getJpaHintName(), this.queryOptions.getAppliedGraph().getGraph());
        }
    }

    @Override
    protected List<R> doList() {
        SqmUtil.verifyIsSelectStatement(this.getSqmStatement());
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getLockOptions().findGreatestLockMode()));
        return this.resolveSelectQueryPlan().performList(this);
    }

    private boolean requiresTxn(LockMode lockMode) {
        return lockMode != null && lockMode.greaterThan(LockMode.READ);
    }

    private SelectQueryPlan<R> resolveSelectQueryPlan() {
        SelectQueryPlan queryPlan = null;
        SqmInterpretationsKey cacheKey = SqmInterpretationsKey.generateFrom(this);
        if (cacheKey != null) {
            queryPlan = this.getSession().getFactory().getQueryEngine().getQueryPlanCache().getSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            queryPlan = this.buildSelectQueryPlan();
            if (cacheKey != null) {
                this.getSession().getFactory().getQueryEngine().getQueryPlanCache().cacheSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    private SelectQueryPlan<R> buildSelectQueryPlan() {
        SqmSelectStatement[] concreteSqmStatements = QuerySplitter.split((SqmSelectStatement)this.getSqmStatement(), this.getSessionFactory());
        if (concreteSqmStatements.length > 1) {
            return this.buildAggregatedSelectQueryPlan(concreteSqmStatements);
        }
        return this.buildConcreteSelectQueryPlan(concreteSqmStatements[0], this.getResultType(), this.getQueryOptions());
    }

    private SelectQueryPlan<R> buildAggregatedSelectQueryPlan(SqmSelectStatement[] concreteSqmStatements) {
        SelectQueryPlan[] aggregatedQueryPlans = new SelectQueryPlan[concreteSqmStatements.length];
        int x = concreteSqmStatements.length;
        for (int i = 0; i < x; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteSelectQueryPlan(concreteSqmStatements[i], this.getResultType(), this.getQueryOptions());
        }
        return new AggregatedSelectQueryPlanImpl(aggregatedQueryPlans);
    }

    private SelectQueryPlan<R> buildConcreteSelectQueryPlan(SqmSelectStatement concreteSqmStatement, Class<R> resultType, QueryOptions queryOptions) {
        return new ConcreteSqmSelectQueryPlan<R>(concreteSqmStatement, this.domainParameterXref, resultType, queryOptions);
    }

    @Override
    protected ScrollableResultsImplementor doScroll(ScrollMode scrollMode) {
        SqmUtil.verifyIsSelectStatement(this.getSqmStatement());
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getLockOptions().findGreatestLockMode()));
        return this.resolveSelectQueryPlan().performScroll(scrollMode, this);
    }

    @Override
    protected int doExecuteUpdate() {
        SqmUtil.verifyIsNonSelectStatement(this.getSqmStatement());
        this.getSession().prepareForQueryExecution(true);
        return this.resolveNonSelectQueryPlan().executeUpdate(this);
    }

    private NonSelectQueryPlan resolveNonSelectQueryPlan() {
        NonSelectQueryPlan queryPlan = null;
        QueryPlanCache.Key cacheKey = SqmInterpretationsKey.generateNonSelectKey(this);
        if (cacheKey != null) {
            queryPlan = this.getSession().getFactory().getQueryEngine().getQueryPlanCache().getNonSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            queryPlan = this.buildNonSelectQueryPlan();
            if (cacheKey != null) {
                this.getSession().getFactory().getQueryEngine().getQueryPlanCache().cacheNonSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    private NonSelectQueryPlan buildNonSelectQueryPlan() {
        if (this.getSqmStatement() instanceof SqmDeleteStatement) {
            return this.buildDeleteQueryPlan();
        }
        if (this.getSqmStatement() instanceof SqmUpdateStatement) {
            return this.buildUpdateQueryPlan();
        }
        throw new NotYetImplementedException("Query#executeUpdate not yet implemented");
    }

    private NonSelectQueryPlan buildDeleteQueryPlan() {
        SqmDeleteStatement sqmDelete = (SqmDeleteStatement)this.getSqmStatement();
        EntityTypeDescriptor entityToDelete = sqmDelete.getTarget().getReferencedNavigable().getEntityDescriptor();
        DeleteHandler deleteHandler = entityToDelete.getHierarchy().getSqmMutationStrategy().buildDeleteHandler(sqmDelete, this.domainParameterXref, this::getSessionFactory);
        return new DeleteQueryPlanImpl(sqmDelete, deleteHandler, this);
    }

    private NonSelectQueryPlan buildUpdateQueryPlan() {
        SqmUpdateStatement sqmStatement = (SqmUpdateStatement)this.getSqmStatement();
        EntityTypeDescriptor entityToUpdate = sqmStatement.getTarget().getReferencedNavigable().getEntityDescriptor();
        UpdateHandler updateHandler = entityToUpdate.getHierarchy().getSqmMutationStrategy().buildUpdateHandler(sqmStatement, this.domainParameterXref, this::getSessionFactory);
        return new UpdateQueryPlanImpl(sqmStatement, updateHandler, this);
    }

    @Override
    public DomainParameterBindingContext getDomainParameterBindingContext() {
        return this;
    }

    @Override
    public Callback getCallback() {
        return afterLoadAction -> {};
    }

    @Override
    public <T> List<T> getLoadIdentifiers() {
        return null;
    }

    @Override
    public NamedHqlQueryMemento toMemento(String name, SessionFactoryImplementor factory) {
        return new NamedHqlQueryMementoImpl(name, QuerySqmImpl.toParameterMementos(this.getParameterMetadata()), this.sourceQueryString, this.getFirstResult(), this.getMaxResults(), this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getHibernateFlushMode(), this.isReadOnly(), this.getLockOptions(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    private static List<ParameterMemento> toParameterMementos(ParameterMetadataImplementor<QueryParameterImplementor<?>> parameterMetadata) {
        throw new NotYetImplementedFor6Exception();
    }
}

