/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.sql.ast.consume.spi.SqlDeleteToJdbcDeleteConverter;
import org.hibernate.sql.ast.produce.sqm.spi.SqmDeleteInterpretation;
import org.hibernate.sql.ast.produce.sqm.spi.SqmDeleteToSqlAstConverterSimple;
import org.hibernate.sql.exec.internal.JdbcMutationExecutorImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;

public class SimpleDeleteQueryPlan
implements NonSelectQueryPlan {
    private final SqmDeleteStatement sqmStatement;
    private final DomainParameterXref domainParameterXref;

    public SimpleDeleteQueryPlan(SqmDeleteStatement sqmStatement) {
        this.sqmStatement = sqmStatement;
        this.domainParameterXref = DomainParameterXref.from(sqmStatement);
    }

    @Override
    public int executeUpdate(ExecutionContext executionContext) {
        SqmDeleteInterpretation sqmInterpretation = SqmDeleteToSqlAstConverterSimple.interpret(this.sqmStatement, executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), executionContext.getSession());
        assert (sqmInterpretation.getSqlDeletes().size() == 1);
        JdbcDelete jdbcDelete = SqlDeleteToJdbcDeleteConverter.interpret(sqmInterpretation.getSqlDeletes().get(0), (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        return JdbcMutationExecutorImpl.WITH_AFTER_STATEMENT_CALL.execute(jdbcDelete, QueryHelper.buildJdbcParameterBindings((SqmStatement)this.sqmStatement, sqmInterpretation, executionContext), executionContext);
    }
}

