/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.query.Limit;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryPlanCache;
import org.hibernate.query.sqm.internal.QuerySqmImpl;

public class SqmInterpretationsKey
implements QueryPlanCache.Key {
    private final String query;
    private final Class resultType;
    private final TupleTransformer tupleTransformer;
    private final ResultListTransformer resultListTransformer;

    public static SqmInterpretationsKey generateFrom(QuerySqmImpl query) {
        if (!SqmInterpretationsKey.isCacheable(query)) {
            return null;
        }
        return new SqmInterpretationsKey(query.getQueryString(), query.getResultType(), query.getQueryOptions());
    }

    public static QueryPlanCache.Key generateNonSelectKey(QuerySqmImpl query) {
        return null;
    }

    private static boolean isCacheable(QuerySqmImpl<?> query) {
        if (query.getQueryOptions().getAppliedGraph() != null) {
            return false;
        }
        if (query.getParameterMetadata().hasAnyMatching(QueryParameter::allowsMultiValuedBinding)) {
            return false;
        }
        if (SqmInterpretationsKey.hasLimit(query.getQueryOptions().getLimit())) {
            return false;
        }
        if (SqmInterpretationsKey.definesLocking(query.getQueryOptions().getLockOptions())) {
            return false;
        }
        return !query.getQueryParameterBindings().hasAnyMultiValuedBindings();
    }

    private static boolean hasLimit(Limit limit) {
        return limit.getFirstRow() != null || limit.getMaxRows() != null;
    }

    private static boolean definesLocking(LockOptions lockOptions) {
        LockMode mostRestrictiveLockMode = lockOptions.findGreatestLockMode();
        return mostRestrictiveLockMode.greaterThan(LockMode.READ);
    }

    private SqmInterpretationsKey(String query, Class resultType, QueryOptions queryOptions) {
        this.query = query;
        this.resultType = resultType;
        this.tupleTransformer = queryOptions.getTupleTransformer();
        this.resultListTransformer = queryOptions.getResultListTransformer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqmInterpretationsKey that = (SqmInterpretationsKey)o;
        return this.query.equals(that.query) && this.areEqual(this.resultType, that.resultType) && this.areEqual(this.tupleTransformer, that.tupleTransformer) && this.areEqual(this.resultListTransformer, that.resultListTransformer);
    }

    private <T> boolean areEqual(T o1, T o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result = 31 * result + (this.resultType != null ? this.resultType.hashCode() : 0);
        result = 31 * result + (this.tupleTransformer != null ? this.tupleTransformer.hashCode() : 0);
        result = 31 * result + (this.resultListTransformer != null ? this.resultListTransformer.hashCode() : 0);
        return result;
    }
}

