/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.Locale;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

public class SqmUtil {
    private SqmUtil() {
    }

    public static void verifyIsSelectStatement(SqmStatement sqm) {
        if (!SqmSelectStatement.class.isInstance(sqm)) {
            throw new IllegalQueryOperationException(String.format(Locale.ROOT, "Expecting a SELECT Query [%s], but found %s", SqmSelectStatement.class.getName(), sqm.getClass().getName()));
        }
    }

    public static void verifyIsNonSelectStatement(SqmStatement sqm) {
        if (!SqmDmlStatement.class.isInstance(sqm)) {
            throw new IllegalQueryOperationException(String.format(Locale.ROOT, "Expecting a non-SELECT Query [%s], but found %s", SqmDmlStatement.class.getName(), sqm.getClass().getName()));
        }
    }
}

