/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.sqm.produce.SqmCreationProcessingState;
import org.hibernate.query.sqm.produce.SqmQuerySpecCreationProcessingState;
import org.hibernate.query.sqm.produce.internal.SqmQuerySpecCreationProcessingStateStandardImpl;
import org.hibernate.query.sqm.produce.spi.ImplicitAliasGenerator;
import org.hibernate.query.sqm.produce.spi.SqmCreationContext;
import org.hibernate.query.sqm.produce.spi.SqmCreationOptions;
import org.hibernate.query.sqm.produce.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.jboss.logging.Logger;

public class SqmIdSelectGenerator {
    private static final Logger log = Logger.getLogger(SqmIdSelectGenerator.class);
    private final SqmDeleteOrUpdateStatement sourceSqmStatement;
    private final EntityTypeDescriptor entityDescriptor;
    private final SqmCreationContext creationContext;

    public static SqmQuerySpec generateSqmEntityIdSelect(SqmDeleteOrUpdateStatement sqmStatement, SessionFactoryImplementor sessionFactory) {
        SqmIdSelectGenerator generator = new SqmIdSelectGenerator(sqmStatement, sessionFactory);
        return generator.process();
    }

    public SqmIdSelectGenerator(SqmDeleteOrUpdateStatement sourceSqmStatement, SqmCreationContext creationContext) {
        this.sourceSqmStatement = sourceSqmStatement;
        this.entityDescriptor = sourceSqmStatement.getTarget().getReferencedNavigable();
        this.creationContext = creationContext;
    }

    private SqmQuerySpec process() {
        SqmQuerySpec sqmQuerySpec = new SqmQuerySpec();
        SqmFromClause sqmFromClause = new SqmFromClause();
        sqmQuerySpec.setFromClause(sqmFromClause);
        SqmRoot<Object> sqmRoot = new SqmRoot<Object>(this.entityDescriptor, this.toString());
        sqmFromClause.addRoot(sqmRoot);
        SqmSelectClause sqmSelectClause = new SqmSelectClause(true);
        sqmQuerySpec.setSelectClause(sqmSelectClause);
        this.applySelections(sqmSelectClause, sqmRoot);
        if (this.sourceSqmStatement.getWhereClause() != null) {
            sqmQuerySpec.setWhereClause(new SqmWhereClause(this.sourceSqmStatement.getWhereClause().getPredicate()));
        }
        return sqmQuerySpec;
    }

    private void applySelections(SqmSelectClause sqmSelectClause, SqmRoot<Object> sqmRoot) {
        final StandardStack<SqmQuerySpecCreationProcessingStateStandardImpl> processingStateStack = new StandardStack<SqmQuerySpecCreationProcessingStateStandardImpl>();
        SqmCreationState sqmCreationState = new SqmCreationState(){

            @Override
            public SqmCreationContext getCreationContext() {
                return SqmIdSelectGenerator.this.creationContext;
            }

            @Override
            public SqmCreationOptions getCreationOptions() {
                return () -> false;
            }

            @Override
            public Stack<SqmCreationProcessingState> getProcessingStateStack() {
                return processingStateStack;
            }

            @Override
            public String generateUniqueIdentifier() {
                return null;
            }

            @Override
            public ImplicitAliasGenerator getImplicitAliasGenerator() {
                return null;
            }

            @Override
            public SqmQuerySpecCreationProcessingState getCurrentQuerySpecProcessingState() {
                return (SqmQuerySpecCreationProcessingState)processingStateStack.getCurrent();
            }
        };
        SqmQuerySpecCreationProcessingStateStandardImpl processingState = new SqmQuerySpecCreationProcessingStateStandardImpl(null, sqmCreationState);
        processingStateStack.push(processingState);
        sqmSelectClause.addSelection(new SqmSelection(this.entityDescriptor.getIdentifierDescriptor().createSqmExpression(sqmRoot, sqmCreationState)));
    }
}

