/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.List;
import org.hibernate.boot.model.domain.EntityMappingHierarchy;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityHierarchy;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.consume.internal.SqmConsumeHelper;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.SqmIdSelectGenerator;
import org.hibernate.query.sqm.mutation.spi.DeleteHandler;
import org.hibernate.query.sqm.mutation.spi.HandlerCreationContext;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.UpdateHandler;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.SqmNavigableReference;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.BetweenSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.GroupedSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.InListSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctivePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.consume.spi.SqlAstSelectToJdbcSelectConverter;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.produce.sqm.spi.SqmSelectInterpretation;
import org.hibernate.sql.ast.produce.sqm.spi.SqmSelectToSqlAstConverter;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;

public class SqmMutationStrategyHelper {
    public static final SqmMutationStrategyHelper INSTANCE = new SqmMutationStrategyHelper();

    private SqmMutationStrategyHelper() {
    }

    public static SqmMutationStrategy resolveStrategy(EntityMappingHierarchy bootHierarchyDescriptor, EntityHierarchy entityHierarchy, SessionFactoryOptions options, ServiceRegistry serviceRegistry) {
        if (options.getSqmMutationStrategy() != null) {
            return options.getSqmMutationStrategy();
        }
        return serviceRegistry.getService(JdbcServices.class).getJdbcEnvironment().getDialect().getFallbackSqmMutationStrategy(entityHierarchy);
    }

    public static DeleteHandler resolveDeleteHandler(SqmDeleteStatement sqmDelete, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext, FallbackDeleteHandlerCreator fallbackCreator) {
        if (sqmDelete.getWhereClause() == null || !SqmMutationStrategyHelper.hasNonIdReferences(sqmDelete.getWhereClause().getPredicate())) {
            // empty if block
        }
        return fallbackCreator.create(sqmDelete, domainParameterXref, creationContext);
    }

    public static UpdateHandler resolveUpdateHandler(SqmUpdateStatement sqmUpdate, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext, FallbackUpdateHandlerCreator fallbackCreator) {
        if (sqmUpdate.getWhereClause() == null || !SqmMutationStrategyHelper.hasNonIdReferences(sqmUpdate.getWhereClause().getPredicate())) {
            // empty if block
        }
        return fallbackCreator.create(sqmUpdate, domainParameterXref, creationContext);
    }

    public static boolean hasNonIdReferences(SqmPredicate predicate) {
        if (predicate instanceof GroupedSqmPredicate) {
            return SqmMutationStrategyHelper.hasNonIdReferences(((GroupedSqmPredicate)predicate).getSubPredicate());
        }
        if (predicate instanceof SqmJunctivePredicate) {
            return SqmMutationStrategyHelper.hasNonIdReferences(((SqmJunctivePredicate)predicate).getLeftHandPredicate()) && SqmMutationStrategyHelper.hasNonIdReferences(((SqmJunctivePredicate)predicate).getRightHandPredicate());
        }
        if (predicate instanceof SqmComparisonPredicate) {
            SqmExpression lhs = ((SqmComparisonPredicate)predicate).getLeftHandExpression();
            SqmExpression rhs = ((SqmComparisonPredicate)predicate).getRightHandExpression();
            return SqmMutationStrategyHelper.isNonIdentifierReference(lhs) || SqmMutationStrategyHelper.isNonIdentifierReference(rhs);
        }
        if (predicate instanceof InListSqmPredicate) {
            InListSqmPredicate inPredicate = (InListSqmPredicate)predicate;
            if (SqmMutationStrategyHelper.isNonIdentifierReference(inPredicate.getTestExpression())) {
                return true;
            }
            for (SqmExpression listExpression : inPredicate.getListExpressions()) {
                if (!SqmMutationStrategyHelper.isNonIdentifierReference(listExpression)) continue;
                return true;
            }
            return false;
        }
        if (predicate instanceof BetweenSqmPredicate) {
            BetweenSqmPredicate betweenPredicate = (BetweenSqmPredicate)predicate;
            return SqmMutationStrategyHelper.isNonIdentifierReference(betweenPredicate.getExpression()) || SqmMutationStrategyHelper.isNonIdentifierReference(betweenPredicate.getLowerBound()) || SqmMutationStrategyHelper.isNonIdentifierReference(betweenPredicate.getUpperBound());
        }
        return false;
    }

    public static boolean isNonIdentifierReference(SqmExpression expression) {
        if (expression instanceof SqmNavigableReference) {
            return !EntityIdentifier.class.isInstance(expression);
        }
        return false;
    }

    public static List<Object> selectMatchingIds(DomainParameterXref domainParameterXref, SqmDeleteOrUpdateStatement sqmDeleteStatement, ExecutionContext executionContext) {
        SqmQuerySpec sqmIdSelectQuerySpec = SqmIdSelectGenerator.generateSqmEntityIdSelect(sqmDeleteStatement, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        SqmSelectToSqlAstConverter sqmConverter = new SqmSelectToSqlAstConverter(executionContext.getQueryOptions(), domainParameterXref, executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), executionContext.getLoadQueryInfluencers(), executionContext.getCallback(), (SqlAstCreationContext)((Object)executionContext.getSession().getSessionFactory()));
        SqmSelectStatement sqmIdSelect = new SqmSelectStatement(sqmIdSelectQuerySpec);
        SqmSelectInterpretation sqmSelectInterpretation = sqmConverter.interpret(sqmIdSelect);
        JdbcSelect jdbcSelect = SqlAstSelectToJdbcSelectConverter.interpret(sqmSelectInterpretation, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        return JdbcSelectExecutorStandardImpl.INSTANCE.list(jdbcSelect, QueryHelper.buildJdbcParameterBindings(domainParameterXref, SqmConsumeHelper.generateJdbcParamsXref(domainParameterXref, sqmConverter), executionContext), executionContext, row -> row[0]);
    }

    public static interface FallbackUpdateHandlerCreator {
        public UpdateHandler create(SqmUpdateStatement var1, DomainParameterXref var2, HandlerCreationContext var3);
    }

    public static interface FallbackDeleteHandlerCreator {
        public DeleteHandler create(SqmDeleteStatement var1, DomainParameterXref var2, HandlerCreationContext var3);
    }
}

