/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.cte;

import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.spi.DeleteHandler;
import org.hibernate.query.sqm.mutation.spi.HandlerCreationContext;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.UpdateHandler;
import org.hibernate.query.sqm.mutation.spi.cte.CteDeleteHandlerImpl;
import org.hibernate.query.sqm.mutation.spi.cte.CteTable;
import org.hibernate.query.sqm.mutation.spi.cte.CteUpdateHandlerImpl;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;

public class CteBasedMutationStrategy
implements SqmMutationStrategy {
    public static final String ID_CTE = "id_cte";
    private final EntityTypeDescriptor<?> entityDescriptor;
    private final CteTable cteTable;

    public CteBasedMutationStrategy(EntityTypeDescriptor<?> entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
        Dialect dialect = entityDescriptor.getTypeConfiguration().getSessionFactory().getServiceRegistry().getService(JdbcServices.class).getJdbcEnvironment().getDialect();
        if (!dialect.supportsNonQueryWithCTE()) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used with Dialects that support CTE that can take UPDATE or DELETE statements as well");
        }
        if (!dialect.supportsValuesList()) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used with Dialects that support VALUES lists");
        }
        if (!dialect.supportsRowValueConstructorSyntaxInInList()) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used with Dialects that support IN clause row-value expressions (for composite identifiers)");
        }
        this.cteTable = new CteTable(entityDescriptor);
    }

    public EntityTypeDescriptor<?> getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public CteTable getCteTable() {
        return this.cteTable;
    }

    @Override
    public UpdateHandler buildUpdateHandler(SqmUpdateStatement sqmStatement, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
        this.checkMatch(sqmStatement);
        return new CteUpdateHandlerImpl(sqmStatement, domainParameterXref, this, creationContext);
    }

    private void checkMatch(SqmDeleteOrUpdateStatement sqmStatement) {
        NavigableContainer targetEntity = sqmStatement.getTarget().getReferencedNavigable();
        if (targetEntity != this.entityDescriptor && !this.entityDescriptor.isSubclassTypeName(targetEntity.getEntityName())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Target of query [%s] did not match configured entity [%s]", targetEntity, this.entityDescriptor));
        }
    }

    @Override
    public DeleteHandler buildDeleteHandler(SqmDeleteStatement sqmStatement, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
        this.checkMatch(sqmStatement);
        return new CteDeleteHandlerImpl(sqmStatement, domainParameterXref, this, creationContext);
    }
}

