/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.cte;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.spi.DeleteHandler;
import org.hibernate.query.sqm.mutation.spi.HandlerCreationContext;
import org.hibernate.query.sqm.mutation.spi.cte.AbstractCteMutationHandler;
import org.hibernate.query.sqm.mutation.spi.cte.CteBasedMutationStrategy;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.sql.ast.consume.spi.SqlDeleteToJdbcDeleteConverter;
import org.hibernate.sql.ast.tree.CteStatement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcMutation;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class CteDeleteHandlerImpl
extends AbstractCteMutationHandler
implements DeleteHandler {
    protected CteDeleteHandlerImpl(SqmDeleteStatement sqmDeleteStatement, DomainParameterXref domainParameterXref, CteBasedMutationStrategy strategy, HandlerCreationContext creationContext) {
        super(sqmDeleteStatement, domainParameterXref, strategy, creationContext);
    }

    @Override
    public SqmDeleteStatement getSqmDeleteOrUpdateStatement() {
        return (SqmDeleteStatement)super.getSqmDeleteOrUpdateStatement();
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        List<Object> ids = this.selectMatchingIds(executionContext);
        QuerySpec cteQuerySpec = this.getStrategy().getCteTable().createCteSubQuery(executionContext);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl();
        QuerySpec cteDefinitionQuerySpec = this.getStrategy().getCteTable().createCteDefinition(ids, jdbcParameterBindings, executionContext);
        this.getEntityDescriptor().visitAttributes(attribute -> {
            PluralPersistentAttribute pluralAttribute = (PluralPersistentAttribute)attribute;
            PersistentCollectionDescriptor collectionDescriptor = pluralAttribute.getCollectionDescriptor();
            if (collectionDescriptor.getSeparateCollectionTable() != null) {
                this.executeDelete(cteDefinitionQuerySpec, collectionDescriptor.getSeparateCollectionTable(), collectionDescriptor.getCollectionKeyDescriptor().getJoinForeignKey().getColumnMappings().getReferringColumns(), cteQuerySpec, jdbcParameterBindings, executionContext);
            }
        }, attribute -> attribute instanceof PluralPersistentAttribute);
        this.getEntityDescriptor().getHierarchy().visitConstraintOrderedTables((table, columns) -> this.executeDelete(cteDefinitionQuerySpec, (Table)table, (List<Column>)columns, cteQuerySpec, jdbcParameterBindings, executionContext));
        return ids.size();
    }

    private List<Object> selectMatchingIds(ExecutionContext executionContext) {
        return SqmMutationStrategyHelper.selectMatchingIds(this.getDomainParameterXref(), this.getSqmDeleteOrUpdateStatement(), executionContext);
    }

    protected void executeDelete(QuerySpec cteDefinition, Table targetTable, List<Column> columnsToMatch, QuerySpec cteSubQuery, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        CteStatement cteStatement = this.generateCteStatement(cteDefinition, targetTable, columnsToMatch, cteSubQuery, executionContext);
        JdbcDelete jdbcDelete = SqlDeleteToJdbcDeleteConverter.interpret(cteStatement, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        JdbcMutationExecutor executor = JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL;
        executor.execute((JdbcMutation)jdbcDelete, jdbcParameterBindings, executionContext, (rows, preparedStatement) -> {});
    }

    protected CteStatement generateCteStatement(QuerySpec cteDefinition, Table targetTable, List<Column> columnsToMatch, QuerySpec cteSubQuery, ExecutionContext executionContext) {
        return new CteStatement(cteDefinition, "id_cte", this.getStrategy().getCteTable(), this.generateCteConsumer(targetTable, columnsToMatch, cteSubQuery));
    }

    private DeleteStatement generateCteConsumer(Table targetTable, List<Column> columnsToMatch, QuerySpec cteSubQuery) {
        Expression columnsToMatchExpression;
        TableReference targetTableReference = new TableReference(targetTable, null, false);
        if (columnsToMatch.size() == 1) {
            columnsToMatchExpression = targetTableReference.resolveColumnReference(columnsToMatch.get(0));
        } else {
            ArrayList<ColumnReference> columnsToMatchExpressions = new ArrayList<ColumnReference>();
            for (Column toMatch : columnsToMatch) {
                columnsToMatchExpressions.add(targetTableReference.resolveColumnReference(toMatch));
            }
            columnsToMatchExpression = new SqlTuple(columnsToMatchExpressions, this.getEntityDescriptor().getIdType());
        }
        return new DeleteStatement(targetTableReference, new InSubQueryPredicate(columnsToMatchExpression, cteSubQuery, false));
    }
}

