/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.cte;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.Writeable;
import org.hibernate.metamodel.model.relational.spi.AbstractTable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.DerivedTable;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.mutation.spi.cte.CteTableColumn;
import org.hibernate.query.sqm.mutation.spi.cte.CteTableGroup;
import org.hibernate.query.sqm.mutation.spi.cte.CteTableReference;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.internal.StandardJdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class CteTable
extends AbstractTable {
    private final EntityTypeDescriptor<?> entityDescriptor;

    public CteTable(EntityTypeDescriptor<?> entityDescriptor) {
        super(UUID.randomUUID(), false);
        this.entityDescriptor = entityDescriptor;
        for (Column column : entityDescriptor.getIdentifierDescriptor().getColumns()) {
            CteTableColumn cteTableColumn = new CteTableColumn(this, (PhysicalColumn)column, entityDescriptor.getTypeConfiguration());
            this.addColumn(cteTableColumn);
        }
    }

    @Override
    public String getTableExpression() {
        return "id_cte";
    }

    @Override
    public String render(Dialect dialect, JdbcEnvironment jdbcEnvironment) {
        return this.getTableExpression();
    }

    @Override
    public boolean isExportable() {
        return false;
    }

    @Override
    public String toLoggableFragment() {
        return this.getTableExpression();
    }

    public QuerySpec createCteDefinition(List<?> matchingIds, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        TableReference tableValueConstructorReference = this.createCteDefinitionTableValueCtor(matchingIds, jdbcParameterBindings, executionContext);
        StandardTableGroup tableValueCtorGroup = new StandardTableGroup(new NavigablePath(this.entityDescriptor.getIdentifierDescriptor().getNavigableRole().getFullPath()), this.entityDescriptor.getIdentifierDescriptor(), LockMode.NONE, tableValueConstructorReference, Collections.emptyList());
        querySpec.getFromClause().addRoot(tableValueCtorGroup);
        this.applySelections(querySpec, tableValueConstructorReference);
        return querySpec;
    }

    private TableReference createCteDefinitionTableValueCtor(List<?> matchingIds, final JdbcParameterBindings jdbcParameterBindings, final ExecutionContext executionContext) {
        int numberOfColumns = this.getColumns().size();
        StringBuilder tableValueCtorExpressionBuffer = new StringBuilder("values(");
        String rowSeparator = "";
        int idProcessedCount = 0;
        for (Object matchingId : matchingIds) {
            tableValueCtorExpressionBuffer.append(rowSeparator);
            tableValueCtorExpressionBuffer.append('(');
            StringHelper.repeat("?", numberOfColumns, ",", tableValueCtorExpressionBuffer);
            tableValueCtorExpressionBuffer.append(')');
            final int currentIdPosition = idProcessedCount++;
            this.entityDescriptor.getIdentifierDescriptor().dehydrate(matchingId, new Writeable.JdbcValueCollector(){
                int currentColumnPosition = 0;

                @Override
                public void collect(final Object jdbcValue, final SqlExpressableType type, Column boundColumn) {
                    jdbcParameterBindings.addBinding(new StandardJdbcParameterImpl(currentIdPosition + this.currentColumnPosition++, type, Clause.WHERE, executionContext.getSession().getFactory().getTypeConfiguration()), new JdbcParameterBinding(){

                        @Override
                        public SqlExpressableType getBindType() {
                            return type;
                        }

                        @Override
                        public Object getBindValue() {
                            return jdbcValue;
                        }
                    });
                }
            }, Clause.WHERE, executionContext.getSession());
            rowSeparator = ", ";
        }
        tableValueCtorExpressionBuffer.append(')');
        DerivedTable derivedTable = new DerivedTable(null, tableValueCtorExpressionBuffer.toString(), true);
        return new TableReference(derivedTable, "id_cte", false);
    }

    public QuerySpec createCteSubQuery(ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        CteTableReference cteTableReference = new CteTableReference(this, executionContext);
        CteTableGroup cteTableGroup = new CteTableGroup(this.entityDescriptor, cteTableReference);
        querySpec.getFromClause().addRoot(cteTableGroup);
        this.applySelections(querySpec, cteTableReference);
        return querySpec;
    }

    private void applySelections(QuerySpec querySpec, TableReference tableReference) {
        int i = 0;
        for (Column column : this.getColumns()) {
            querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(i + 1, i, (Expression)tableReference.resolveColumnReference(column), column.getExpressableType()));
        }
    }
}

