/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.cte;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.mutation.spi.cte.CteTableReference;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class CteTableGroup
extends AbstractTableGroup {
    private final CteTableReference cteTableReference;

    public CteTableGroup(EntityTypeDescriptor entityDescriptor, CteTableReference cteTableReference) {
        super(new NavigablePath(entityDescriptor.getEntityName()), entityDescriptor, LockMode.NONE);
        this.cteTableReference = cteTableReference;
    }

    @Override
    public void render(SqlAppender sqlAppender, SqlAstWalker walker) {
        sqlAppender.appendSql(this.cteTableReference.getTable().getTableExpression());
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        nameCollector.accept(this.cteTableReference.getTable().getTableExpression());
    }

    @Override
    public CteTableReference getPrimaryTableReference() {
        return this.cteTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }

    @Override
    public Column resolveColumn(String columnName) {
        return this.cteTableReference.resolveColumn(columnName);
    }
}

