/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.idtable;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.SqmIdSelectGenerator;
import org.hibernate.query.sqm.mutation.spi.AbstractMutationHandler;
import org.hibernate.query.sqm.mutation.spi.HandlerCreationContext;
import org.hibernate.query.sqm.mutation.spi.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableColumn;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableGroup;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableHelper;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableReference;
import org.hibernate.query.sqm.mutation.spi.idtable.SessionUidSupport;
import org.hibernate.query.sqm.produce.internal.SqmTreePrinter;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SqlInsertSelectToJdbcInsertSelectConverter;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.produce.sqm.spi.SqmSelectInterpretation;
import org.hibernate.sql.ast.produce.sqm.spi.SqmSelectToSqlAstConverter;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.LiteralParameter;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcInsertSelect;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.spi.StandardSpiBasicTypes;
import org.jboss.logging.Logger;

public abstract class AbstractTableBasedHandler
extends AbstractMutationHandler {
    private static final Logger log = Logger.getLogger(AbstractTableBasedHandler.class);
    private final IdTable idTableInfo;
    private final SessionUidSupport sessionUidSupport;
    private final BeforeUseAction beforeUseAction;
    private final AfterUseAction afterUseAction;
    private final IdTableHelper tableHelper;
    private final DomainParameterXref domainParameterXref;

    public AbstractTableBasedHandler(SqmDeleteOrUpdateStatement sqmDeleteOrUpdateStatement, IdTable idTableInfo, SessionUidSupport sessionUidSupport, BeforeUseAction beforeUseAction, AfterUseAction afterUseAction, IdTableHelper idTableHelper, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
        super(sqmDeleteOrUpdateStatement, creationContext);
        this.idTableInfo = idTableInfo;
        this.sessionUidSupport = sessionUidSupport;
        this.beforeUseAction = beforeUseAction;
        this.afterUseAction = afterUseAction;
        this.tableHelper = idTableHelper;
        this.domainParameterXref = domainParameterXref;
    }

    public IdTable getIdTableInfo() {
        return this.idTableInfo;
    }

    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    public SessionUidSupport getSessionUidSupport() {
        return this.sessionUidSupport;
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        this.beforeExecution(executionContext);
        try {
            int n = this.performExecution(executionContext);
            return n;
        }
        finally {
            this.afterExecution(executionContext);
        }
    }

    protected void beforeExecution(ExecutionContext executionContext) {
    }

    protected void afterExecution(ExecutionContext executionContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int performExecution(ExecutionContext executionContext) {
        this.performBeforeUseActions(executionContext);
        try {
            int affectedRowCount = this.saveMatchingIdsIntoIdTable(executionContext);
            this.performMutations(executionContext);
            int n = affectedRowCount;
            return n;
        }
        finally {
            this.performAfterUseActions(executionContext);
        }
    }

    private void performBeforeUseActions(ExecutionContext executionContext) {
        if (this.beforeUseAction == BeforeUseAction.CREATE) {
            this.tableHelper.createIdTable(executionContext.getSession());
        }
    }

    private void performAfterUseActions(ExecutionContext executionContext) {
        if (this.afterUseAction == AfterUseAction.DROP) {
            this.tableHelper.dropIdTable(executionContext.getSession());
        } else if (this.afterUseAction == AfterUseAction.CLEAN) {
            this.tableHelper.cleanIdTableRows(executionContext.getSession());
        }
    }

    protected int saveMatchingIdsIntoIdTable(ExecutionContext executionContext) {
        SqmQuerySpec sqmIdSelectQuerySpec = SqmIdSelectGenerator.generateSqmEntityIdSelect(this.getSqmDeleteOrUpdateStatement(), (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        if (this.sessionUidSupport.needsSessionUidColumn()) {
            sqmIdSelectQuerySpec.getSelectClause().addSelection(new SqmSelection(this.generateSessionUidLiteralExpression(executionContext)));
        }
        SqmSelectStatement sqmIdSelect = new SqmSelectStatement(sqmIdSelectQuerySpec);
        SqmTreePrinter.logTree(sqmIdSelect);
        SqmSelectToSqlAstConverter sqmConverter = new SqmSelectToSqlAstConverter(executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), executionContext.getLoadQueryInfluencers(), afterLoadAction -> {}, (SqlAstCreationContext)((Object)executionContext.getSession().getSessionFactory()));
        SqmSelectInterpretation sqlAstInterpretation = sqmConverter.interpret(sqmIdSelect);
        QuerySpec entityIdSelect = sqlAstInterpretation.getSqlAstStatement().getQuerySpec();
        InsertSelectStatement idTableInsertSelect = this.generateIdTableInsertSelect(this.idTableInfo, entityIdSelect);
        JdbcInsertSelect insertSelectCall = SqlInsertSelectToJdbcInsertSelectConverter.interpret(idTableInsertSelect, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        JdbcParameterBindings jdbcParameterBindings = QueryHelper.buildJdbcParameterBindings((SqmStatement)sqmIdSelect, sqlAstInterpretation, executionContext);
        return JdbcMutationExecutor.NO_AFTER_STATEMENT_CALL.execute(insertSelectCall, jdbcParameterBindings, executionContext);
    }

    private SqmLiteral generateSessionUidLiteralExpression(ExecutionContext executionContext) {
        return new SqmLiteral<String>(this.sessionUidSupport.extractUid(executionContext.getSession()), StandardSpiBasicTypes.STRING);
    }

    public QuerySpec createIdTableSubQuery(ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        IdTableReference idTableReference = new IdTableReference(this.getIdTableInfo());
        IdTableGroup cteTableGroup = new IdTableGroup(this.getIdTableInfo().getEntityDescriptor(), idTableReference);
        querySpec.getFromClause().addRoot(cteTableGroup);
        this.applySelections(querySpec, idTableReference, executionContext);
        this.applyRestrictions(querySpec, idTableReference, executionContext);
        return querySpec;
    }

    private void applySelections(QuerySpec querySpec, IdTableReference tableReference, ExecutionContext executionContext) {
        int i = 0;
        for (IdTableColumn column : tableReference.getTable().getIdTableColumns()) {
            if (column == tableReference.getTable().getSessionUidColumn()) continue;
            querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(i + 1, i, (Expression)tableReference.resolveColumnReference(column), column.getSqlTypeDescriptor().getSqlExpressableType(column.getJavaTypeDescriptor(), executionContext.getSession().getFactory().getTypeConfiguration())));
        }
    }

    private void applyRestrictions(QuerySpec querySpec, IdTableReference idTableReference, ExecutionContext executionContext) {
        if (this.sessionUidSupport.needsSessionUidColumn()) {
            querySpec.addRestriction(new ComparisonPredicate(idTableReference.resolveColumnReference(idTableReference.getTable().getSessionUidColumn()), ComparisonOperator.EQUAL, new LiteralParameter(this.sessionUidSupport.extractUid(executionContext.getSession()), StandardSpiBasicTypes.STRING.getSqlExpressableType(), Clause.WHERE, executionContext.getSession().getFactory().getTypeConfiguration())));
        }
    }

    private InsertSelectStatement generateIdTableInsertSelect(IdTable idTableInfo, QuerySpec entityIdSelect) {
        InsertSelectStatement insertSelect = new InsertSelectStatement();
        insertSelect.setTargetTable(new IdTableReference(idTableInfo));
        insertSelect.setSourceSelectStatement(entityIdSelect);
        return insertSelect;
    }

    protected abstract void performMutations(ExecutionContext var1);
}

