/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.idtable;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.Metamodel;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.PhysicalTable;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.QualifiedTableName;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.spi.DeleteHandler;
import org.hibernate.query.sqm.mutation.spi.HandlerCreationContext;
import org.hibernate.query.sqm.mutation.spi.SqmMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.UpdateHandler;
import org.hibernate.query.sqm.mutation.spi.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableColumn;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableManagementTransactionality;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.SessionUidSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.TableBasedDeleteHandlerImpl;
import org.hibernate.query.sqm.mutation.spi.idtable.TableBasedUpdateHandlerImpl;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;

public abstract class AbstractTableBasedMutationStrategy
implements SqmMutationStrategy {
    private final Map<EntityTypeDescriptor, IdTable> idTableInfoMap = new HashMap<EntityTypeDescriptor, IdTable>();

    protected abstract IdTableSupport getIdTableSupport();

    @Override
    public void prepare(Metamodel runtimeMetadata, SessionFactoryOptions sessionFactoryOptions, JdbcConnectionAccess connectionAccess) {
        runtimeMetadata.visitEntityDescriptors(entityDescriptor -> this.generateIdTableDefinition((EntityTypeDescriptor)entityDescriptor, sessionFactoryOptions, connectionAccess));
    }

    protected IdTable getIdTableInfo(EntityTypeDescriptor entityDescriptor) {
        return this.idTableInfoMap.get(entityDescriptor);
    }

    protected IdTable generateIdTableDefinition(EntityTypeDescriptor entityDescriptor, SessionFactoryOptions sessionFactoryOptions, JdbcConnectionAccess connectionAccess) {
        IdTable idTable = new IdTable(entityDescriptor, this.determineIdTableName(entityDescriptor, sessionFactoryOptions));
        entityDescriptor.getPrimaryTable().getPrimaryKey().getColumns().forEach(column -> idTable.addColumn(new IdTableColumn(idTable, (PhysicalColumn)column)));
        if (this.getSessionUidSupport() != null && this.getSessionUidSupport().needsSessionUidColumn()) {
            this.getSessionUidSupport().addColumn(idTable);
        }
        this.idTableInfoMap.put(entityDescriptor, idTable);
        return idTable;
    }

    protected QualifiedTableName determineIdTableName(EntityTypeDescriptor entityDescriptor, SessionFactoryOptions sessionFactoryOptions) {
        Identifier schemaToUse;
        Identifier catalogToUse;
        Identifier entityTableCatalog = entityDescriptor.getPrimaryTable() instanceof PhysicalTable ? ((PhysicalTable)entityDescriptor.getPrimaryTable()).getCatalogName() : null;
        Identifier entityTableSchema = entityDescriptor.getPrimaryTable() instanceof PhysicalTable ? ((PhysicalTable)entityDescriptor.getPrimaryTable()).getSchemaName() : null;
        switch (this.getNamespaceHandling()) {
            case USE_NONE: {
                catalogToUse = null;
                schemaToUse = null;
                break;
            }
            case USE_ENTITY_TABLE_NAMESPACE: {
                catalogToUse = entityTableCatalog;
                schemaToUse = entityTableSchema;
                break;
            }
            case PREFER_SETTINGS: {
                Identifier configuredCatalog = this.getConfiguredCatalog();
                Identifier configuredSchema = this.getConfiguredSchema();
                catalogToUse = configuredCatalog == null ? entityTableCatalog : configuredCatalog;
                schemaToUse = configuredSchema == null ? entityTableSchema : configuredSchema;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown NamespaceHandling value [%s] - expecting %s, %s or %s", this.getNamespaceHandling().name(), NamespaceHandling.USE_NONE.name(), NamespaceHandling.USE_ENTITY_TABLE_NAMESPACE.name(), NamespaceHandling.PREFER_SETTINGS.name()));
            }
        }
        return new QualifiedTableName(catalogToUse, schemaToUse, this.getIdTableSupport().determineIdTableName(entityDescriptor, sessionFactoryOptions));
    }

    protected Identifier getConfiguredCatalog() {
        return null;
    }

    protected Identifier getConfiguredSchema() {
        return null;
    }

    protected NamespaceHandling getNamespaceHandling() {
        return NamespaceHandling.USE_ENTITY_TABLE_NAMESPACE;
    }

    protected SessionUidSupport getSessionUidSupport() {
        return null;
    }

    public BeforeUseAction getBeforeUseAction() {
        return null;
    }

    public AfterUseAction getAfterUseAction() {
        return null;
    }

    public IdTableManagementTransactionality getTableManagementTransactionality() {
        return null;
    }

    @Override
    public void release(Metamodel runtimeMetadata, JdbcConnectionAccess connectionAccess) {
        this.idTableInfoMap.clear();
    }

    @Override
    public UpdateHandler buildUpdateHandler(SqmUpdateStatement sqmUpdateStatement, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
        return SqmMutationStrategyHelper.resolveUpdateHandler(sqmUpdateStatement, domainParameterXref, creationContext, this::buildFallbackUpdateHandler);
    }

    private UpdateHandler buildFallbackUpdateHandler(SqmUpdateStatement sqmUpdateStatement, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
        SessionUidSupport sessionUidSupport;
        EntityTypeDescriptor entityDescriptor = sqmUpdateStatement.getTarget().getReferencedNavigable().getEntityDescriptor();
        TableBasedUpdateHandlerImpl.Builder builder = new TableBasedUpdateHandlerImpl.Builder(sqmUpdateStatement, this.idTableInfoMap.get(entityDescriptor), this.getIdTableSupport());
        if (this.getBeforeUseAction() != null) {
            builder.setBeforeUseAction(this.getBeforeUseAction());
        }
        if (this.getAfterUseAction() != null) {
            builder.setAfterUseAction(this.getAfterUseAction());
        }
        if (this.getTableManagementTransactionality() != null) {
            builder.setTransactionality(this.getTableManagementTransactionality());
        }
        if ((sessionUidSupport = this.getSessionUidSupport()) != null) {
            builder.setSessionUidSupport(sessionUidSupport);
        }
        return builder.build(domainParameterXref, creationContext);
    }

    @Override
    public DeleteHandler buildDeleteHandler(SqmDeleteStatement sqmDelete, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
        return SqmMutationStrategyHelper.resolveDeleteHandler(sqmDelete, domainParameterXref, creationContext, this::buildFallbackDeleteHandler);
    }

    private DeleteHandler buildFallbackDeleteHandler(SqmDeleteStatement sqmDelete, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
        SessionUidSupport sessionUidSupport;
        EntityTypeDescriptor entityDescriptor = sqmDelete.getTarget().getReferencedNavigable().getEntityDescriptor();
        TableBasedDeleteHandlerImpl.Builder builder = new TableBasedDeleteHandlerImpl.Builder(sqmDelete, this.idTableInfoMap.get(entityDescriptor), this.getIdTableSupport());
        if (this.getBeforeUseAction() != null) {
            builder.setBeforeUseAction(this.getBeforeUseAction());
        }
        if (this.getAfterUseAction() != null) {
            builder.setAfterUseAction(this.getAfterUseAction());
        }
        if (this.getTableManagementTransactionality() != null) {
            builder.setTransactionality(this.getTableManagementTransactionality());
        }
        if ((sessionUidSupport = this.getSessionUidSupport()) != null) {
            builder.setSessionUidSupport(sessionUidSupport);
        }
        return builder.build(creationContext, domainParameterXref);
    }

    public static enum NamespaceHandling {
        USE_NONE,
        USE_ENTITY_TABLE_NAMESPACE,
        PREFER_SETTINGS;

    }
}

