/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.idtable;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Metamodel;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.sqm.mutation.spi.idtable.AbstractTableBasedMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.GlobalTempTableExporter;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableHelper;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableManagementTransactionality;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.tool.schema.spi.Exporter;

public class GlobalTemporaryTableStrategy
extends AbstractTableBasedMutationStrategy {
    public static final String DROP_ID_TABLES = "hibernate.hql.bulk_id_strategy.global_temporary.drop_tables";
    public static final String SHORT_NAME = "global_temporary";
    private final IdTableSupport idTableSupport;
    private IdTableManagementTransactionality transactionality;
    private List<IdTableHelper> idTableHelpers;

    public GlobalTemporaryTableStrategy() {
        this(GlobalTemporaryTableStrategy.generateStandardExporter());
    }

    private static Exporter<IdTable> generateStandardExporter() {
        return new GlobalTempTableExporter();
    }

    public GlobalTemporaryTableStrategy(Exporter<IdTable> exporter) {
        this(new StandardIdTableSupport(exporter));
    }

    public GlobalTemporaryTableStrategy(IdTableSupport idTableSupport) {
        this.idTableSupport = idTableSupport;
    }

    @Override
    protected IdTableSupport getIdTableSupport() {
        return this.idTableSupport;
    }

    @Override
    protected AbstractTableBasedMutationStrategy.NamespaceHandling getNamespaceHandling() {
        return AbstractTableBasedMutationStrategy.NamespaceHandling.USE_NONE;
    }

    @Override
    public void prepare(Metamodel runtimeMetadata, SessionFactoryOptions sessionFactoryOptions, JdbcConnectionAccess connectionAccess) {
        StandardServiceRegistry serviceRegistry = sessionFactoryOptions.getServiceRegistry();
        ConfigurationService configService = serviceRegistry.getService(ConfigurationService.class);
        boolean dropIdTables = configService.getSetting(DROP_ID_TABLES, StandardConverters.BOOLEAN, Boolean.valueOf(false));
        if (dropIdTables) {
            this.idTableHelpers = new ArrayList<IdTableHelper>();
        }
        switch (sessionFactoryOptions.getTempTableDdlTransactionHandling()) {
            case ISOLATE: {
                this.transactionality = IdTableManagementTransactionality.ISOLATE;
                break;
            }
            case ISOLATE_AND_TRANSACT: {
                this.transactionality = IdTableManagementTransactionality.ISOLATE_AND_TRANSACT;
                break;
            }
        }
        super.prepare(runtimeMetadata, sessionFactoryOptions, connectionAccess);
    }

    @Override
    protected IdTable generateIdTableDefinition(EntityTypeDescriptor entityDescriptor, SessionFactoryOptions sessionFactoryOptions, JdbcConnectionAccess connectionAccess) {
        IdTable idTable = super.generateIdTableDefinition(entityDescriptor, sessionFactoryOptions, connectionAccess);
        IdTableHelper idTableHelper = new IdTableHelper(idTable, this.getIdTableSupport(), this.transactionality, sessionFactoryOptions.getServiceRegistry().getService(JdbcServices.class));
        idTableHelper.createIdTable(connectionAccess);
        if (this.idTableHelpers != null) {
            this.idTableHelpers.add(idTableHelper);
        }
        return idTable;
    }

    @Override
    public BeforeUseAction getBeforeUseAction() {
        return BeforeUseAction.NONE;
    }

    @Override
    public AfterUseAction getAfterUseAction() {
        return AfterUseAction.CLEAN;
    }

    @Override
    public IdTableManagementTransactionality getTableManagementTransactionality() {
        return this.transactionality;
    }

    @Override
    public void release(Metamodel runtimeMetadata, JdbcConnectionAccess connectionAccess) {
        if (this.idTableHelpers != null) {
            for (IdTableHelper idTableHelper : this.idTableHelpers) {
                idTableHelper.dropIdTable(connectionAccess);
            }
        }
        super.release(runtimeMetadata, connectionAccess);
    }
}

