/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.idtable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.relational.spi.ExportableTable;
import org.hibernate.metamodel.model.relational.spi.ForeignKey;
import org.hibernate.metamodel.model.relational.spi.Index;
import org.hibernate.metamodel.model.relational.spi.PrimaryKey;
import org.hibernate.metamodel.model.relational.spi.UniqueKey;
import org.hibernate.naming.Identifier;
import org.hibernate.naming.QualifiedTableName;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableColumn;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSessionUidColumn;

public class IdTable
implements ExportableTable {
    private final EntityTypeDescriptor entityDescriptor;
    private final QualifiedTableName qualifiedName;
    private final UUID uuid = UUID.randomUUID();
    private IdTableSessionUidColumn sessionUidColumn;
    private final List<IdTableColumn> columns = new ArrayList<IdTableColumn>();

    public IdTable(EntityTypeDescriptor entityDescriptor, QualifiedTableName physicalQualifiedName) {
        this.entityDescriptor = entityDescriptor;
        this.qualifiedName = physicalQualifiedName;
    }

    public EntityTypeDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public List<IdTableColumn> getIdTableColumns() {
        return this.columns;
    }

    public IdTableSessionUidColumn getSessionUidColumn() {
        return this.sessionUidColumn;
    }

    @Override
    public String getTableExpression() {
        return this.getQualifiedTableName().getTableName().getText();
    }

    @Override
    public String render(Dialect dialect, JdbcEnvironment jdbcEnvironment) {
        return jdbcEnvironment.getQualifiedObjectNameFormatter().format(this.getQualifiedTableName(), dialect);
    }

    public Collection getColumns() {
        return this.columns;
    }

    @Override
    public IdTableColumn getColumn(String name) {
        for (IdTableColumn column : this.columns) {
            if (!column.getName().getText().equalsIgnoreCase(name)) continue;
            return column;
        }
        return null;
    }

    public void addColumn(IdTableColumn column) {
        this.columns.add(column);
        if (column instanceof IdTableSessionUidColumn) {
            this.sessionUidColumn = (IdTableSessionUidColumn)column;
        }
    }

    @Override
    public UUID getUid() {
        return this.uuid;
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return null;
    }

    @Override
    public boolean hasPrimaryKey() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public Collection<ForeignKey> getForeignKeys() {
        return Collections.emptyList();
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    public Identifier getCatalogName() {
        return this.getQualifiedTableName().getCatalogName();
    }

    @Override
    public Identifier getSchemaName() {
        return this.getQualifiedTableName().getSchemaName();
    }

    @Override
    public Identifier getTableName() {
        return this.getQualifiedTableName().getTableName();
    }

    @Override
    public QualifiedTableName getQualifiedTableName() {
        return this.qualifiedName;
    }

    public Collection getPhysicalColumns() {
        return this.columns;
    }

    @Override
    public Collection<UniqueKey> getUniqueKeys() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getCheckConstraints() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Index> getIndexes() {
        return Collections.emptyList();
    }

    @Override
    public boolean isPrimaryKeyIdentity() {
        return false;
    }

    @Override
    public Collection<InitCommand> getInitCommands() {
        return Collections.emptyList();
    }

    @Override
    public String toLoggableFragment() {
        return this.getTableExpression();
    }

    @Override
    public String getExportIdentifier() {
        return this.getQualifiedTableName().render();
    }

    @Override
    public String getComment() {
        return "Table used to temporarily hold id values for the entity " + this.entityDescriptor.getEntityName();
    }
}

