/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.idtable;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableColumn;
import org.hibernate.tool.schema.spi.Exporter;

public class IdTableExporterImpl
implements Exporter<IdTable> {
    protected String getCreateCommand() {
        return "create table";
    }

    protected String getCreateOptions() {
        return null;
    }

    protected String getDropCommand() {
        return "drop table";
    }

    protected String getTruncateIdTableCommand() {
        return "delete from";
    }

    @Override
    public String[] getSqlCreateStrings(IdTable exportable, JdbcServices jdbcServices) {
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        StringBuilder buffer = new StringBuilder(this.getCreateCommand()).append(' ');
        buffer.append(this.determineIdTableNameForCreate(exportable, jdbcServices));
        buffer.append('(');
        boolean firstPass = true;
        for (IdTableColumn column : exportable.getIdTableColumns()) {
            if (firstPass) {
                firstPass = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(column.getName().render(dialect)).append(' ');
            buffer.append(column.getSqlTypeName());
            buffer.append(" not null");
        }
        buffer.append(") ");
        String createOptions = this.getCreateOptions();
        if (createOptions != null) {
            buffer.append(createOptions);
        }
        return new String[]{buffer.toString()};
    }

    protected String determineIdTableNameForCreate(IdTable exportable, JdbcServices jdbcServices) {
        return this.determineIdTableName(exportable, jdbcServices);
    }

    protected String determineIdTableName(IdTable exportable, JdbcServices jdbcServices) {
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        return jdbcEnvironment.getQualifiedObjectNameFormatter().format(exportable.getQualifiedTableName(), dialect);
    }

    @Override
    public String[] getSqlDropStrings(IdTable exportable, JdbcServices jdbcServices) {
        return new String[]{this.getDropCommand() + ' ' + this.determineIdTableNameForDrop(exportable, jdbcServices)};
    }

    private String determineIdTableNameForDrop(IdTable exportable, JdbcServices jdbcServices) {
        return this.determineIdTableName(exportable, jdbcServices);
    }
}

