/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.idtable;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.AbstractWork;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableExporterImpl;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableManagementTransactionality;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;

public class IdTableHelper {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(IdTableHelper.class);
    private final IdTable idTableInfo;
    private final IdTableSupport idTableSupport;
    private final IdTableManagementTransactionality transactionality;
    private final JdbcServices jdbcServices;
    private final String[] creationCommands;
    private final String[] dropCommands;
    private static SqlExceptionHelper.WarningHandler WARNING_HANDLER = new SqlExceptionHelper.WarningHandlerLoggingSupport(){

        @Override
        public boolean doProcess() {
            return log.isDebugEnabled();
        }

        @Override
        public void prepare(SQLWarning warning) {
            log.warningsCreatingTempTable(warning);
        }

        @Override
        protected void logWarning(String description, String message) {
            log.debug(description);
            log.debug(message);
        }
    };

    public IdTableHelper(IdTable idTableInfo, IdTableSupport idTableSupport, IdTableManagementTransactionality transactionality, JdbcServices jdbcServices) {
        this.idTableInfo = idTableInfo;
        this.idTableSupport = idTableSupport;
        this.transactionality = idTableSupport.geIdTableManagementTransactionality() != null ? idTableSupport.geIdTableManagementTransactionality() : transactionality;
        this.jdbcServices = jdbcServices;
        this.creationCommands = IdTableHelper.generateIdTableCreationCommands(idTableInfo, idTableSupport, jdbcServices);
        this.dropCommands = IdTableHelper.generateIdTableDropCommands(idTableInfo, idTableSupport, jdbcServices);
    }

    private static String[] generateIdTableCreationCommands(IdTable idTableInfo, IdTableSupport idTableSupport, JdbcServices jdbcServices) {
        return idTableSupport.getIdTableExporter().getSqlCreateStrings(idTableInfo, jdbcServices);
    }

    private static String[] generateIdTableDropCommands(IdTable idTableInfo, IdTableSupport idTableSupport, JdbcServices jdbcServices) {
        return idTableSupport.getIdTableExporter().getSqlDropStrings(idTableInfo, jdbcServices);
    }

    public void createIdTable(SharedSessionContractImplementor session) {
        this.executeWork(new IdTableCreationWork(), session);
    }

    private void executeWork(AbstractWork work, SharedSessionContractImplementor session) {
        if (this.transactionality == IdTableManagementTransactionality.NONE) {
            try {
                work.execute(session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection());
            }
            catch (SQLException e) {
                log.error("Unable to use JDBC Connection to create perform id table management", e);
            }
        } else {
            session.getTransactionCoordinator().createIsolationDelegate().delegateWork(work, this.transactionality == IdTableManagementTransactionality.ISOLATE_AND_TRANSACT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIdTable(JdbcConnectionAccess jdbcConnectionAccess) {
        IdTableCreationWork work = new IdTableCreationWork();
        if (this.transactionality != IdTableManagementTransactionality.NONE) {
            log.debugf("IdTableManagementTransactionality#%s was requested but not supported, skipping transactionality", new Object[0]);
        }
        try {
            Connection connection = jdbcConnectionAccess.obtainConnection();
            try {
                work.execute(connection);
            }
            finally {
                try {
                    jdbcConnectionAccess.releaseConnection(connection);
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException e) {
            throw this.jdbcServices.getSqlExceptionHelper().convert(e, "Unable to obtain JDBC Connection for id-table [" + this.idTableInfo.getQualifiedTableName().render() + "]");
        }
    }

    public void dropIdTable(SharedSessionContractImplementor session) {
        IdTableDropWork work = new IdTableDropWork();
        if (this.transactionality == IdTableManagementTransactionality.NONE) {
            Connection connection = session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
            work.execute(connection);
            session.getJdbcCoordinator().afterStatementExecution();
        } else {
            session.getTransactionCoordinator().createIsolationDelegate().delegateWork(work, this.transactionality == IdTableManagementTransactionality.ISOLATE_AND_TRANSACT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIdTable(JdbcConnectionAccess jdbcConnectionAccess) {
        if (this.transactionality != IdTableManagementTransactionality.NONE) {
            log.debugf("IdTableManagementTransactionality#%s was requested but not supported, skipping transactionality", new Object[0]);
        }
        IdTableDropWork work = new IdTableDropWork();
        try {
            Connection connection = jdbcConnectionAccess.obtainConnection();
            try {
                work.execute(connection);
            }
            finally {
                try {
                    jdbcConnectionAccess.releaseConnection(connection);
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException e) {
            throw this.jdbcServices.getSqlExceptionHelper().convert(e, "Unable to obtain JDBC Connection for id-table [" + this.idTableInfo.getQualifiedTableName().render() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanIdTableRows(SharedSessionContractImplementor session) {
        JdbcServices jdbcServices = session.getJdbcServices();
        PreparedStatement ps = null;
        try {
            String tableName22 = jdbcServices.getJdbcEnvironment().getQualifiedObjectNameFormatter().format(this.idTableInfo.getQualifiedTableName(), jdbcServices.getJdbcEnvironment().getDialect());
            String sql = ((IdTableExporterImpl)this.idTableSupport.getIdTableExporter()).getTruncateIdTableCommand() + " " + tableName22;
            ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql, false);
            session.getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
            if (ps == null) return;
        }
        catch (Throwable t) {
            try {
                log.unableToCleanupTemporaryIdTable(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (ps != null) {
                    try {
                        session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(ps);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(ps);
            return;
        }
        catch (Throwable tableName22) {
            return;
        }
    }

    private void logStatement(String sql) {
        SqlStatementLogger statementLogger = this.jdbcServices.getSqlStatementLogger();
        statementLogger.logStatement(sql, FormatStyle.BASIC.getFormatter());
    }

    private class IdTableDropWork
    extends AbstractWork {
        private IdTableDropWork() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Connection connection) {
            try {
                Statement statement = connection.createStatement();
                for (String dropCommand : IdTableHelper.this.dropCommands) {
                    try {
                        IdTableHelper.this.logStatement(dropCommand);
                        statement.executeUpdate(dropCommand);
                        IdTableHelper.this.jdbcServices.getSqlExceptionHelper().handleAndClearWarnings(statement, WARNING_HANDLER);
                    }
                    finally {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Exception e) {
                log.warn("unable to drop temporary id table afterQuery use [" + e.getMessage() + "]");
            }
        }
    }

    private class IdTableCreationWork
    extends AbstractWork {
        private IdTableCreationWork() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Connection connection) {
            try {
                Statement statement = connection.createStatement();
                for (String creationCommand : IdTableHelper.this.creationCommands) {
                    try {
                        IdTableHelper.this.logStatement(creationCommand);
                        statement.executeUpdate(creationCommand);
                        IdTableHelper.this.jdbcServices.getSqlExceptionHelper().handleAndClearWarnings(statement, WARNING_HANDLER);
                    }
                    catch (SQLException e) {
                        log.debugf("unable to create id table [%s]; `%s` failed : %s", IdTableHelper.this.idTableInfo.getQualifiedTableName().render(), creationCommand, e.getMessage());
                    }
                    finally {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Exception e) {
                log.debugf("Error creating id table(s) : %s", e.getMessage());
            }
        }
    }
}

