/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.idtable;

import org.hibernate.Metamodel;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.query.sqm.mutation.spi.idtable.AbstractTableBasedMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableExporterImpl;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableManagementTransactionality;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.tool.schema.spi.Exporter;

public class LocalTemporaryTableStrategy
extends AbstractTableBasedMutationStrategy {
    public static final String SHORT_NAME = "local_temporary";
    private final IdTableSupport idTableSupport;
    private IdTableManagementTransactionality transactionality;

    public LocalTemporaryTableStrategy() {
        this(LocalTemporaryTableStrategy.generateStandardIdTableSupport());
    }

    private static StandardIdTableSupport generateStandardIdTableSupport() {
        return new StandardIdTableSupport(LocalTemporaryTableStrategy.generateStandardExporter());
    }

    private static Exporter<IdTable> generateStandardExporter() {
        return new IdTableExporterImpl(){

            @Override
            protected String getCreateCommand() {
                return "create local temporary table";
            }
        };
    }

    public LocalTemporaryTableStrategy(IdTableSupport idTableSupport) {
        this(idTableSupport, null);
    }

    public LocalTemporaryTableStrategy(IdTableManagementTransactionality transactionality) {
        this(LocalTemporaryTableStrategy.generateStandardIdTableSupport(), transactionality);
    }

    public LocalTemporaryTableStrategy(IdTableSupport idTableSupport, IdTableManagementTransactionality transactionality) {
        this.idTableSupport = idTableSupport;
        this.transactionality = transactionality;
    }

    @Override
    protected IdTableSupport getIdTableSupport() {
        return this.idTableSupport;
    }

    @Override
    public BeforeUseAction getBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    @Override
    public AfterUseAction getAfterUseAction() {
        return AfterUseAction.DROP;
    }

    @Override
    public IdTableManagementTransactionality getTableManagementTransactionality() {
        return this.transactionality;
    }

    @Override
    public void prepare(Metamodel runtimeMetadata, SessionFactoryOptions sessionFactoryOptions, JdbcConnectionAccess connectionAccess) {
        super.prepare(runtimeMetadata, sessionFactoryOptions, connectionAccess);
        if (this.transactionality == null) {
            switch (sessionFactoryOptions.getTempTableDdlTransactionHandling()) {
                case ISOLATE: {
                    this.transactionality = IdTableManagementTransactionality.ISOLATE;
                }
                case ISOLATE_AND_TRANSACT: {
                    this.transactionality = IdTableManagementTransactionality.ISOLATE_AND_TRANSACT;
                }
            }
        }
    }

    @Override
    protected AbstractTableBasedMutationStrategy.NamespaceHandling getNamespaceHandling() {
        return AbstractTableBasedMutationStrategy.NamespaceHandling.USE_NONE;
    }
}

