/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.idtable;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Metamodel;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.naming.Identifier;
import org.hibernate.query.sqm.mutation.spi.idtable.AbstractTableBasedMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableHelper;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableManagementTransactionality;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.PersistentTableSessionUidSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.SessionUidSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.StandardIdTableSupport;
import org.hibernate.tool.schema.spi.Exporter;

public class PersistentTableStrategy
extends AbstractTableBasedMutationStrategy {
    public static final String SHORT_NAME = "persistent";
    public static final String DROP_ID_TABLES = "hibernate.hql.bulk_id_strategy.persistent.drop_tables";
    public static final String SCHEMA = "hibernate.hql.bulk_id_strategy.persistent.schema";
    public static final String CATALOG = "hibernate.hql.bulk_id_strategy.persistent.catalog";
    private final SessionUidSupport sessionUidSupport = new PersistentTableSessionUidSupport();
    private final IdTableSupport idTableSupport;
    private Identifier configuredCatalog;
    private Identifier configuredSchema;
    private List<IdTableHelper> idTableHelpers;

    public PersistentTableStrategy(Exporter<IdTable> exporter) {
        this(new StandardIdTableSupport(exporter));
    }

    public PersistentTableStrategy(IdTableSupport idTableSupport) {
        this.idTableSupport = idTableSupport;
    }

    @Override
    protected SessionUidSupport getSessionUidSupport() {
        return this.sessionUidSupport;
    }

    @Override
    protected IdTableSupport getIdTableSupport() {
        return this.idTableSupport;
    }

    @Override
    public AfterUseAction getAfterUseAction() {
        return AfterUseAction.CLEAN;
    }

    @Override
    public void prepare(Metamodel runtimeMetadata, SessionFactoryOptions sessionFactoryOptions, JdbcConnectionAccess connectionAccess) {
        StandardServiceRegistry serviceRegistry = sessionFactoryOptions.getServiceRegistry();
        JdbcEnvironment jdbcEnvironment = serviceRegistry.getService(JdbcEnvironment.class);
        ConfigurationService configService = serviceRegistry.getService(ConfigurationService.class);
        String catalogName = configService.getSetting(CATALOG, StandardConverters.STRING, configService.getSetting("hibernate.default_catalog", StandardConverters.STRING));
        String schemaName = configService.getSetting(SCHEMA, StandardConverters.STRING, configService.getSetting("hibernate.default_schema", StandardConverters.STRING));
        this.configuredCatalog = jdbcEnvironment.getIdentifierHelper().toIdentifier(catalogName);
        this.configuredSchema = jdbcEnvironment.getIdentifierHelper().toIdentifier(schemaName);
        boolean dropIdTables = configService.getSetting(DROP_ID_TABLES, StandardConverters.BOOLEAN, Boolean.valueOf(false));
        if (dropIdTables) {
            this.idTableHelpers = new ArrayList<IdTableHelper>();
        }
        super.prepare(runtimeMetadata, sessionFactoryOptions, connectionAccess);
    }

    @Override
    protected IdTable generateIdTableDefinition(EntityTypeDescriptor entityDescriptor, SessionFactoryOptions sessionFactoryOptions, JdbcConnectionAccess connectionAccess) {
        IdTableManagementTransactionality transactionality;
        IdTable idTable = super.generateIdTableDefinition(entityDescriptor, sessionFactoryOptions, connectionAccess);
        switch (sessionFactoryOptions.getTempTableDdlTransactionHandling()) {
            case ISOLATE: {
                transactionality = IdTableManagementTransactionality.ISOLATE;
                break;
            }
            case ISOLATE_AND_TRANSACT: {
                transactionality = IdTableManagementTransactionality.ISOLATE_AND_TRANSACT;
                break;
            }
            default: {
                transactionality = IdTableManagementTransactionality.NONE;
            }
        }
        IdTableHelper idTableHelper = new IdTableHelper(idTable, this.getIdTableSupport(), transactionality, sessionFactoryOptions.getServiceRegistry().getService(JdbcServices.class));
        idTableHelper.createIdTable(connectionAccess);
        if (this.idTableHelpers != null) {
            this.idTableHelpers.add(idTableHelper);
        }
        return idTable;
    }

    @Override
    protected AbstractTableBasedMutationStrategy.NamespaceHandling getNamespaceHandling() {
        return AbstractTableBasedMutationStrategy.NamespaceHandling.PREFER_SETTINGS;
    }

    @Override
    protected Identifier getConfiguredCatalog() {
        return this.configuredCatalog;
    }

    @Override
    protected Identifier getConfiguredSchema() {
        return this.configuredSchema;
    }

    @Override
    public void release(Metamodel runtimeMetadata, JdbcConnectionAccess connectionAccess) {
        if (this.idTableHelpers != null) {
            for (IdTableHelper idTableHelper : this.idTableHelpers) {
                idTableHelper.dropIdTable(connectionAccess);
            }
        }
        super.release(runtimeMetadata, connectionAccess);
    }
}

