/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.idtable;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.relational.spi.PhysicalTable;
import org.hibernate.naming.Identifier;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableManagementTransactionality;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.tool.schema.spi.Exporter;

public class StandardIdTableSupport
implements IdTableSupport {
    private final Exporter<IdTable> idTableExporter;
    private IdTableManagementTransactionality tableManagementTransactionality;

    public StandardIdTableSupport(Exporter<IdTable> idTableExporter) {
        this.idTableExporter = idTableExporter;
    }

    public StandardIdTableSupport(Exporter<IdTable> idTableExporter, IdTableManagementTransactionality tableManagementTransactionality) {
        this(idTableExporter);
        this.tableManagementTransactionality = tableManagementTransactionality;
    }

    @Override
    public Identifier determineIdTableName(EntityTypeDescriptor entityDescriptor, SessionFactoryOptions sessionFactoryOptions) {
        return this.determineIdTableName(entityDescriptor);
    }

    protected Identifier determineIdTableName(EntityTypeDescriptor entityDescriptor) {
        Identifier idTableNameBase = this.determineIdTableNameBase(entityDescriptor);
        return this.determineIdTableName(idTableNameBase);
    }

    private Identifier determineIdTableNameBase(EntityTypeDescriptor entityDescriptor) {
        if (entityDescriptor.getPrimaryTable() instanceof PhysicalTable) {
            return ((PhysicalTable)entityDescriptor.getPrimaryTable()).getTableName();
        }
        return Identifier.toIdentifier(entityDescriptor.getJpaEntityName());
    }

    protected Identifier determineIdTableName(Identifier baseName) {
        return new Identifier("HT_" + baseName.getText(), false);
    }

    @Override
    public Exporter<IdTable> getIdTableExporter() {
        return this.idTableExporter;
    }

    @Override
    public IdTableManagementTransactionality geIdTableManagementTransactionality() {
        return this.tableManagementTransactionality;
    }
}

