/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.idtable;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.spi.HandlerCreationContext;
import org.hibernate.query.sqm.mutation.spi.UpdateHandler;
import org.hibernate.query.sqm.mutation.spi.idtable.AbstractTableBasedHandler;
import org.hibernate.query.sqm.mutation.spi.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTable;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableHelper;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableManagementTransactionality;
import org.hibernate.query.sqm.mutation.spi.idtable.IdTableSupport;
import org.hibernate.query.sqm.mutation.spi.idtable.SessionUidSupport;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.consume.spi.UpdateToJdbcUpdateConverter;
import org.hibernate.sql.ast.produce.sqm.spi.SqmUpdateInterpretation;
import org.hibernate.sql.ast.produce.sqm.spi.SqmUpdateToSqlAstConverterMultiTable;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcUpdate;

public class TableBasedUpdateHandlerImpl
extends AbstractTableBasedHandler
implements UpdateHandler {
    private TableBasedUpdateHandlerImpl(SqmDeleteOrUpdateStatement sqmDeleteOrUpdateStatement, IdTable idTableInfo, IdTableSupport idTableSupport, SessionUidSupport sessionUidSupport, BeforeUseAction beforeUseAction, AfterUseAction afterUseAction, IdTableManagementTransactionality transactionality, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
        super(sqmDeleteOrUpdateStatement, idTableInfo, sessionUidSupport, beforeUseAction, afterUseAction, new IdTableHelper(idTableInfo, idTableSupport, transactionality, creationContext.getSessionFactory().getJdbcServices()), domainParameterXref, creationContext);
    }

    @Override
    public SqmUpdateStatement getSqmDeleteOrUpdateStatement() {
        return (SqmUpdateStatement)super.getSqmDeleteOrUpdateStatement();
    }

    @Override
    protected void performMutations(ExecutionContext executionContext) {
        boolean hasNoSecondaryTables = this.getSqmDeleteOrUpdateStatement().getTarget().getReferencedNavigable().getEntityDescriptor().getSecondaryTableBindings().isEmpty();
        QuerySpec idTableSelectSubQuerySpec = this.createIdTableSubQuery(executionContext);
        SqmUpdateInterpretation interpretation = SqmUpdateToSqlAstConverterMultiTable.interpret(this.getSqmDeleteOrUpdateStatement(), idTableSelectSubQuerySpec, executionContext.getQueryOptions(), DomainParameterXref.empty(), QueryParameterBindings.NO_PARAM_BINDINGS, executionContext.getSession().getFactory());
        for (UpdateStatement sqlUpdateAst : interpretation.getSqlUpdates()) {
            JdbcUpdate jdbcUpdate = UpdateToJdbcUpdateConverter.createJdbcUpdate(sqlUpdateAst, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
            JdbcMutationExecutor.NO_AFTER_STATEMENT_CALL.execute(jdbcUpdate, JdbcParameterBindings.NO_BINDINGS, executionContext);
        }
    }

    public static class Builder {
        private final SqmDeleteOrUpdateStatement sqmStatement;
        private final IdTable idTableInfo;
        private final IdTableSupport idTableSupport;
        private SessionUidSupport sessionUidSupport = SessionUidSupport.NONE;
        private BeforeUseAction beforeUseAction = BeforeUseAction.NONE;
        private AfterUseAction afterUseAction = AfterUseAction.NONE;
        private IdTableManagementTransactionality transactionality = IdTableManagementTransactionality.NONE;

        public Builder(SqmUpdateStatement sqmStatement, IdTable idTableInfo, IdTableSupport idTableSupport) {
            this.sqmStatement = sqmStatement;
            this.idTableInfo = idTableInfo;
            this.idTableSupport = idTableSupport;
        }

        public void setSessionUidSupport(SessionUidSupport sessionUidSupport) {
            this.sessionUidSupport = sessionUidSupport;
        }

        public void setBeforeUseAction(BeforeUseAction beforeUseAction) {
            this.beforeUseAction = beforeUseAction;
        }

        public void setAfterUseAction(AfterUseAction afterUseAction) {
            this.afterUseAction = afterUseAction;
        }

        public void setTransactionality(IdTableManagementTransactionality transactionality) {
            this.transactionality = transactionality;
        }

        public TableBasedUpdateHandlerImpl build(DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
            return new TableBasedUpdateHandlerImpl(this.sqmStatement, this.idTableInfo, this.idTableSupport, this.sessionUidSupport, this.beforeUseAction, this.afterUseAction, this.transactionality, domainParameterXref, creationContext);
        }
    }
}

