/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.inline;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.domain.spi.PluralPersistentAttribute;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.spi.DeleteHandler;
import org.hibernate.query.sqm.mutation.spi.HandlerCreationContext;
import org.hibernate.query.sqm.mutation.spi.inline.AbstractInlineHandler;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SqlDeleteToJdbcDeleteConverter;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcMutation;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class InlineDeleteHandler
extends AbstractInlineHandler
implements DeleteHandler {
    public InlineDeleteHandler(SqmDeleteStatement sqmDeleteStatement, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
        super(sqmDeleteStatement, domainParameterXref, creationContext);
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        List<Object> ids = SqmMutationStrategyHelper.selectMatchingIds(this.getDomainParameterXref(), this.getSqmStatement(), executionContext);
        this.getEntityDescriptor().visitAttributes(attribute -> {
            PluralPersistentAttribute pluralAttribute = (PluralPersistentAttribute)attribute;
            PersistentCollectionDescriptor collectionDescriptor = pluralAttribute.getCollectionDescriptor();
            if (collectionDescriptor.getSeparateCollectionTable() != null) {
                this.executeDelete(collectionDescriptor.getSeparateCollectionTable(), ids, collectionDescriptor.getCollectionKeyDescriptor().getJoinForeignKey().getColumnMappings().getTargetColumns(), collectionDescriptor.getCollectionKeyDescriptor(), executionContext);
            }
        }, attribute -> attribute instanceof PluralPersistentAttribute);
        this.getEntityDescriptor().getHierarchy().visitConstraintOrderedTables((table, columns) -> this.executeDelete((Table)table, ids, (List<Column>)columns, this.getEntityDescriptor().getIdentifierDescriptor(), executionContext));
        return ids.size();
    }

    private void executeDelete(Table table, List<Object> ids, List<Column> columns, Navigable<?> navigable, ExecutionContext executionContext) {
        TableReference tableReference = new TableReference(table, null, false);
        Predicate idRestriction = this.generateRestrictionValuesList(tableReference, ids, columns, navigable, executionContext);
        DeleteStatement deleteStatement = new DeleteStatement(tableReference, idRestriction);
        JdbcDelete jdbcDelete = SqlDeleteToJdbcDeleteConverter.interpret(deleteStatement, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        JdbcMutationExecutor executor = JdbcMutationExecutor.WITH_AFTER_STATEMENT_CALL;
        executor.execute((JdbcMutation)jdbcDelete, JdbcParameterBindings.NO_BINDINGS, executionContext, (rows, preparedStatement) -> {});
    }

    private Predicate generateRestrictionValuesList(TableReference tableReference, List<Object> ids, List<Column> columns, Navigable navigable, ExecutionContext executionContext) {
        InListPredicate restriction;
        if (ids.isEmpty()) {
            return null;
        }
        if (columns.size() > 1) {
            ArrayList keyColumnReferences = CollectionHelper.arrayList(columns.size());
            for (Column column : columns) {
                keyColumnReferences.add(tableReference.resolveColumnReference(column));
            }
            restriction = new InListPredicate(new SqlTuple(keyColumnReferences, navigable));
        } else {
            restriction = new InListPredicate(tableReference.resolveColumnReference(columns.get(0)));
        }
        ArrayList valueListElementExpressions = CollectionHelper.arrayList(columns.size());
        for (Object id : ids) {
            valueListElementExpressions.clear();
            navigable.dehydrate(navigable.unresolve(id, executionContext.getSession()), (jdbcValue, type, boundColumn) -> valueListElementExpressions.add(new QueryLiteral(jdbcValue, type, Clause.WHERE)), Clause.WHERE, executionContext.getSession());
            if (columns.size() > 1) {
                restriction.addExpression(new SqlTuple(valueListElementExpressions, navigable));
                continue;
            }
            restriction.addExpression((Expression)valueListElementExpressions.get(0));
        }
        return restriction;
    }
}

