/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.spi.simple;

import java.util.Collections;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.consume.internal.SqmConsumeHelper;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.spi.AbstractMutationHandler;
import org.hibernate.query.sqm.mutation.spi.DeleteHandler;
import org.hibernate.query.sqm.mutation.spi.HandlerCreationContext;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.sql.ast.consume.spi.SqlDeleteToJdbcDeleteConverter;
import org.hibernate.sql.ast.produce.internal.SqlAstDeleteDescriptorImpl;
import org.hibernate.sql.ast.produce.sqm.spi.SqmDeleteToSqlAstConverterSimple;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.exec.internal.JdbcMutationExecutorImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class SimpleDeleteHandler
extends AbstractMutationHandler
implements DeleteHandler {
    private final DomainParameterXref domainParameterXref;

    protected SimpleDeleteHandler(SqmDeleteStatement sqmStatement, DomainParameterXref domainParameterXref, HandlerCreationContext creationContext) {
        super(sqmStatement, creationContext);
        this.domainParameterXref = domainParameterXref;
    }

    @Override
    public SqmDeleteStatement getSqmDeleteOrUpdateStatement() {
        return (SqmDeleteStatement)super.getSqmDeleteOrUpdateStatement();
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        SqmDeleteToSqlAstConverterSimple sqmConverter = new SqmDeleteToSqlAstConverterSimple(executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), executionContext.getSession());
        DeleteStatement deleteStatement = sqmConverter.visitDeleteStatement(this.getSqmDeleteOrUpdateStatement());
        JdbcParameterBindings jdbcParameterBindings = QueryHelper.createJdbcParameterBindings(executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), this.domainParameterXref, SqmConsumeHelper.generateJdbcParamsXref(this.domainParameterXref, sqmConverter), executionContext.getSession());
        JdbcDelete jdbcDelete = SqlDeleteToJdbcDeleteConverter.interpret(new SqlAstDeleteDescriptorImpl(deleteStatement, Collections.singleton(deleteStatement.getTargetTable().getTable().getTableExpression())), (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        return JdbcMutationExecutorImpl.WITH_AFTER_STATEMENT_CALL.execute(jdbcDelete, jdbcParameterBindings, executionContext);
    }
}

